/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.AuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.FeaturesPanel;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class ServerAccessPreference
extends DefaultTabPreferenceSetting {
    private final OsmApiUrlInputPanel pnlApiUrlPreferences = new OsmApiUrlInputPanel();
    private final AuthenticationPreferencesPanel pnlAuthPreferences = new AuthenticationPreferencesPanel();
    private final FeaturesPanel pnlFeaturesPreferences = new FeaturesPanel();
    private final OverpassServerPanel pnlOverpassPreferences = new OverpassServerPanel();

    private ServerAccessPreference() {
        super("connection", I18n.tr("OSM Server", new Object[0]), I18n.tr("Connection Settings for the OSM server.", new Object[0]));
    }

    public void addApiUrlChangeListener(PropertyChangeListener listener) {
        this.pnlApiUrlPreferences.addPropertyChangeListener(listener);
    }

    private static GBC eopFilledHorizontal() {
        return GBC.eop().fill(2);
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.pnlApiUrlPreferences, ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)new JSeparator(), ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)this.pnlAuthPreferences, ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)new JSeparator(), ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)this.pnlFeaturesPreferences, ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)new JSeparator(), ServerAccessPreference.eopFilledHorizontal());
        panel.add((Component)this.pnlOverpassPreferences, ServerAccessPreference.eopFilledHorizontal());
        this.pnlApiUrlPreferences.initFromPreferences();
        this.pnlAuthPreferences.initFromPreferences();
        this.pnlFeaturesPreferences.initFromPreferences();
        this.pnlOverpassPreferences.initFromPreferences();
        this.addApiUrlChangeListener(this.pnlAuthPreferences);
        HelpUtil.setHelpContext(panel, HelpUtil.ht("/Preferences/Connection"));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill());
        this.createPreferenceTabWithScrollPane(gui, panel);
    }

    @Override
    public boolean ok() {
        this.pnlApiUrlPreferences.saveToPreferences();
        this.pnlAuthPreferences.saveToPreferences();
        this.pnlFeaturesPreferences.saveToPreferences();
        this.pnlOverpassPreferences.saveToPreferences();
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Connection");
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

