/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.projection.Projection;

public abstract class AbstractWMSTileSource
extends TMSTileSource {
    static final NumberFormat LATLON_FORMAT = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private EastNorth anchorPosition;
    private int[] tileXMin;
    private int[] tileYMin;
    private int[] tileXMax;
    private int[] tileYMax;
    private double[] degreesPerTile;
    private static final double SCALE_DENOMINATOR_ZOOM_LEVEL_1 = 5.59082264028718E8;
    private Projection tileProjection;

    protected AbstractWMSTileSource(TileSourceInfo info, Projection tileProjection) {
        super(info);
        this.tileProjection = tileProjection;
    }

    private void initAnchorPosition(Projection proj) {
        Bounds worldBounds = proj.getWorldBoundsLatLon();
        EastNorth min = proj.latlon2eastNorth(worldBounds.getMin());
        EastNorth max = proj.latlon2eastNorth(worldBounds.getMax());
        this.anchorPosition = new EastNorth(min.east(), max.north());
    }

    public void setTileProjection(Projection tileProjection) {
        this.tileProjection = tileProjection;
        this.initProjection();
    }

    public Projection getTileProjection() {
        return this.tileProjection;
    }

    public void initProjection() {
        this.initProjection(this.tileProjection);
    }

    public void initProjection(Projection proj) {
        this.initAnchorPosition(proj);
        ProjectionBounds worldBounds = proj.getWorldBoundsBoxEastNorth();
        EastNorth topLeft = new EastNorth(worldBounds.getMin().east(), worldBounds.getMax().north());
        EastNorth bottomRight = new EastNorth(worldBounds.getMax().east(), worldBounds.getMin().north());
        double crsScale = 0.07168 / proj.getMetersPerUnit();
        this.tileXMin = new int[this.getMaxZoom() + 1];
        this.tileYMin = new int[this.getMaxZoom() + 1];
        this.tileXMax = new int[this.getMaxZoom() + 1];
        this.tileYMax = new int[this.getMaxZoom() + 1];
        this.degreesPerTile = new double[this.getMaxZoom() + 1];
        for (int zoom = 1; zoom <= this.getMaxZoom(); ++zoom) {
            this.degreesPerTile[zoom] = 5.59082264028718E8 / Math.pow(2.0, (double)zoom - 1.0) * crsScale;
            TileXY minTileIndex = this.eastNorthToTileXY(topLeft, zoom);
            this.tileXMin[zoom] = minTileIndex.getXIndex();
            this.tileYMin[zoom] = minTileIndex.getYIndex();
            TileXY maxTileIndex = this.eastNorthToTileXY(bottomRight, zoom);
            this.tileXMax[zoom] = maxTileIndex.getXIndex();
            this.tileYMax[zoom] = maxTileIndex.getYIndex();
        }
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        return CoordinateConversion.llToCoor(this.tileProjection.eastNorth2latlon(this.getTileEastNorth(x, y, zoom)));
    }

    private TileXY eastNorthToTileXY(EastNorth enPoint, int zoom) {
        double scale = this.getDegreesPerTile(zoom);
        return new TileXY((enPoint.east() - this.anchorPosition.east()) / scale, (this.anchorPosition.north() - enPoint.north()) / scale);
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        EastNorth enPoint = this.tileProjection.latlon2eastNorth(new LatLon(lat, lon));
        return this.eastNorthToTileXY(enPoint, zoom);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public int getTileXMax(int zoom) {
        return this.tileXMax[zoom];
    }

    @Override
    public int getTileXMin(int zoom) {
        return this.tileXMin[zoom];
    }

    @Override
    public int getTileYMax(int zoom) {
        return this.tileYMax[zoom];
    }

    @Override
    public int getTileYMin(int zoom) {
        return this.tileYMin[zoom];
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        double scale = this.getDegreesPerTile(zoom) / (double)this.getTileSize();
        EastNorth point = this.tileProjection.latlon2eastNorth(new LatLon(lat, lon));
        return new Point((int)Math.round((point.east() - this.anchorPosition.east()) / scale), (int)Math.round((this.anchorPosition.north() - point.north()) / scale));
    }

    @Override
    public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public ICoordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    @Override
    public ICoordinate xyToLatLon(int x, int y, int zoom) {
        double scale = this.getDegreesPerTile(zoom) / (double)this.getTileSize();
        EastNorth ret = new EastNorth(this.anchorPosition.east() + (double)x * scale, this.anchorPosition.north() - (double)y * scale);
        return CoordinateConversion.llToCoor(this.tileProjection.eastNorth2latlon(ret));
    }

    protected EastNorth getTileEastNorth(int x, int y, int z) {
        double scale = this.getDegreesPerTile(z);
        return new EastNorth(this.anchorPosition.east() + (double)x * scale, this.anchorPosition.north() - (double)y * scale);
    }

    private double getDegreesPerTile(int zoom) {
        return this.degreesPerTile[zoom];
    }

    @Override
    public IProjected tileXYtoProjected(int x, int y, int zoom) {
        EastNorth en = this.getTileEastNorth(x, y, zoom);
        return new Projected(en.east(), en.north());
    }

    @Override
    public TileXY projectedToTileXY(IProjected p, int zoom) {
        return this.eastNorthToTileXY(new EastNorth(p.getEast(), p.getNorth()), zoom);
    }

    @Override
    public String getServerCRS() {
        return this.tileProjection.toCode();
    }

    protected String getBbox(int zoom, int tilex, int tiley, boolean switchLatLon) {
        EastNorth nw = this.getTileEastNorth(tilex, tiley, zoom);
        EastNorth se = this.getTileEastNorth(tilex + 1, tiley + 1, zoom);
        double w = nw.getX();
        double n = nw.getY();
        double s = se.getY();
        double e = se.getX();
        return switchLatLon ? AbstractWMSTileSource.getBboxstr(s, w, n, e) : AbstractWMSTileSource.getBboxstr(w, s, e, n);
    }

    private static String getBboxstr(double x1, double x2, double x3, double x4) {
        return new StringBuilder(64).append(LATLON_FORMAT.format(x1)).append(',').append(LATLON_FORMAT.format(x2)).append(',').append(LATLON_FORMAT.format(x3)).append(',').append(LATLON_FORMAT.format(x4)).toString();
    }
}

