/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetAware;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.DownloadChangesetContentAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.OpenChangesetPopupMenu;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetDetailPanel
extends JPanel
implements PropertyChangeListener,
ChangesetAware,
Destroyable {
    private final JosmTextField tfID = new JosmTextField(null, null, 10, false);
    private final JosmTextArea taComment = new JosmTextArea(5, 40);
    private final JosmTextField tfOpen = new JosmTextField(null, null, 10, false);
    private final JosmTextField tfUser = new JosmTextField(null, "", 0);
    private final JosmTextField tfCreatedOn = new JosmTextField(null, null, 20, false);
    private final JosmTextField tfClosedOn = new JosmTextField(null, null, 20, false);
    private final OpenChangesetPopupMenuAction actOpenChangesetPopupMenu = new OpenChangesetPopupMenuAction();
    private final DownloadChangesetContentAction actDownloadChangesetContent = new DownloadChangesetContentAction(this);
    private final UpdateChangesetAction actUpdateChangesets = new UpdateChangesetAction();
    private final RemoveFromCacheAction actRemoveFromCache = new RemoveFromCacheAction();
    private final SelectInCurrentLayerAction actSelectInCurrentLayer = new SelectInCurrentLayerAction();
    private final ZoomInCurrentLayerAction actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
    private JButton btnOpenChangesetPopupMenu;
    private transient Changeset currentChangeset;

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        this.btnOpenChangesetPopupMenu = tb.add(this.actOpenChangesetPopupMenu);
        this.actOpenChangesetPopupMenu.initProperties(this.currentChangeset);
        tb.add(this.actRemoveFromCache);
        this.actRemoveFromCache.initProperties(this.currentChangeset);
        tb.add(this.actUpdateChangesets);
        this.actUpdateChangesets.initProperties(this.currentChangeset);
        tb.add(this.actDownloadChangesetContent);
        this.actDownloadChangesetContent.initProperties();
        tb.add(this.actSelectInCurrentLayer);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actSelectInCurrentLayer);
        tb.add(this.actZoomInCurrentLayerAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actZoomInCurrentLayerAction);
        pnl.add(tb);
        return pnl;
    }

    protected JPanel buildDetailViewPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 23;
        gc.insets = new Insets(0, 0, 2, 3);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("ID:", new Object[0])), gc);
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridx = 1;
        pnl.add((Component)this.tfID, gc);
        this.tfID.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Comment:", new Object[0])), gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 1;
        pnl.add((Component)this.taComment, gc);
        this.taComment.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Open/Closed:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfOpen, gc);
        this.tfOpen.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Author:", new Object[0])), gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 1;
        pnl.add((Component)this.tfUser, gc);
        this.tfUser.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Created at:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfCreatedOn, gc);
        this.tfCreatedOn.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Closed at:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfClosedOn, gc);
        this.tfClosedOn.setEditable(false);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildDetailViewPanel(), "Center");
        this.add((Component)this.buildActionButtonPanel(), "West");
    }

    protected void clearView() {
        this.tfID.setText("");
        this.taComment.setText("");
        this.tfOpen.setText("");
        this.tfUser.setText("");
        this.tfCreatedOn.setText("");
        this.tfClosedOn.setText("");
    }

    protected void updateView(Changeset cs) {
        if (cs == null) {
            return;
        }
        this.tfID.setText(Integer.toString(cs.getId()));
        this.taComment.setText(cs.getComment());
        String msg = cs.isOpen() ? I18n.trc("changeset.state", "Open") : I18n.trc("changeset.state", "Closed");
        this.tfOpen.setText(msg);
        msg = cs.getUser() == null ? I18n.tr("anonymous", new Object[0]) : cs.getUser().getName();
        this.tfUser.setText(msg);
        DateFormat sdf = DateUtils.getDateTimeFormat(3, 3);
        Date createdDate = cs.getCreatedAt();
        Date closedDate = cs.getClosedAt();
        this.tfCreatedOn.setText(createdDate == null ? "" : sdf.format(createdDate));
        this.tfClosedOn.setText(closedDate == null ? "" : sdf.format(closedDate));
    }

    public ChangesetDetailPanel() {
        this.build();
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.currentChangeset = cs;
        if (cs == null) {
            this.clearView();
        } else {
            this.updateView(cs);
        }
        this.actOpenChangesetPopupMenu.initProperties(this.currentChangeset);
        this.actDownloadChangesetContent.initProperties();
        this.actUpdateChangesets.initProperties(this.currentChangeset);
        this.actRemoveFromCache.initProperties(this.currentChangeset);
        this.actSelectInCurrentLayer.updateEnabledState();
        this.actZoomInCurrentLayerAction.updateEnabledState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.setCurrentChangeset((Changeset)evt.getNewValue());
    }

    @Override
    public Changeset getCurrentChangeset() {
        return this.currentChangeset;
    }

    @Override
    public void destroy() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.actSelectInCurrentLayer);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.actZoomInCurrentLayerAction);
    }

    class OpenChangesetPopupMenuAction
    extends AbstractAction {
        OpenChangesetPopupMenuAction() {
            this.putValue("Name", I18n.tr("View changeset", new Object[0]));
            new ImageProvider("help/internet").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.currentChangeset != null) {
                new OpenChangesetPopupMenu(ChangesetDetailPanel.this.currentChangeset.getId(), null).show(ChangesetDetailPanel.this.btnOpenChangesetPopupMenu);
            }
        }

        void initProperties(Changeset cs) {
            this.setEnabled(cs != null);
        }
    }

    class RemoveFromCacheAction
    extends AbstractAction {
        RemoveFromCacheAction() {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Remove the changeset in the detail view panel from the local cache", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetCache.getInstance().remove(ChangesetDetailPanel.this.currentChangeset);
        }

        public void initProperties(Changeset cs) {
            this.setEnabled(cs != null);
        }
    }

    class UpdateChangesetAction
    extends AbstractAction {
        UpdateChangesetAction() {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Update the changeset from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetHeaderDownloadTask task = new ChangesetHeaderDownloadTask(ChangesetDetailPanel.this, Collections.singleton(ChangesetDetailPanel.this.currentChangeset.getId()));
            MainApplication.worker.submit(new PostDownloadHandler(task, task.download()));
        }

        public void initProperties(Changeset cs) {
            this.setEnabled(cs != null && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }

    class SelectInCurrentLayerAction
    extends AbstractAction
    implements MainLayerManager.ActiveLayerChangeListener {
        SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            new ImageProvider("dialogs", "select").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Select the primitives in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToSelect() {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.currentChangeset.getId(), Utils.escapeReservedCharactersHTML(MainApplication.getLayerManager().getActiveDataSet().getName())), I18n.tr("Nothing to select", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds == null) {
                return;
            }
            Set target = ds.allPrimitives().stream().filter(p -> p.isUsable() && p.getChangesetId() == ChangesetDetailPanel.this.currentChangeset.getId()).collect(Collectors.toSet());
            if (target.isEmpty()) {
                this.alertNoPrimitivesToSelect();
                return;
            }
            ds.setSelected(target);
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getActiveDataSet() != null && ChangesetDetailPanel.this.currentChangeset != null);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.updateEnabledState();
        }
    }

    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements MainLayerManager.ActiveLayerChangeListener {
        ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            new ImageProvider("dialogs/autoscale", "selection").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Zoom to the objects in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToZoomTo() {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.currentChangeset.getId(), MainApplication.getLayerManager().getActiveDataSet().getName()), I18n.tr("Nothing to zoom to", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds == null) {
                return;
            }
            Set target = ds.allPrimitives().stream().filter(p -> p.isUsable() && p.getChangesetId() == ChangesetDetailPanel.this.currentChangeset.getId()).collect(Collectors.toSet());
            if (target.isEmpty()) {
                this.alertNoPrimitivesToZoomTo();
                return;
            }
            ds.setSelected(target);
            AutoScaleAction.zoomToSelection();
        }

        public void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getActiveDataSet() != null && ChangesetDetailPanel.this.currentChangeset != null);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.updateEnabledState();
        }
    }
}

