/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class RestartAction
extends JosmAction {
    private static final String APPLE_OSASCRIPT = "/usr/bin/osascript";
    private static final String APPLE_APP_PATH = "/JOSM.app/Contents/";
    private static final String RESTART_APPLE_SCRIPT = "tell application \"System Events\"\nrepeat until not (exists process \"JOSM\")\ndelay 0.2\nend repeat\nend tell\ntell application \"JOSM\" to activate";
    private static final List<String> cmd = RestartAction.determineRestartCommands();

    public RestartAction() {
        super(I18n.tr("Restart", new Object[0]), "restart", I18n.tr("Restart the application.", new Object[0]), Shortcut.registerShortcut("file:restart", I18n.tr("File: {0}", I18n.tr("Restart", new Object[0])), 74, 5010), false, false);
        this.setHelpId(HelpUtil.ht("/Action/Restart"));
        this.setToolbarId("action/restart");
        if (MainApplication.getToolbar() != null) {
            MainApplication.getToolbar().register(this);
        }
        this.setEnabled(RestartAction.isRestartSupported());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RestartAction.restartJOSM();
    }

    public static boolean isRestartSupported() {
        return !cmd.isEmpty();
    }

    public static void restartJOSM() {
        String scriptRestart = Utils.getSystemProperty("josm.restart");
        if ("true".equals(scriptRestart)) {
            MainApplication.exitJosm(true, 9, SaveLayersDialog.Reason.RESTART);
        }
        if (RestartAction.isDebugSimulation()) {
            RestartAction.logEnvironment();
        }
        Logging.info("Restart " + cmd);
        if (RestartAction.isDebugSimulation()) {
            Logging.debug("Restart cancelled to get debug info");
            return;
        }
        if (!RestartAction.isRestartSupported()) {
            return;
        }
        if (!MainApplication.exitJosm(false, 0, SaveLayersDialog.Reason.RESTART)) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread("josm-restarter"){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(cmd.toArray(new String[0]));
                }
                catch (IOException e) {
                    Logging.error(e);
                }
            }
        });
        System.exit(0);
    }

    private static boolean isDebugSimulation() {
        return Logging.isDebugEnabled() && Config.getPref().getBoolean("restart.debug.simulation");
    }

    private static void logEnvironment() {
        RestartAction.logEnvironmentVariable("java.home");
        RestartAction.logEnvironmentVariable("java.class.path");
        RestartAction.logEnvironmentVariable("java.library.path");
        RestartAction.logEnvironmentVariable("jnlpx.origFilenameArg");
        RestartAction.logEnvironmentVariable("sun.java.command");
    }

    private static void logEnvironmentVariable(String var) {
        Logging.debug("{0}: {1}", var, Utils.getSystemProperty(var));
    }

    private static boolean isExecutableFile(File f) {
        try {
            return f.isFile() && f.canExecute();
        }
        catch (SecurityException e) {
            Logging.error(e);
            return false;
        }
    }

    private static List<String> determineRestartCommands() {
        try {
            if (PlatformManager.isPlatformOsx() && (Utils.getSystemProperty("java.library.path").contains(APPLE_APP_PATH) || Utils.getSystemProperty("java.class.path").contains(APPLE_APP_PATH))) {
                return RestartAction.getAppleCommands();
            }
            return RestartAction.getCommands();
        }
        catch (IOException e) {
            Logging.error(e);
            return Collections.emptyList();
        }
    }

    private static List<String> getAppleCommands() throws IOException {
        if (!RestartAction.isExecutableFile(new File(APPLE_OSASCRIPT))) {
            throw new IOException("Unable to find suitable osascript at /usr/bin/osascript");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(APPLE_OSASCRIPT);
        for (String line : RESTART_APPLE_SCRIPT.split("\n", -1)) {
            cmd.add("-e");
            cmd.add(line);
        }
        return cmd;
    }

    private static List<String> getCommands() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(RestartAction.getJavaRuntime());
        RestartAction.addVMArguments(cmd);
        String jnlp = Utils.getSystemProperty("jnlpx.origFilenameArg");
        String javaCommand = Utils.getSystemProperty("sun.java.command");
        if (javaCommand == null) {
            throw new IOException("Unable to retrieve sun.java.command property");
        }
        String[] mainCommand = javaCommand.split(" ", -1);
        if (javaCommand.endsWith(".jnlp") && jnlp == null) {
            Logging.debug("Detected jnlp without jnlpx.origFilenameArg property set");
            cmd.addAll(Arrays.asList(mainCommand));
        } else {
            StringBuilder sb = new StringBuilder(mainCommand[0]);
            for (int i = 1; i < mainCommand.length && !mainCommand[i - 1].endsWith(".jar"); ++i) {
                sb.append(' ').append(mainCommand[i]);
            }
            String jarPath = sb.toString();
            if (jarPath.endsWith(".jar")) {
                cmd.add("-jar");
                cmd.add(new File(jarPath).getPath());
            } else {
                cmd.add("-cp");
                cmd.add('\"' + Utils.getSystemProperty("java.class.path") + '\"');
                cmd.add(mainCommand[0].replace("jdk.plugin/", ""));
            }
            if (jnlp != null) {
                cmd.add(jnlp);
            }
        }
        cmd.addAll(MainApplication.getCommandLineArgs());
        return cmd;
    }

    private static String getJavaRuntime() throws IOException {
        String java = Utils.getSystemProperty("java.home") + File.separator + "bin" + File.separator + (PlatformManager.isPlatformWindows() ? "java.exe" : "java");
        if (!RestartAction.isExecutableFile(new File(java))) {
            throw new IOException("Unable to find suitable java runtime at " + java);
        }
        return java;
    }

    private static void addVMArguments(Collection<String> cmd) {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Logging.debug("VM arguments: {0}", arguments);
        for (String arg : arguments) {
            if ((arg = arg.replace("-Djnlpx.remove=true", "-Djnlpx.remove=false")).contains("-agentlib")) continue;
            cmd.add(arg);
        }
    }

    public static HelpAwareOptionPane.ButtonSpec getRestartButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Restart", new Object[0]), ImageProvider.get("restart", ImageProvider.ImageSizes.LARGEICON), I18n.tr("Restart the application.", new Object[0]), HelpUtil.ht("/Action/Restart"), RestartAction.isRestartSupported());
    }

    public static HelpAwareOptionPane.ButtonSpec getCancelButtonSpec() {
        return new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to restart later.", new Object[0]), null);
    }

    public static HelpAwareOptionPane.ButtonSpec[] getButtonSpecs() {
        return new HelpAwareOptionPane.ButtonSpec[]{RestartAction.getRestartButtonSpec(), RestartAction.getCancelButtonSpec()};
    }
}

