/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Stylable;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.tools.LanguageInfo;

public interface IPrimitive
extends IQuadBucketType,
Tagged,
PrimitiveId,
Stylable,
Comparable<IPrimitive> {
    public boolean isModified();

    public void setModified(boolean var1);

    public boolean isVisible();

    public void setVisible(boolean var1);

    public boolean isDeleted();

    public void setDeleted(boolean var1);

    public boolean isIncomplete();

    public boolean isUndeleted();

    public boolean isUsable();

    public boolean isNewOrUndeleted();

    default public boolean isDisabled() {
        return false;
    }

    default public boolean isDisabledAndHidden() {
        return false;
    }

    default public boolean isPreserved() {
        return false;
    }

    default public boolean isSelectable() {
        return true;
    }

    default public boolean isDrawable() {
        return true;
    }

    default public boolean isSelected() {
        return false;
    }

    default public boolean isMemberOfSelected() {
        return false;
    }

    default public boolean isOuterMemberOfSelected() {
        return false;
    }

    public long getId();

    default public long getOsmId() {
        return this.getId();
    }

    default public PrimitiveId getOsmPrimitiveId() {
        return new SimplePrimitiveId(this.getOsmId(), this.getType());
    }

    default public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    public int getVersion();

    public void setOsmId(long var1, int var3);

    public User getUser();

    public void setUser(User var1);

    @Deprecated
    public Date getTimestamp();

    public Instant getInstant();

    public int getRawTimestamp();

    @Deprecated
    public void setTimestamp(Date var1);

    public void setInstant(Instant var1);

    public void setRawTimestamp(int var1);

    public boolean isTimestampEmpty();

    public int getChangesetId();

    public void setChangesetId(int var1);

    public void accept(PrimitiveVisitor var1);

    public void visitReferrers(PrimitiveVisitor var1);

    default public String getName() {
        return this.get("name");
    }

    default public String getLocalName() {
        for (String s : LanguageInfo.getLanguageCodes(null)) {
            String val = this.get("name:" + s);
            if (val == null) continue;
            return val;
        }
        return this.getName();
    }

    default public Object getStyleCacheSyncObject() {
        return this;
    }

    public String getDisplayName(NameFormatter var1);

    default public OsmPrimitiveType getDisplayType() {
        return this.getType();
    }

    public void setHighlighted(boolean var1);

    public boolean isHighlighted();

    public boolean isTagged();

    public boolean isAnnotated();

    default public boolean isMultipolygon() {
        return false;
    }

    public boolean hasDirectionKeys();

    public boolean reversedDirection();

    @Override
    public BBox getBBox();

    default public List<? extends IPrimitive> getReferrers() {
        return this.getReferrers(false);
    }

    public List<? extends IPrimitive> getReferrers(boolean var1);

    public OsmData<?, ?, ?, ?> getDataSet();

    public Map<String, String> getInterestingTags();

    default public boolean hasSameInterestingTags(IPrimitive other) {
        return !this.hasKeys() && !other.hasKeys() || this.getInterestingTags().equals(other.getInterestingTags());
    }

    public static void resetPrimitiveChildren(IPrimitive p) {
        if (p instanceof IWay) {
            ((IWay)p).setNodes(null);
        } else if (p instanceof IRelation) {
            ((IRelation)p).setMembers(null);
        }
    }
}

