/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.util.ArrayList;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;

public class ProtobufPacked {
    private final byte[] bytes;
    private final Number[] numbers;
    private int location = 0;

    public ProtobufPacked(byte[] bytes) {
        this.bytes = bytes;
        ArrayList<Number> numbersT = new ArrayList<Number>();
        while (this.location < bytes.length) {
            numbersT.add(ProtobufParser.convertByteArray(this.nextVarInt(), (byte)7));
        }
        this.numbers = new Number[numbersT.size()];
        for (int i = 0; i < numbersT.size(); ++i) {
            this.numbers[i] = (Number)numbersT.get(i);
        }
    }

    public Number[] getArray() {
        return this.numbers;
    }

    private byte[] nextVarInt() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while ((this.bytes[this.location] & 0xFFFFFF80) == -128) {
            byteList.add((byte)(this.bytes[this.location++] ^ 0xFFFFFF80));
        }
        byteList.add(this.bytes[this.location++]);
        byte[] byteArray = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            byteArray[i] = (Byte)byteList.get(i);
        }
        return byteArray;
    }
}

