/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.gui.io.importexport.Options;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class OpenFileHandler
extends RequestHandler {
    public static final String command = "open_file";

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"filename"};
    }

    @Override
    public String getUsage() {
        return "opens a local file in JOSM";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/open_file?filename=/tmp/test.osm"};
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.OPEN_FILES;
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        EnumSet<Options> options = EnumSet.noneOf(Options.class);
        if (PermissionPrefWithDefault.ALLOW_WEB_RESOURCES.isAllowed()) {
            options.add(Options.ALLOW_WEB_RESOURCES);
        }
        GuiHelper.runInEDT(() -> OpenFileAction.openFiles(Arrays.asList(new File((String)this.args.get("filename"))), options.toArray(new Options[0])));
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to open a local file.", new Object[0]);
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
    }
}

