/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPDiscoveryListener
implements IDiscoveryListener {
    private static final Log log = LogFactory.getLog(LateralTCPDiscoveryListener.class);
    private final Map<String, LateralCacheNoWaitFacade<?, ?>> facades = Collections.synchronizedMap(new HashMap());
    private final Set<String> knownDifferentlyConfiguredRegions = Collections.synchronizedSet(new HashSet());
    private String factoryName;
    private ICompositeCacheManager cacheManager;

    protected LateralTCPDiscoveryListener(String factoryName, ICompositeCacheManager cacheManager) {
        this.factoryName = factoryName;
        this.cacheManager = cacheManager;
    }

    public synchronized boolean addNoWaitFacade(String cacheName, LateralCacheNoWaitFacade<?, ?> facade) {
        boolean isNew = !this.containsNoWaitFacade(cacheName);
        this.facades.put(cacheName, facade);
        this.knownDifferentlyConfiguredRegions.remove(cacheName);
        return isNew;
    }

    public boolean containsNoWaitFacade(String cacheName) {
        return this.facades.containsKey(cacheName);
    }

    public <K, V> boolean containsNoWait(String cacheName, LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (facade == null) {
            return false;
        }
        return facade.containsNoWait(noWait);
    }

    protected <K, V> boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug("addNoWait > Got facade for " + noWait.getCacheName() + " = " + facade);
        }
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug("Called addNoWait, isNew = " + isNew);
            }
            return isNew;
        }
        if (!this.knownDifferentlyConfiguredRegions.contains(noWait.getCacheName())) {
            if (log.isInfoEnabled()) {
                log.info("addNoWait > Different nodes are configured differently or region [" + noWait.getCacheName() + "] is not yet used on this side.  ");
            }
            this.knownDifferentlyConfiguredRegions.add(noWait.getCacheName());
        }
        return false;
    }

    protected <K, V> boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug("removeNoWait > Got facade for " + noWait.getCacheName() + " = " + facade);
        }
        if (facade != null) {
            boolean removed = facade.removeNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug("Called removeNoWait, removed " + removed);
            }
            return removed;
        }
        if (!this.knownDifferentlyConfiguredRegions.contains(noWait.getCacheName())) {
            if (log.isInfoEnabled()) {
                log.info("removeNoWait > Different nodes are configured differently or region [" + noWait.getCacheName() + "] is not yet used on this side.  ");
            }
            this.knownDifferentlyConfiguredRegions.add(noWait.getCacheName());
        }
        return false;
    }

    @Override
    public void addDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                ITCPLateralCacheAttributes lca;
                AuxiliaryCacheAttributes aca;
                AuxiliaryCache ic = this.cacheManager.getAuxiliaryCache(this.factoryName, cacheName);
                if (log.isDebugEnabled()) {
                    log.debug("Got cache, ic = " + ic);
                }
                if (ic == null || (aca = ic.getAuxiliaryCacheAttributes()) instanceof ITCPLateralCacheAttributes && ((lca = (ITCPLateralCacheAttributes)aca).getTransmissionType() != ILateralCacheAttributes.Type.TCP || !serverAndPort.equals(lca.getTcpServer()))) continue;
                this.addNoWait((LateralCacheNoWait)ic);
                if (!log.isDebugEnabled()) continue;
                log.debug("Called addNoWait for cacheName [" + cacheName + "]");
            }
        } else {
            log.warn("No cache names found in message " + service);
        }
    }

    @Override
    public void removeDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                ITCPLateralCacheAttributes lca;
                AuxiliaryCacheAttributes aca;
                AuxiliaryCache ic = this.cacheManager.getAuxiliaryCache(this.factoryName, cacheName);
                if (log.isDebugEnabled()) {
                    log.debug("Got cache, ic = " + ic);
                }
                if (ic == null || (aca = ic.getAuxiliaryCacheAttributes()) instanceof ITCPLateralCacheAttributes && ((lca = (ITCPLateralCacheAttributes)aca).getTransmissionType() != ILateralCacheAttributes.Type.TCP || !serverAndPort.equals(lca.getTcpServer()))) continue;
                this.removeNoWait((LateralCacheNoWait)ic);
                if (!log.isDebugEnabled()) continue;
                log.debug("Called removeNoWait for cacheName [" + cacheName + "]");
            }
        } else {
            log.warn("No cache names found in message " + service);
        }
    }
}

