/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.ConditionalKeys;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class TurnrestrictionTest
extends Test {
    protected static final int NO_VIA = 1801;
    protected static final int NO_FROM = 1802;
    protected static final int NO_TO = 1803;
    protected static final int MORE_VIA = 1804;
    protected static final int MORE_FROM = 1805;
    protected static final int MORE_TO = 1806;
    protected static final int UNEXPECTED_ROLE = 1807;
    protected static final int UNEXPECTED_TYPE = 1808;
    protected static final int FROM_VIA_NODE = 1809;
    protected static final int TO_VIA_NODE = 1810;
    protected static final int FROM_VIA_WAY = 1811;
    protected static final int TO_VIA_WAY = 1812;
    protected static final int MIX_VIA = 1813;
    protected static final int UNCONNECTED_VIA = 1814;
    protected static final int SUPERFLUOUS = 1815;
    protected static final int FROM_EQUALS_TO = 1816;
    protected static final int UNKNOWN_RESTRICTION = 1817;
    protected static final int TO_CLOSED_WAY = 1818;
    protected static final int FROM_CLOSED_WAY = 1819;
    private static final List<String> SUPPORTED_RESTRICTIONS = Arrays.asList("no_right_turn", "no_left_turn", "no_u_turn", "no_straight_on", "only_right_turn", "only_left_turn", "only_straight_on", "no_entry", "no_exit");

    public TurnrestrictionTest() {
        super(I18n.tr("Turn restrictions", new Object[0]), I18n.tr("This test checks if turn restrictions are valid.", new Object[0]));
    }

    private static boolean hasSupportedRestrictionTag(Relation r) {
        if (r.hasTag("restriction", SUPPORTED_RESTRICTIONS)) {
            return true;
        }
        String conditionalValue = r.get("restriction:conditional");
        if (conditionalValue != null) {
            try {
                List<ConditionalKeys.ConditionalValue> values = ConditionalKeys.ConditionalValue.parse(conditionalValue);
                return !values.isEmpty() && SUPPORTED_RESTRICTIONS.contains(values.get((int)0).restrictionValue);
            }
            catch (ConditionalKeys.ConditionalParsingException e) {
                Logging.trace(e);
            }
        }
        return false;
    }

    @Override
    public void visit(Relation r) {
        if (!r.hasTag("type", "restriction")) {
            return;
        }
        if (!TurnrestrictionTest.hasSupportedRestrictionTag(r)) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1817).message(I18n.tr("Unknown turn restriction", new Object[0])).primitives(r).build());
            return;
        }
        Way fromWay = null;
        Way toWay = null;
        ArrayList<OsmPrimitive> via = new ArrayList<OsmPrimitive>();
        boolean morefrom = false;
        boolean moreto = false;
        boolean morevia = false;
        boolean mixvia = false;
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete()) {
                return;
            }
            ArrayList<OsmPrimitive> l = new ArrayList<OsmPrimitive>();
            l.add(r);
            l.add(m.getMember());
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) continue;
                switch (m.getRole()) {
                    case "from": {
                        if (fromWay != null) {
                            morefrom = true;
                            break;
                        }
                        fromWay = w;
                        break;
                    }
                    case "to": {
                        if (toWay != null) {
                            moreto = true;
                            break;
                        }
                        toWay = w;
                        break;
                    }
                    case "via": {
                        if (!via.isEmpty() && via.get(0) instanceof Node) {
                            mixvia = true;
                            break;
                        }
                        via.add(w);
                        break;
                    }
                    default: {
                        this.errors.add(TestError.builder(this, Severity.WARNING, 1807).message(I18n.tr("Unexpected role ''{0}'' in turn restriction", m.getRole())).primitives(l).highlight(m.getMember()).build());
                        break;
                    }
                }
                continue;
            }
            if (m.isNode()) {
                Node n = m.getNode();
                if ("via".equals(m.getRole())) {
                    if (!via.isEmpty()) {
                        if (via.get(0) instanceof Node) {
                            morevia = true;
                            continue;
                        }
                        mixvia = true;
                        continue;
                    }
                    via.add(n);
                    continue;
                }
                this.errors.add(TestError.builder(this, Severity.WARNING, 1807).message(I18n.tr("Unexpected role ''{0}'' in turn restriction", m.getRole())).primitives(l).highlight(m.getMember()).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1808).message(I18n.tr("Unexpected member type in turn restriction", new Object[0])).primitives(l).highlight(m.getMember()).build());
        }
        if (morefrom) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1805).message(I18n.tr("More than one \"from\" way found", new Object[0])).primitives(r).build());
            return;
        }
        if (moreto) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1806).message(I18n.tr("More than one \"to\" way found", new Object[0])).primitives(r).build());
            return;
        }
        if (morevia) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1804).message(I18n.tr("More than one \"via\" node found", new Object[0])).primitives(r).build());
            return;
        }
        if (mixvia) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1813).message(I18n.tr("Cannot mix node and way for role \"via\"", new Object[0])).primitives(r).build());
            return;
        }
        if (fromWay == null) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1802).message(I18n.tr("No \"from\" way found", new Object[0])).primitives(r).build());
            return;
        }
        if (fromWay.isClosed()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1819).message(I18n.tr("\"from\" way is a closed way", new Object[0])).primitives(r).highlight(fromWay).build());
            return;
        }
        if (toWay == null) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1803).message(I18n.tr("No \"to\" way found", new Object[0])).primitives(r).build());
            return;
        }
        if (toWay.isClosed()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1818).message(I18n.tr("\"to\" way is a closed way", new Object[0])).primitives(r).highlight(toWay).build());
            return;
        }
        if (fromWay.equals(toWay)) {
            Severity severity = r.hasTag("restriction", "no_u_turn") ? Severity.OTHER : Severity.WARNING;
            this.errors.add(TestError.builder(this, severity, 1816).message(I18n.tr("\"from\" way equals \"to\" way", new Object[0])).primitives(r).build());
        }
        if (via.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1801).message(I18n.tr("No \"via\" node or way found", new Object[0])).primitives(r).build());
            return;
        }
        if (via.get(0) instanceof Node) {
            Node viaNode = (Node)via.get(0);
            if (TurnrestrictionTest.isFullOneway(toWay) && viaNode.equals(toWay.lastNode(true))) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1815).message(I18n.tr("Superfluous turn restriction as \"to\" way is oneway", new Object[0])).primitives(r).highlight(toWay).build());
                return;
            }
            if (TurnrestrictionTest.isFullOneway(fromWay) && viaNode.equals(fromWay.firstNode(true))) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1815).message(I18n.tr("Superfluous turn restriction as \"from\" way is oneway", new Object[0])).primitives(r).highlight(fromWay).build());
                return;
            }
            Way viaPseudoWay = new Way();
            viaPseudoWay.addNode(viaNode);
            this.checkIfConnected(r, fromWay, viaPseudoWay, I18n.tr("The \"from\" way does not start or end at a \"via\" node.", new Object[0]), 1809);
            this.checkIfConnected(r, viaPseudoWay, toWay, I18n.tr("The \"to\" way does not start or end at a \"via\" node.", new Object[0]), 1810);
        } else {
            if (TurnrestrictionTest.isFullOneway(toWay) && ((Way)via.get(via.size() - 1)).isFirstLastNode(toWay.lastNode(true))) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1815).message(I18n.tr("Superfluous turn restriction as \"to\" way is oneway", new Object[0])).primitives(r).highlight(toWay).build());
                return;
            }
            if (TurnrestrictionTest.isFullOneway(fromWay) && ((Way)via.get(0)).isFirstLastNode(fromWay.firstNode(true))) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1815).message(I18n.tr("Superfluous turn restriction as \"from\" way is oneway", new Object[0])).primitives(r).highlight(fromWay).build());
                return;
            }
            this.checkIfConnected(r, fromWay, (Way)via.get(0), I18n.tr("The \"from\" and the first \"via\" way are not connected.", new Object[0]), 1811);
            if (via.size() > 1) {
                for (int i = 1; i < via.size(); ++i) {
                    Way previous = (Way)via.get(i - 1);
                    Way current = (Way)via.get(i);
                    this.checkIfConnected(r, previous, current, I18n.tr("The \"via\" ways are not connected.", new Object[0]), 1814);
                }
            }
            this.checkIfConnected(r, (Way)via.get(via.size() - 1), toWay, I18n.tr("The last \"via\" and the \"to\" way are not connected.", new Object[0]), 1812);
        }
    }

    private static boolean isFullOneway(Way w) {
        return w.isOneway() != 0 && !w.hasTag("oneway:bicycle", "no");
    }

    private void checkIfConnected(Relation r, Way previous, Way current, String msg, int code) {
        boolean c;
        if (TurnrestrictionTest.isFullOneway(previous) && TurnrestrictionTest.isFullOneway(current)) {
            c = previous.lastNode(true).equals(current.firstNode(true));
        } else if (TurnrestrictionTest.isFullOneway(previous)) {
            c = current.isFirstLastNode(previous.lastNode(true));
        } else if (TurnrestrictionTest.isFullOneway(current)) {
            c = previous.isFirstLastNode(current.firstNode(true));
        } else {
            boolean bl = c = current.isFirstLastNode(previous.firstNode()) || current.isFirstLastNode(previous.lastNode());
        }
        if (!c) {
            ArrayList<OsmPrimitive> hilite = new ArrayList<OsmPrimitive>();
            if (previous.getNodesCount() == 1 && previous.isNew()) {
                hilite.add(previous.firstNode());
            } else {
                hilite.add(previous);
            }
            if (current.getNodesCount() == 1 && current.isNew()) {
                hilite.add(current.firstNode());
            } else {
                hilite.add(current);
            }
            ArrayList<OsmPrimitive> primitives = new ArrayList<OsmPrimitive>();
            primitives.add(r);
            primitives.addAll(hilite);
            this.errors.add(TestError.builder(this, Severity.ERROR, code).message(msg).primitives(primitives).highlight(hilite).build());
        }
    }
}

