/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.sources.MapPaintPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmPrimitiveImageProvider;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public final class MapPaintStyles {
    private static final Collection<String> DEPRECATED_IMAGE_NAMES = Arrays.asList("presets/misc/deprecated.svg", "misc/deprecated.png");
    private static final ListenerList<MapPaintStylesUpdateListener> listeners = ListenerList.createUnchecked();
    private static final ElemStyles styles;

    public static ElemStyles getStyles() {
        return styles;
    }

    private MapPaintStyles() {
    }

    public static ImageProvider getIconProvider(IconReference ref, boolean test) {
        String namespace = ref.source.getPrefName();
        ImageProvider i = new ImageProvider(ref.iconName).setDirs(MapPaintStyles.getIconSourceDirs(ref.source)).setId("mappaint." + namespace).setArchive(ref.source.zipIcons).setInArchiveDir(ref.source.getZipEntryDirName()).setOptional(true);
        if (test && i.get() == null) {
            String msg = "Mappaint style \"" + namespace + "\" (" + ref.source.getDisplayString() + ") icon \"" + ref.iconName + "\" not found.";
            ref.source.logWarning(msg);
            Logging.warn(msg);
            return null;
        }
        return i;
    }

    public static ImageIcon getIcon(IconReference ref, int width, int height) {
        String namespace = ref.source.getPrefName();
        ImageIcon i = MapPaintStyles.getIconProvider(ref, false).setSize(width, height).get();
        if (i == null) {
            Logging.warn("Mappaint style \"" + namespace + "\" (" + ref.source.getDisplayString() + ") icon \"" + ref.iconName + "\" not found.");
            return null;
        }
        return i;
    }

    public static ImageIcon getNoIconIcon(StyleSource source) {
        return new ImageProvider("presets/misc/no_icon").setDirs(MapPaintStyles.getIconSourceDirs(source)).setId("mappaint." + source.getPrefName()).setArchive(source.zipIcons).setInArchiveDir(source.getZipEntryDirName()).setOptional(true).get();
    }

    @Deprecated
    public static ImageIcon getNodeIcon(Tag tag) {
        if (tag != null) {
            return OsmPrimitiveImageProvider.getResource(tag.getKey(), tag.getValue(), OsmPrimitiveType.NODE).map(resource -> resource.getPaddedIcon(ImageProvider.ImageSizes.SMALLICON.getImageDimension())).orElse(null);
        }
        return null;
    }

    public static List<String> getIconSourceDirs(StyleSource source) {
        LinkedList<String> dirs = new LinkedList<String>();
        File sourceDir = source.getLocalSourceDir();
        if (sourceDir != null) {
            dirs.add(sourceDir.getPath());
        }
        List<String> prefIconDirs = Config.getPref().getList("mappaint.icon.sources");
        for (String fileset : prefIconDirs) {
            String[] a = fileset.indexOf(61) >= 0 ? fileset.split("=", 2) : new String[]{"", fileset};
            if (!a[0].isEmpty() && !source.getPrefName().equals(a[0])) continue;
            dirs.add(a[1]);
        }
        if (Config.getPref().getBoolean("mappaint.icon.enable-defaults", true)) {
            dirs.add("resource://images/");
        }
        return dirs;
    }

    public static void readFromPreferences() {
        styles.clear();
        List<SourceEntry> sourceEntries = MapPaintPrefHelper.INSTANCE.get();
        for (SourceEntry entry : sourceEntries) {
            try {
                styles.add(MapPaintStyles.fromSourceEntry(entry));
            }
            catch (IllegalArgumentException e) {
                Logging.error("Failed to load map paint style {0}", entry);
                Logging.error(e);
            }
        }
        for (StyleSource source : styles.getStyleSources()) {
            if (source.active) {
                MapPaintStyles.loadStyleForFirstTime(source);
                continue;
            }
            source.loadStyleSource(true);
        }
        MapPaintStyles.fireMapPaintStylesUpdated();
    }

    private static void loadStyleForFirstTime(StyleSource source) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        source.loadStyleSource();
        if (Config.getPref().getBoolean("mappaint.auto_reload_local_styles", true) && source.isLocal()) {
            try {
                FileWatcher.getDefaultInstance().registerSource(source);
            }
            catch (IOException | IllegalArgumentException | IllegalStateException e) {
                Logging.error(e);
            }
        }
        if (Logging.isDebugEnabled() || !source.isValid()) {
            String message = stopwatch.toString("Initializing map style " + source.url);
            if (!source.isValid()) {
                Logging.warn(message + " (" + source.getErrors().size() + " errors, " + source.getWarnings().size() + " warnings)");
            } else {
                Logging.debug(message);
            }
        }
    }

    private static StyleSource fromSourceEntry(SourceEntry entry) {
        if (entry.url == null && entry instanceof MapCSSStyleSource) {
            return (MapCSSStyleSource)entry;
        }
        try (CachedFile cf = new CachedFile(entry.url).setHttpAccept("text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5");){
            String zipEntryPath = cf.findZipEntryPath("mapcss", "style");
            if (zipEntryPath != null) {
                entry.isZip = true;
                entry.zipEntryPath = zipEntryPath;
            }
            MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource(entry);
            return mapCSSStyleSource;
        }
    }

    public static void moveStyles(int[] sel, int delta) {
        if (!MapPaintStyles.canMoveStyles(sel, delta)) {
            return;
        }
        int[] selSorted = Utils.copyArray(sel);
        Arrays.sort(selSorted);
        ArrayList<StyleSource> data = new ArrayList<StyleSource>(styles.getStyleSources());
        for (int row : selSorted) {
            StyleSource t1 = (StyleSource)data.get(row);
            StyleSource t2 = (StyleSource)data.get(row + delta);
            data.set(row, t2);
            data.set(row + delta, t1);
        }
        styles.setStyleSources(data);
        MapPaintPrefHelper.INSTANCE.put(data);
        MapPaintStyles.fireMapPaintStylesUpdated();
    }

    public static boolean canMoveStyles(int[] sel, int i) {
        if (sel.length == 0) {
            return false;
        }
        int[] selSorted = Utils.copyArray(sel);
        Arrays.sort(selSorted);
        if (i < 0) {
            return selSorted[0] >= -i;
        }
        if (i > 0) {
            return selSorted[selSorted.length - 1] <= styles.getStyleSources().size() - 1 - i;
        }
        return true;
    }

    public static void toggleStyleActive(int ... sel) {
        List<StyleSource> data = styles.getStyleSources();
        for (int p : sel) {
            StyleSource s = data.get(p);
            boolean bl = s.active = !s.active;
            if (!s.active || s.isLoaded()) continue;
            MapPaintStyles.loadStyleForFirstTime(s);
        }
        MapPaintPrefHelper.INSTANCE.put(data);
        if (sel.length == 1) {
            MapPaintStyles.fireMapPaintStyleEntryUpdated(sel[0]);
        } else {
            MapPaintStyles.fireMapPaintStylesUpdated();
        }
    }

    public static StyleSource addStyle(SourceEntry entry) {
        StyleSource source = MapPaintStyles.fromSourceEntry(entry);
        styles.add(source);
        MapPaintStyles.loadStyleForFirstTime(source);
        MapPaintStyles.refreshStyles();
        return source;
    }

    public static void removeStyle(SourceEntry entry) {
        StyleSource source = MapPaintStyles.fromSourceEntry(entry);
        if (styles.remove(source)) {
            MapPaintStyles.refreshStyles();
        }
    }

    private static void refreshStyles() {
        MapPaintPrefHelper.INSTANCE.put(styles.getStyleSources());
        MapPaintStyles.fireMapPaintStylesUpdated();
    }

    public static void addMapPaintStylesUpdateListener(MapPaintStylesUpdateListener listener) {
        listeners.addListener(listener);
    }

    public static void removeMapPaintStylesUpdateListener(MapPaintStylesUpdateListener listener) {
        listeners.removeListener(listener);
    }

    public static void fireMapPaintStylesUpdated() {
        listeners.fireEvent(MapPaintStylesUpdateListener::mapPaintStylesUpdated);
    }

    public static void fireMapPaintStyleEntryUpdated(int index) {
        listeners.fireEvent(l -> l.mapPaintStyleEntryUpdated(index));
    }

    static {
        listeners.addListener(new MapPaintStylesUpdateListener(){

            @Override
            public void mapPaintStylesUpdated() {
                SwingUtilities.invokeLater(styles::clearCached);
            }

            @Override
            public void mapPaintStyleEntryUpdated(int index) {
                this.mapPaintStylesUpdated();
            }
        });
        Config.getPref().addPreferenceChangeListener(new MapPaintStylesPreferenceListener(Config.getPref()));
        styles = new ElemStyles();
    }

    public static interface MapPaintStylesUpdateListener {
        public void mapPaintStylesUpdated();

        public void mapPaintStyleEntryUpdated(int var1);
    }

    public static class IconReference {
        public final String iconName;
        public final StyleSource source;

        public IconReference(String iconName, StyleSource source) {
            this.iconName = iconName;
            this.source = source;
        }

        public String toString() {
            return "IconReference{iconName='" + this.iconName + "' source='" + this.source.getDisplayString() + "'}";
        }

        public boolean isDeprecatedIcon() {
            return DEPRECATED_IMAGE_NAMES.contains(this.iconName);
        }
    }

    public static class TagKeyReference {
        public final String key;

        public TagKeyReference(String key) {
            this.key = key.intern();
        }

        public String toString() {
            return "TagKeyReference{key='" + this.key + "'}";
        }
    }

    private static final class MapPaintStylesPreferenceListener
    implements PreferenceChangedListener {
        private final IPreferences pref;
        private final List<String> preferenceIgnoreList;

        MapPaintStylesPreferenceListener(IPreferences pref) {
            this.pref = pref;
            this.preferenceIgnoreList = Arrays.asList("mappaint.style.entries", "mappaint.style.known-defaults");
        }

        @Override
        public void preferenceChanged(PreferenceChangeEvent e) {
            if (e.getKey().contains("mappaint") && !this.preferenceIgnoreList.contains(e.getKey())) {
                this.pref.removePreferenceChangeListener(this);
                MapPaintStyles.readFromPreferences();
                this.pref.addPreferenceChangeListener(this);
            }
        }
    }
}

