/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Mediawiki {
    private final String baseUrl;

    public Mediawiki(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Optional<String> findExistingPage(List<String> pages) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        Document document;
        List distinctPages = pages.stream().distinct().collect(Collectors.toList());
        URL url = new URL(this.baseUrl + "/w/api.php?action=query&format=xml&titles=" + distinctPages.stream().map(Utils::encodeUrl).collect(Collectors.joining(Utils.encodeUrl("|"))));
        HttpClient.Response conn = HttpClient.create(url).connect();
        InputStream content = conn.getContent();
        Object object = null;
        try {
            document = XmlUtils.parseSafeDOM(content);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (content != null) {
                if (object != null) {
                    try {
                        content.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    content.close();
                }
            }
        }
        conn.disconnect();
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (String page : distinctPages) {
            Node node;
            String normalized = xPath.evaluate("/api/query/normalized/n[@from='" + page + "']/@to", document);
            if (normalized == null || normalized.isEmpty()) {
                normalized = page;
            }
            if ((node = (Node)xPath.evaluate("/api/query/pages/page[@title='" + normalized + "']", document, XPathConstants.NODE)) == null || node.getAttributes().getNamedItem("missing") != null || node.getAttributes().getNamedItem("invalid") != null) continue;
            return Optional.of(page);
        }
        return Optional.empty();
    }

    public static String getImageUrl(String fileBaseUrl, String filename) {
        String md5 = Utils.md5Hex(filename);
        return String.join((CharSequence)"/", Utils.strip(fileBaseUrl, "/"), md5.substring(0, 1), md5.substring(0, 2), filename);
    }
}

