/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class ContextSwitchTemplate
implements TemplateEntry {
    private static final TemplateEngineDataProvider EMPTY_PROVIDER = new TemplateEngineDataProvider(){

        @Override
        public Object getTemplateValue(String name, boolean special) {
            return null;
        }

        @Override
        public Collection<String> getTemplateKeys() {
            return Collections.emptyList();
        }

        @Override
        public boolean evaluateCondition(SearchCompiler.Match condition) {
            return false;
        }
    };
    private final ContextProvider context;
    private final TemplateEntry template;

    private static SearchCompiler.Match transform(SearchCompiler.Match m, int searchExpressionPosition) throws ParseError {
        if (m instanceof SearchCompiler.Parent) {
            SearchCompiler.Match child = ContextSwitchTemplate.transform(((SearchCompiler.Parent)m).getOperand(), searchExpressionPosition);
            return new ParentSet(child);
        }
        if (m instanceof SearchCompiler.Child) {
            SearchCompiler.Match parent = ContextSwitchTemplate.transform(((SearchCompiler.Child)m).getOperand(), searchExpressionPosition);
            return new ChildSet(parent);
        }
        if (m instanceof SearchCompiler.And) {
            SearchCompiler.Match lhs = ContextSwitchTemplate.transform(((SearchCompiler.And)m).getLhs(), searchExpressionPosition);
            SearchCompiler.Match rhs = ContextSwitchTemplate.transform(((SearchCompiler.And)m).getRhs(), searchExpressionPosition);
            if (lhs instanceof ContextProvider && rhs instanceof ContextProvider) {
                return new AndSet((ContextProvider)lhs, (ContextProvider)rhs);
            }
            if (lhs instanceof ContextProvider) {
                ContextProvider cp = (ContextProvider)lhs;
                cp.condition = cp.condition == null ? rhs : new SearchCompiler.And(cp.condition, rhs);
                return cp;
            }
            if (rhs instanceof ContextProvider) {
                ContextProvider cp = (ContextProvider)rhs;
                cp.condition = cp.condition == null ? lhs : new SearchCompiler.And(lhs, cp.condition);
                return cp;
            }
            return m;
        }
        if (m instanceof SearchCompiler.Or) {
            SearchCompiler.Match lhs = ContextSwitchTemplate.transform(((SearchCompiler.Or)m).getLhs(), searchExpressionPosition);
            SearchCompiler.Match rhs = ContextSwitchTemplate.transform(((SearchCompiler.Or)m).getRhs(), searchExpressionPosition);
            if (lhs instanceof ContextProvider && rhs instanceof ContextProvider) {
                return new OrSet((ContextProvider)lhs, (ContextProvider)rhs);
            }
            if (lhs instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - right side of or(|) expression must return set of primitives", searchExpressionPosition));
            }
            if (rhs instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - left side of or(|) expression must return set of primitives", searchExpressionPosition));
            }
            return m;
        }
        if (m instanceof SearchCompiler.Not) {
            SearchCompiler.Match match = ContextSwitchTemplate.transform(((SearchCompiler.Not)m).getMatch(), searchExpressionPosition);
            if (match instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - not(-) cannot be used in this context", searchExpressionPosition));
            }
            return m;
        }
        return m;
    }

    public ContextSwitchTemplate(SearchCompiler.Match match, TemplateEntry template, int searchExpressionPosition) throws ParseError {
        SearchCompiler.Match m = ContextSwitchTemplate.transform(match, searchExpressionPosition);
        if (!(m instanceof ContextProvider)) {
            throw new ParseError(I18n.tr("Error in search expression on position {0} - expression must return different then current primitive", searchExpressionPosition));
        }
        this.context = (ContextProvider)m;
        this.template = template;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        List<OsmPrimitive> primitives;
        if (dataProvider instanceof OsmPrimitive && (primitives = this.context.getPrimitives((OsmPrimitive)dataProvider)) != null && !primitives.isEmpty()) {
            this.template.appendText(result, primitives.get(0));
        }
        this.template.appendText(result, EMPTY_PROVIDER);
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        List<OsmPrimitive> primitives;
        if (dataProvider instanceof OsmPrimitive && (primitives = this.context.getPrimitives((OsmPrimitive)dataProvider)) != null && !primitives.isEmpty()) {
            return this.template.isValid(primitives.get(0));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.context, this.template);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContextSwitchTemplate other = (ContextSwitchTemplate)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }

    private static class AndSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        AndSet(ContextProvider lhs, ContextProvider rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            List<OsmPrimitive> lhsList = this.lhs.getPrimitives(root);
            return this.rhs.getPrimitives(root).stream().filter(lhsList::contains).filter(o -> this.condition == null || this.condition.match((OsmPrimitive)o)).collect(Collectors.toList());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lhs, this.rhs);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            AndSet other = (AndSet)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }
    }

    private static class OrSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        OrSet(ContextProvider lhs, ContextProvider rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            return Stream.concat(this.lhs.getPrimitives(root).stream(), this.rhs.getPrimitives(root).stream()).filter(o -> this.condition == null || this.condition.match((OsmPrimitive)o)).distinct().collect(Collectors.toList());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.lhs, this.rhs);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            OrSet other = (OrSet)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }
    }

    private static class ChildSet
    extends ContextProvider {
        private final SearchCompiler.Match parentCondition;

        ChildSet(SearchCompiler.Match parentCondition) {
            this.parentCondition = parentCondition;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            List<OsmPrimitive> parents = this.parentCondition instanceof ContextProvider ? ((ContextProvider)this.parentCondition).getPrimitives(root) : (this.parentCondition.match(root) ? Collections.singletonList(root) : Collections.emptyList());
            ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive p : parents) {
                if (p instanceof Way) {
                    for (Node n : ((Way)p).getNodes()) {
                        if (this.condition != null && this.condition.match(n)) {
                            result.add(n);
                        }
                        result.add(n);
                    }
                    continue;
                }
                if (!(p instanceof Relation)) continue;
                for (RelationMember rm : ((Relation)p).getMembers()) {
                    if (this.condition == null || !this.condition.match(rm.getMember())) continue;
                    result.add(rm.getMember());
                }
            }
            return result;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.parentCondition);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            ChildSet other = (ChildSet)obj;
            return !(this.parentCondition == null ? other.parentCondition != null : !this.parentCondition.equals(other.parentCondition));
        }
    }

    private static class ParentSet
    extends ContextProvider {
        private final SearchCompiler.Match childCondition;

        ParentSet(SearchCompiler.Match child) {
            this.childCondition = child;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive root) {
            List<OsmPrimitive> children = this.childCondition instanceof ContextProvider ? ((ContextProvider)this.childCondition).getPrimitives(root) : (this.childCondition.match(root) ? Collections.singletonList(root) : Collections.emptyList());
            return children.stream().flatMap(child -> child.getReferrers(true).stream()).filter(parent -> this.condition == null || this.condition.match((OsmPrimitive)parent)).collect(Collectors.toList());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.childCondition);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            ParentSet other = (ParentSet)obj;
            return !(this.childCondition == null ? other.childCondition != null : !this.childCondition.equals(other.childCondition));
        }
    }

    private static abstract class ContextProvider
    extends SearchCompiler.Match {
        protected SearchCompiler.Match condition;

        private ContextProvider() {
        }

        abstract List<OsmPrimitive> getPrimitives(OsmPrimitive var1);

        public int hashCode() {
            return Objects.hash(this.condition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ContextProvider other = (ContextProvider)obj;
            return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
        }
    }
}

