/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UploadStrategy;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class UploadStrategySelectionPanel
extends JPanel
implements PropertyChangeListener {
    public static final String UPLOAD_STRATEGY_SPECIFICATION_PROP = UploadStrategySelectionPanel.class.getName() + ".uploadStrategySpecification";
    private transient Map<UploadStrategy, JRadioButton> rbStrategy;
    private transient Map<UploadStrategy, JLabel> lblNumRequests;
    private transient Map<UploadStrategy, JMultilineLabel> lblStrategies;
    private final JosmTextField tfChunkSize = new JosmTextField(4);
    private final JPanel pnlMultiChangesetPolicyPanel = new JPanel(new GridBagLayout());
    private final JRadioButton rbFillOneChangeset = new JRadioButton(I18n.tr("Fill up one changeset and return to the Upload Dialog", new Object[0]));
    private final JRadioButton rbUseMultipleChangesets = new JRadioButton(I18n.tr("Open and use as many new changesets as necessary", new Object[0]));
    private JMultilineLabel lblMultiChangesetPoliciesHeader;
    private long numUploadedObjects;

    public UploadStrategySelectionPanel() {
        this.build();
    }

    protected JPanel buildUploadStrategyPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        ButtonGroup bgStrategies = new ButtonGroup();
        this.rbStrategy = new EnumMap<UploadStrategy, JRadioButton>(UploadStrategy.class);
        this.lblStrategies = new EnumMap<UploadStrategy, JMultilineLabel>(UploadStrategy.class);
        this.lblNumRequests = new EnumMap<UploadStrategy, JLabel>(UploadStrategy.class);
        for (UploadStrategy strategy : UploadStrategy.values()) {
            this.rbStrategy.put(strategy, new JRadioButton());
            this.lblNumRequests.put(strategy, new JLabel());
            this.lblStrategies.put(strategy, new JMultilineLabel(""));
            bgStrategies.add(this.rbStrategy.get((Object)strategy));
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 4;
        gc.fill = 2;
        gc.insets = new Insets(0, 0, 3, 0);
        gc.anchor = 23;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Please select the upload strategy:", new Object[0])), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        gc.anchor = 23;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        JMultilineLabel lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
        lbl.setText(I18n.tr("Upload data in one request", new Object[0]));
        pnl.add((Component)lbl, gc);
        gc.gridx = 3;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        lbl = this.lblStrategies.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY);
        lbl.setText(I18n.tr("Upload data in chunks of objects. Chunk size: ", new Object[0]));
        pnl.add((Component)lbl, gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.tfChunkSize, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)this.rbStrategy.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gc);
        gc.gridx = 1;
        gc.gridy = 3;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.gridwidth = 2;
        lbl = this.lblStrategies.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY);
        lbl.setText(I18n.tr("Upload each object individually", new Object[0]));
        pnl.add((Component)lbl, gc);
        gc.gridx = 3;
        gc.gridy = 3;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridwidth = 1;
        pnl.add((Component)this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gc);
        this.tfChunkSize.addFocusListener(new TextFieldFocusHandler());
        new ChunkSizeValidator(this.tfChunkSize);
        StrategyChangeListener strategyChangeListener = new StrategyChangeListener();
        this.tfChunkSize.addFocusListener(strategyChangeListener);
        this.tfChunkSize.addActionListener(strategyChangeListener);
        for (UploadStrategy strategy : UploadStrategy.values()) {
            this.rbStrategy.get((Object)strategy).addItemListener(strategyChangeListener);
        }
        return pnl;
    }

    protected JPanel buildMultiChangesetPolicyPanel() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        this.lblMultiChangesetPoliciesHeader = new JMultilineLabel(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. Which strategy do you want to use?</html>", this.numUploadedObjects));
        this.pnlMultiChangesetPolicyPanel.add((Component)this.lblMultiChangesetPoliciesHeader, gc);
        gc.gridy = 1;
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbFillOneChangeset, gc);
        gc.gridy = 2;
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbUseMultipleChangesets, gc);
        ButtonGroup bgMultiChangesetPolicies = new ButtonGroup();
        bgMultiChangesetPolicies.add(this.rbFillOneChangeset);
        bgMultiChangesetPolicies.add(this.rbUseMultipleChangesets);
        return this.pnlMultiChangesetPolicyPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.anchor = 18;
        gc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.buildUploadStrategyPanel(), gc);
        gc.gridy = 1;
        this.add((Component)this.buildMultiChangesetPolicyPanel(), gc);
        gc.gridy = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)new JPanel(), gc);
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        int maxChunkSize = capabilities != null ? capabilities.getMaxChangesetSize() : -1;
        this.pnlMultiChangesetPolicyPanel.setVisible(maxChunkSize > 0 && this.numUploadedObjects > (long)maxChunkSize);
    }

    public void setNumUploadedObjects(int numUploadedObjects) {
        this.numUploadedObjects = Math.max(numUploadedObjects, 0);
        this.updateNumRequestsLabels();
    }

    public void setUploadStrategySpecification(UploadStrategySpecification strategy) {
        if (strategy == null) {
            return;
        }
        this.rbStrategy.get((Object)strategy.getStrategy()).setSelected(true);
        this.tfChunkSize.setEnabled(strategy.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY);
        if (strategy.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY) {
            if (strategy.getChunkSize() != -1) {
                this.tfChunkSize.setText(Integer.toString(strategy.getChunkSize()));
            } else {
                this.tfChunkSize.setText("1");
            }
        }
    }

    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategy strategy = this.getUploadStrategy();
        UploadStrategySpecification spec = new UploadStrategySpecification();
        if (strategy != null) {
            switch (strategy) {
                case CHUNKED_DATASET_STRATEGY: {
                    spec.setStrategy(strategy).setChunkSize(this.getChunkSize());
                    break;
                }
                default: {
                    spec.setStrategy(strategy);
                }
            }
        }
        if (this.pnlMultiChangesetPolicyPanel.isVisible()) {
            if (this.rbFillOneChangeset.isSelected()) {
                spec.setPolicy(MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG);
            } else if (this.rbUseMultipleChangesets.isSelected()) {
                spec.setPolicy(MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS);
            } else {
                spec.setPolicy(null);
            }
        } else {
            spec.setPolicy(null);
        }
        return spec;
    }

    protected UploadStrategy getUploadStrategy() {
        return this.rbStrategy.entrySet().stream().filter(e -> ((JRadioButton)e.getValue()).isSelected()).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    protected int getChunkSize() {
        try {
            return Integer.parseInt(this.tfChunkSize.getText().trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void initFromPreferences() {
        UploadStrategy strategy = UploadStrategy.getFromPreferences();
        this.rbStrategy.get((Object)strategy).setSelected(true);
        int chunkSize = Config.getPref().getInt("osm-server.upload-strategy.chunk-size", 1000);
        this.tfChunkSize.setText(Integer.toString(chunkSize));
        this.updateNumRequestsLabels();
    }

    public void rememberUserInput() {
        UploadStrategy strategy = this.getUploadStrategy();
        UploadStrategy.saveToPreferences(strategy);
        try {
            int chunkSize = Integer.parseInt(this.tfChunkSize.getText().trim());
            Config.getPref().putInt("osm-server.upload-strategy.chunk-size", chunkSize);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
        }
    }

    protected void updateNumRequestsLabels() {
        JMultilineLabel lbl;
        int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (maxChunkSize > 0 && this.numUploadedObjects > (long)maxChunkSize) {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(false);
            lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            lbl.setText(I18n.tr("Upload in one request not possible (too many objects to upload)", new Object[0]));
            lbl.setToolTipText(I18n.tr("<html>Cannot upload {0} objects in one request because the<br>max. changeset size {1} on server ''{2}'' is exceeded.</html>", this.numUploadedObjects, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
            this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setSelected(true);
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(false);
            this.lblMultiChangesetPoliciesHeader.setText(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. Which strategy do you want to use?</html>", this.numUploadedObjects));
            if (!this.rbFillOneChangeset.isSelected() && !this.rbUseMultipleChangesets.isSelected()) {
                this.rbUseMultipleChangesets.setSelected(true);
            }
            this.pnlMultiChangesetPolicyPanel.setVisible(true);
        } else {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(true);
            lbl = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            lbl.setText(I18n.tr("Upload data in one request", new Object[0]));
            lbl.setToolTipText(null);
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(true);
            this.pnlMultiChangesetPolicyPanel.setVisible(false);
        }
        this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setText(I18n.tr("(1 request)", new Object[0]));
        if (this.numUploadedObjects == 0L) {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
        } else {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", this.numUploadedObjects, this.numUploadedObjects));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            int chunkSize = this.getChunkSize();
            if (chunkSize == -1) {
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            } else {
                int chunks = (int)Math.ceil((double)this.numUploadedObjects / (double)chunkSize);
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", chunks, chunks));
            }
        }
    }

    public void initEditingOfChunkSize() {
        this.tfChunkSize.requestFocusInWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.setNumUploadedObjects((Integer)evt.getNewValue());
        }
    }

    class StrategyChangeListener
    extends FocusAdapter
    implements ItemListener,
    ActionListener {
        StrategyChangeListener() {
        }

        protected void notifyStrategy() {
            UploadStrategySelectionPanel.this.firePropertyChange(UPLOAD_STRATEGY_SPECIFICATION_PROP, null, UploadStrategySelectionPanel.this.getUploadStrategySpecification());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            UploadStrategy strategy = UploadStrategySelectionPanel.this.getUploadStrategy();
            if (strategy == null) {
                return;
            }
            switch (strategy) {
                case CHUNKED_DATASET_STRATEGY: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(true);
                    UploadStrategySelectionPanel.this.tfChunkSize.requestFocusInWindow();
                    break;
                }
                default: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(false);
                }
            }
            this.notifyStrategy();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.notifyStrategy();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyStrategy();
        }
    }

    class ChunkSizeValidator
    extends AbstractTextComponentValidator {
        ChunkSizeValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public void validate() {
            try {
                int chunkSize = Integer.parseInt(UploadStrategySelectionPanel.this.tfChunkSize.getText().trim());
                int maxChunkSize = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
                if (chunkSize <= 0) {
                    this.feedbackInvalid(I18n.tr("Illegal chunk size <= 0. Please enter an integer > 1", new Object[0]));
                } else if (maxChunkSize > 0 && chunkSize > maxChunkSize) {
                    this.feedbackInvalid(I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", chunkSize, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
                } else {
                    this.feedbackValid(null);
                }
                if (maxChunkSize > 0 && chunkSize > maxChunkSize) {
                    this.feedbackInvalid(I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", chunkSize, maxChunkSize, OsmApi.getOsmApi().getBaseUrl()));
                }
            }
            catch (NumberFormatException e) {
                this.feedbackInvalid(I18n.tr("Value ''{0}'' is not a number. Please enter an integer > 1", UploadStrategySelectionPanel.this.tfChunkSize.getText().trim()));
            }
            finally {
                UploadStrategySelectionPanel.this.updateNumRequestsLabels();
            }
        }

        @Override
        public boolean isValid() {
            throw new UnsupportedOperationException();
        }
    }

    static class TextFieldFocusHandler
    extends FocusAdapter {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JosmTextField) {
                JosmTextField tf = (JosmTextField)c;
                tf.selectAll();
            }
        }
    }
}

