/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    private final PrimitiveId id;
    private final boolean full;
    private final int version;

    public OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full) {
        this(id, type, full, -1);
    }

    public OsmServerObjectReader(long id, OsmPrimitiveType type, int version) {
        this(id, type, false, version);
    }

    protected OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full, int version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value > 0 for parameter ''{0}'', got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = new SimplePrimitiveId(id, type);
        this.full = full;
        this.version = version;
    }

    public OsmServerObjectReader(PrimitiveId id, boolean full) {
        this(id, full, -1);
    }

    public OsmServerObjectReader(PrimitiveId id, int version) {
        this(id, false, version);
    }

    protected OsmServerObjectReader(PrimitiveId id, boolean full, int version) {
        CheckParameterUtil.ensureThat(id.getUniqueId() > 0L, "id > 0");
        this.id = id;
        this.full = full;
        this.version = version;
    }

    /*
     * Loose catch block
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask("", 1);
        try {
            DataSet dataSet;
            Throwable throwable;
            InputStream in;
            block33: {
                block34: {
                    block30: {
                        DataSet dataSet2;
                        block31: {
                            block32: {
                                progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data...", new Object[0]));
                                StringBuilder sb = new StringBuilder();
                                sb.append(this.id.getType().getAPIName()).append('/').append(this.id.getUniqueId());
                                if (this.full && this.id.getType() != OsmPrimitiveType.NODE) {
                                    sb.append("/full");
                                } else if (this.version > 0) {
                                    sb.append('/').append(this.version);
                                }
                                in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
                                throwable = null;
                                if (in != null) break block30;
                                dataSet2 = null;
                                if (in == null) break block31;
                                if (throwable == null) break block32;
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block31;
                            }
                            in.close();
                        }
                        return dataSet2;
                    }
                    dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
                    if (in == null) break block33;
                    if (throwable == null) break block34;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block33;
                }
                in.close();
            }
            return dataSet;
            catch (Throwable throwable4) {
                DataSet dataSet3;
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (OsmTransferException e) {
                    if (this.cancel) {
                        dataSet3 = null;
                        return dataSet3;
                    }
                    throw e;
                }
                catch (IOException | IllegalDataException e) {
                    if (this.cancel) {
                        dataSet3 = null;
                        return dataSet3;
                    }
                    throw new OsmTransferException(e);
                }
            }
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

