/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class MapViewState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OUTSIDE_TOP = 1;
    public static final int OUTSIDE_BOTTOM = 2;
    public static final int OUTSIDE_LEFT = 4;
    public static final int OUTSIDE_RIGHT = 8;
    private static final int CLIP_BOUNDS = 50;
    private final transient Projecting projecting;
    private final int viewWidth;
    private final int viewHeight;
    private final double scale;
    private final EastNorth topLeft;
    private final Point topLeftOnScreen;
    private final Point topLeftInWindow;

    private MapViewState(Projecting projection, int viewWidth, int viewHeight, double scale, EastNorth topLeft, Point topLeftInWindow, Point topLeftOnScreen) {
        CheckParameterUtil.ensureParameterNotNull(projection, "projection");
        CheckParameterUtil.ensureParameterNotNull(topLeft, "topLeft");
        CheckParameterUtil.ensureParameterNotNull(topLeftInWindow, "topLeftInWindow");
        CheckParameterUtil.ensureParameterNotNull(topLeftOnScreen, "topLeftOnScreen");
        this.projecting = projection;
        this.scale = scale;
        this.topLeft = topLeft;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.topLeftInWindow = topLeftInWindow;
        this.topLeftOnScreen = topLeftOnScreen;
    }

    private MapViewState(Projecting projection, int viewWidth, int viewHeight, double scale, EastNorth topLeft) {
        this(projection, viewWidth, viewHeight, scale, topLeft, new Point(0, 0), new Point(0, 0));
    }

    private MapViewState(EastNorth topLeft, MapViewState mvs) {
        this(mvs.projecting, mvs.viewWidth, mvs.viewHeight, mvs.scale, topLeft, mvs.topLeftInWindow, mvs.topLeftOnScreen);
    }

    private MapViewState(double scale, MapViewState mvs) {
        this(mvs.projecting, mvs.viewWidth, mvs.viewHeight, scale, mvs.topLeft, mvs.topLeftInWindow, mvs.topLeftOnScreen);
    }

    private MapViewState(JComponent position, MapViewState mvs) {
        this(mvs.projecting, position.getWidth(), position.getHeight(), mvs.scale, mvs.topLeft, MapViewState.findTopLeftInWindow(position), MapViewState.findTopLeftOnScreen(position));
    }

    private MapViewState(Projecting projecting, MapViewState mvs) {
        this(projecting, mvs.viewWidth, mvs.viewHeight, mvs.scale, mvs.topLeft, mvs.topLeftInWindow, mvs.topLeftOnScreen);
    }

    static Point findTopLeftInWindow(JComponent position) {
        Point result = new Point();
        for (Container component = position; component != null; component = component.getParent()) {
            result.x += ((Component)component).getX();
            result.y += ((Component)component).getY();
        }
        return result;
    }

    static Point findTopLeftOnScreen(JComponent position) {
        try {
            return position.getLocationOnScreen();
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("position", position).put("parent", position::getParent);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [projecting=" + this.projecting + " viewWidth=" + this.viewWidth + " viewHeight=" + this.viewHeight + " scale=" + this.scale + " topLeft=" + this.topLeft + ']';
    }

    public double getScale() {
        return this.scale;
    }

    public MapViewPoint getForView(double x, double y) {
        return new MapViewViewPoint(x, y);
    }

    public MapViewPoint getPointFor(EastNorth eastNorth) {
        return new MapViewEastNorthPoint(eastNorth);
    }

    public MapViewPoint getPointFor(LatLon latlon) {
        return this.getPointFor((ILatLon)latlon);
    }

    public MapViewPoint getPointFor(ILatLon latlon) {
        try {
            return this.getPointFor(Optional.ofNullable(latlon.getEastNorth(this.getProjection())).orElseThrow(IllegalArgumentException::new));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("latlon", latlon);
        }
    }

    public MapViewPoint getPointFor(Node node) {
        return this.getPointFor((ILatLon)node);
    }

    public MapViewRectangle getViewArea() {
        return this.getForView(0.0, 0.0).rectTo(this.getForView(this.viewWidth, this.viewHeight));
    }

    public MapViewRectangle getViewArea(Rectangle2D rectangle) {
        return this.getForView(rectangle.getMinX(), rectangle.getMinY()).rectTo(this.getForView(rectangle.getMaxX(), rectangle.getMaxY()));
    }

    public MapViewPoint getCenter() {
        return this.getForView((double)this.viewWidth / 2.0, (double)this.viewHeight / 2.0);
    }

    public double getViewWidth() {
        return this.viewWidth;
    }

    public double getViewHeight() {
        return this.viewHeight;
    }

    public Projection getProjection() {
        return this.projecting.getBaseProjection();
    }

    public Projecting getProjecting() {
        return this.projecting;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(1.0 / this.scale, 0.0, 0.0, -1.0 / this.scale, -this.topLeft.east() / this.scale, this.topLeft.north() / this.scale);
    }

    public MapViewRectangle getViewClipRectangle() {
        return this.getForView(-50.0, -50.0).rectTo(this.getForView(this.getViewWidth() + 50.0, this.getViewHeight() + 50.0));
    }

    public Area getArea(Bounds bounds) {
        Path2D.Double area = new Path2D.Double();
        this.getProjection().visitOutline(bounds, en -> {
            MapViewPoint point = this.getPointFor((EastNorth)en);
            if (area.getCurrentPoint() == null) {
                area.moveTo(point.getInViewX(), point.getInViewY());
            } else {
                area.lineTo(point.getInViewX(), point.getInViewY());
            }
        });
        area.closePath();
        return new Area(area);
    }

    public MapViewState usingCenter(EastNorth newCenter) {
        return this.movedTo(this.getCenter(), newCenter);
    }

    public MapViewState movedTo(MapViewPoint mapViewPoint, EastNorth newEastNorthThere) {
        EastNorth delta = newEastNorthThere.subtract(mapViewPoint.getEastNorth());
        if (delta.distanceSq(0.0, 0.0) < 1.0E-21) {
            return this;
        }
        return new MapViewState(this.topLeft.add(delta), this);
    }

    public MapViewState usingScale(double newScale) {
        return new MapViewState(newScale, this);
    }

    public MapViewState usingLocation(JComponent position) {
        EastNorth center = this.getCenter().getEastNorth();
        return new MapViewState(position, this).usingCenter(center);
    }

    public MapViewState usingProjection(Projection projection) {
        if (projection.equals(this.projecting)) {
            return this;
        }
        return new MapViewState(projection, this);
    }

    public static MapViewState createDefaultState(int width, int height) {
        Projection projection = ProjectionRegistry.getProjection();
        double scale = projection.getDefaultZoomInPPD();
        MapViewState state = new MapViewState(projection, width, height, scale, new EastNorth(0.0, 0.0));
        EastNorth center = MapViewState.calculateDefaultCenter();
        return state.movedTo(state.getCenter(), center);
    }

    private static EastNorth calculateDefaultCenter() {
        Bounds b = Optional.ofNullable(DownloadDialog.getSavedDownloadBounds()).orElseGet(() -> ProjectionRegistry.getProjection().getWorldBoundsLatLon());
        return b.getCenter().getEastNorth(ProjectionRegistry.getProjection());
    }

    public boolean equalsInWindow(MapViewState other) {
        return other != null && this.viewWidth == other.viewWidth && this.viewHeight == other.viewHeight && this.scale == other.scale && Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.projecting, other.projecting);
    }

    public class MapViewRectangle {
        private final MapViewPoint p1;
        private final MapViewPoint p2;

        MapViewRectangle(MapViewPoint p1, MapViewPoint p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public ProjectionBounds getProjectionBounds() {
            ProjectionBounds b = new ProjectionBounds(this.p1.getEastNorth());
            b.extend(this.p2.getEastNorth());
            return b;
        }

        public Bounds getCornerBounds() {
            Bounds b = new Bounds(this.p1.getLatLon());
            b.extend(this.p2.getLatLon());
            return b;
        }

        public Bounds getLatLonBoundsBox() {
            return MapViewState.this.projecting.getBaseProjection().getLatLonBoundsBox(this.getProjectionBounds());
        }

        public Rectangle2D getInView() {
            double x1 = this.p1.getInViewX();
            double y1 = this.p1.getInViewY();
            double x2 = this.p2.getInViewX();
            double y2 = this.p2.getInViewY();
            return new Rectangle2D.Double(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x1 - x2), Math.abs(y1 - y2));
        }

        public boolean isInView() {
            return this.getInView().intersects(MapViewState.this.getViewArea().getInView());
        }

        public MapViewPoint getLineEntry(MapViewPoint start, MapViewPoint end) {
            EastNorth enEnd;
            EastNorth enStart;
            ProjectionBounds bounds = this.getProjectionBounds();
            if (bounds.contains(enStart = start.getEastNorth())) {
                return start;
            }
            double dx = (enEnd = end.getEastNorth()).east() - enStart.east();
            double boundX = dx > 0.0 ? bounds.minEast : bounds.maxEast;
            EastNorth borderIntersection = Geometry.getSegmentSegmentIntersection(enStart, enEnd, new EastNorth(boundX, bounds.minNorth), new EastNorth(boundX, bounds.maxNorth));
            if (borderIntersection != null) {
                return MapViewState.this.getPointFor(borderIntersection);
            }
            double dy = enEnd.north() - enStart.north();
            double boundY = dy > 0.0 ? bounds.minNorth : bounds.maxNorth;
            borderIntersection = Geometry.getSegmentSegmentIntersection(enStart, enEnd, new EastNorth(bounds.minEast, boundY), new EastNorth(bounds.maxEast, boundY));
            if (borderIntersection != null) {
                return MapViewState.this.getPointFor(borderIntersection);
            }
            return null;
        }

        public String toString() {
            return "MapViewRectangle [p1=" + this.p1 + ", p2=" + this.p2 + ']';
        }
    }

    private class MapViewEastNorthPoint
    extends MapViewPoint {
        private final EastNorth eastNorth;

        MapViewEastNorthPoint(EastNorth eastNorth) {
            this.eastNorth = Objects.requireNonNull(eastNorth, "eastNorth");
        }

        @Override
        public double getInViewX() {
            return (this.eastNorth.east() - MapViewState.this.topLeft.east()) / MapViewState.this.scale;
        }

        @Override
        public double getInViewY() {
            return (MapViewState.this.topLeft.north() - this.eastNorth.north()) / MapViewState.this.scale;
        }

        @Override
        public EastNorth getEastNorth() {
            return this.eastNorth;
        }

        public String toString() {
            return "MapViewEastNorthPoint [eastNorth=" + this.eastNorth + ']';
        }
    }

    private class MapViewViewPoint
    extends MapViewPoint {
        private final double x;
        private final double y;

        MapViewViewPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double getInViewX() {
            return this.x;
        }

        @Override
        public double getInViewY() {
            return this.y;
        }

        public String toString() {
            return "MapViewViewPoint [x=" + this.x + ", y=" + this.y + ']';
        }
    }

    public abstract class MapViewPoint {
        public MapViewState getMapViewState() {
            return MapViewState.this;
        }

        public Point2D getInView() {
            return new Point2D.Double(this.getInViewX(), this.getInViewY());
        }

        public abstract double getInViewX();

        public abstract double getInViewY();

        public Point2D getInWindow() {
            return this.getUsingCorner(MapViewState.this.topLeftInWindow);
        }

        public Point2D getOnScreen() {
            return this.getUsingCorner(MapViewState.this.topLeftOnScreen);
        }

        private Point2D.Double getUsingCorner(Point corner) {
            return new Point2D.Double(corner.getX() + this.getInViewX(), corner.getY() + this.getInViewY());
        }

        public EastNorth getEastNorth() {
            return new EastNorth(MapViewState.this.topLeft.east() + this.getInViewX() * MapViewState.this.scale, MapViewState.this.topLeft.north() - this.getInViewY() * MapViewState.this.scale);
        }

        public MapViewRectangle rectTo(MapViewPoint other) {
            return new MapViewRectangle(this, other);
        }

        public LatLon getLatLon() {
            return MapViewState.this.projecting.getBaseProjection().eastNorth2latlon(this.getEastNorth());
        }

        public LatLon getLatLonClamped() {
            return MapViewState.this.projecting.eastNorth2latlonClamped(this.getEastNorth());
        }

        public MapViewPoint add(EastNorth en) {
            return new MapViewEastNorthPoint(this.getEastNorth().add(en));
        }

        public boolean isInView() {
            return this.inRange(this.getInViewX(), 0, MapViewState.this.getViewWidth()) && this.inRange(this.getInViewY(), 0, MapViewState.this.getViewHeight());
        }

        private boolean inRange(double val, int min, double max) {
            return val >= (double)min && val < max;
        }

        public int getOutsideRectangleFlags(MapViewRectangle rect) {
            Rectangle2D bounds = rect.getInView();
            int flags = 0;
            if (this.getInViewX() < bounds.getMinX()) {
                flags |= 4;
            } else if (this.getInViewX() > bounds.getMaxX()) {
                flags |= 8;
            }
            if (this.getInViewY() < bounds.getMinY()) {
                flags |= 1;
            } else if (this.getInViewY() > bounds.getMaxY()) {
                flags |= 2;
            }
            return flags;
        }

        public double oneNormInView(MapViewPoint p2) {
            return Math.abs(this.getInViewX() - p2.getInViewX()) + Math.abs(this.getInViewY() - p2.getInViewY());
        }

        public double distanceToInViewSq(MapViewPoint p2) {
            double dx = this.getInViewX() - p2.getInViewX();
            double dy = this.getInViewY() - p2.getInViewY();
            return dx * dx + dy * dy;
        }

        public double distanceToInView(MapViewPoint p2) {
            return Math.sqrt(this.distanceToInViewSq(p2));
        }

        public MapViewPoint interpolate(MapViewPoint p1, double i) {
            return new MapViewViewPoint((1.0 - i) * this.getInViewX() + i * p1.getInViewX(), (1.0 - i) * this.getInViewY() + i * p1.getInViewY());
        }
    }
}

