/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerContainerDetail;
import org.netbeans.modules.docker.ui.commit.CommitContainerAction;
import org.netbeans.modules.docker.ui.node.AttachContainerAction;
import org.netbeans.modules.docker.ui.node.CopyIdAction;
import org.netbeans.modules.docker.ui.node.GetPortMappingsAction;
import org.netbeans.modules.docker.ui.node.PauseContainerAction;
import org.netbeans.modules.docker.ui.node.RefreshAction;
import org.netbeans.modules.docker.ui.node.RemoveContainerAction;
import org.netbeans.modules.docker.ui.node.ShowLogAction;
import org.netbeans.modules.docker.ui.node.StartContainerAction;
import org.netbeans.modules.docker.ui.node.StatefulDockerContainer;
import org.netbeans.modules.docker.ui.node.StopContainerAction;
import org.netbeans.modules.docker.ui.node.UnpauseContainerAction;
import org.netbeans.modules.docker.ui.rename.RenameContainerAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class DockerContainerNode
extends AbstractNode {
    private static final String DOCKER_INSTANCE_ICON = "org/netbeans/modules/docker/ui/resources/docker_image.png";
    private static final String PAUSED_ICON = "org/netbeans/modules/docker/ui/resources/badge_paused.png";
    private static final String RUNNING_ICON = "org/netbeans/modules/docker/ui/resources/badge_running.png";
    private final StatefulDockerContainer container;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            DockerContainerNode.this.fireIconChange();
            DockerContainerNode.this.fireDisplayNameChange(null, null);
        }
    };

    public DockerContainerNode(StatefulDockerContainer container) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{container.getContainer(), container}));
        this.container = container;
        DockerContainer dockerContainer = container.getContainer();
        this.setShortDescription(dockerContainer.getShortId());
        this.setIconBaseWithExtension(DOCKER_INSTANCE_ICON);
        container.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)container));
        container.refresh();
    }

    public String getDisplayName() {
        DockerContainer dockerContainer = this.container.getContainer();
        DockerContainerDetail detail = this.container.getDetail();
        StringBuilder ret = new StringBuilder(dockerContainer.getImage());
        if (detail.getName() != null) {
            ret.append(detail.getName());
        }
        ret.append(" [").append(dockerContainer.getShortId()).append("]");
        return ret.toString();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(StartContainerAction.class), SystemAction.get(StopContainerAction.class), SystemAction.get(PauseContainerAction.class), SystemAction.get(UnpauseContainerAction.class), null, SystemAction.get(CommitContainerAction.class), SystemAction.get(RenameContainerAction.class), null, SystemAction.get(AttachContainerAction.class), SystemAction.get(ShowLogAction.class), null, SystemAction.get(CopyIdAction.class), SystemAction.get(GetPortMappingsAction.class), null, SystemAction.get(RefreshAction.class), null, SystemAction.get(RemoveContainerAction.class)};
    }

    public Image getIcon(int type) {
        Image original = super.getIcon(type);
        return DockerContainerNode.badgeIcon(original, this.container.getDetail().getStatus());
    }

    private static Image badgeIcon(Image image, DockerContainer.Status status) {
        Image badge = null;
        switch (status) {
            case PAUSED: {
                badge = ImageUtilities.loadImage((String)PAUSED_ICON);
                break;
            }
            case RUNNING: {
                badge = ImageUtilities.loadImage((String)RUNNING_ICON);
                break;
            }
        }
        return badge != null ? ImageUtilities.mergeImages((Image)image, (Image)badge, (int)13, (int)8) : image;
    }
}

