/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.html.ojet.data.DataItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DataItemImpl
implements DataItem {
    private final String name;
    private final String docUrl;
    private final String template;

    public DataItemImpl(String name, String docUrl) {
        this.name = name;
        this.docUrl = docUrl;
        this.template = null;
    }

    public DataItemImpl(String name, String docUrl, String template) {
        this.name = name;
        this.docUrl = docUrl;
        this.template = template;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDocumentation() {
        return null;
    }

    @Override
    public String getDocUrl() {
        return this.docUrl;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    private static InputStream getInputStream(URL url) {
        URL rootURL = FileUtil.getArchiveFile((URL)url);
        FileObject rootFO = FileUtil.toFileObject((File)FileUtil.archiveOrDirForURL((URL)rootURL));
        rootFO = FileUtil.getArchiveRoot((FileObject)rootFO);
        FileObject docFO = rootFO.getFileObject(url.toString().substring(rootURL.toString().length() + 5));
        InputStream result = null;
        try {
            result = docFO.getInputStream();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader(in, "UTF-8");){
            int read;
            char[] buf = new char[2048];
            while ((read = r.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        return sb.toString();
    }

    public static class DataItemModuleProperty
    extends DataItemImpl {
        private final String description;

        public DataItemModuleProperty(String name, String description, String docUrl) {
            super(name, docUrl);
            this.description = description;
        }

        @Override
        public String getDocumentation() {
            return this.description;
        }
    }

    public static class DataItemEvent
    extends DataItemImpl {
        public DataItemEvent(String name, String docUrl) {
            super(name, docUrl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDocumentation() {
            InputStream in = null;
            try {
                String result;
                String line;
                in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                StringBuilder content = new StringBuilder();
                String startText = "<h4 id=\"event:" + this.getName() + "\" class=\"name\">";
                boolean inSection = false;
                content.append("<dt>");
                int ddCount = 0;
                while ((line = br.readLine()) != null) {
                    if (!inSection && line.contains(startText)) {
                        inSection = true;
                    }
                    if (!inSection) continue;
                    content.append(line);
                    if (line.contains("<dd")) {
                        ++ddCount;
                    }
                    if (!line.contains("</dd") || --ddCount != 0) continue;
                }
                br.close();
                String string = result = content.toString();
                return string;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    public static class DataItemOption
    extends DataItemImpl {
        public DataItemOption(String name, String docUrl) {
            super(name, docUrl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDocumentation() {
            InputStream in = null;
            try {
                String result;
                String line;
                in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                StringBuilder content = new StringBuilder();
                String startText = "<h4 id=\"" + this.getName() + "\" class=\"name\">";
                boolean inSection = false;
                content.append("<dt>");
                int ddCount = 0;
                while ((line = br.readLine()) != null) {
                    if (!inSection && line.contains(startText)) {
                        inSection = true;
                    }
                    if (!inSection) continue;
                    content.append(line);
                    if (line.contains("<dd")) {
                        ++ddCount;
                    }
                    if (!line.contains("</dd") || --ddCount != 0) continue;
                }
                br.close();
                String string = result = content.toString();
                return string;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    public static class DataItemComponent
    extends DataItemImpl {
        private static final String EVENT_NAME_START = "id=\"event:";
        private List<DataItem> options = null;
        private List<DataItem> events = null;

        public DataItemComponent(String name, String docUrl) {
            super(name, docUrl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getDocumentation() {
            InputStream in = null;
            try {
                String line;
                in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                StringBuilder content = new StringBuilder();
                int countHeader = 0;
                while ((line = br.readLine()) != null) {
                    if (line.contains("<header>")) {
                        ++countHeader;
                    }
                    if (countHeader <= 1) continue;
                    content.append(line);
                    if (!line.contains("</header") || --countHeader != 1) continue;
                }
                br.close();
                String string = content.toString();
                return string;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DataItem> getOptions() {
            if (this.options == null) {
                this.options = new ArrayList<DataItem>();
                InputStream in = null;
                try {
                    String line;
                    in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    boolean inMembers = false;
                    int ulBalance = 0;
                    while ((line = br.readLine()) != null) {
                        if (!inMembers && line.contains("<a href=\"#members-section\">")) {
                            inMembers = true;
                        }
                        if (!inMembers) continue;
                        if (line.contains("<ul")) {
                            ++ulBalance;
                        }
                        if (line.contains("<li>") && line.contains("<a") && ulBalance == 1) {
                            String name = line.substring(line.indexOf(">", line.indexOf("<a")) + 1).trim();
                            while (name.charAt(0) == '<') {
                                name = name.substring(name.indexOf(62) + 1).trim();
                            }
                            if (!(name = name.substring(0, name.indexOf(60)).trim()).isEmpty()) {
                                this.options.add(new DataItemOption(name, this.getDocUrl()));
                            }
                        }
                        if (!line.contains("</ul>") || --ulBalance != 0) continue;
                    }
                    br.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return Collections.unmodifiableCollection(this.options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DataItem> getEvents() {
            if (this.events == null) {
                this.events = new ArrayList<DataItem>();
                InputStream in = null;
                try {
                    String line;
                    in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    boolean inMembers = false;
                    boolean ulBalance = false;
                    int index = -1;
                    while ((line = br.readLine()) != null) {
                        index = line.indexOf(EVENT_NAME_START);
                        if (index <= -1) continue;
                        int end = line.indexOf(34, index += EVENT_NAME_START.length());
                        String name = line.substring(index, end);
                        this.events.add(new DataItemEvent(name, this.getDocUrl()));
                    }
                    br.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return Collections.unmodifiableCollection(this.events);
        }
    }

    public static class DataItemModule
    extends DataItemImpl {
        private static String NAME_RECOGNIZER_TEXT = "class=\"name\"><code>";
        private static String START_DESCRIPTION_RECOGNIZER_TEXT = "<td class=\"description last\">";
        private static String END_DESCRIPTION_RECOGNIZER_TEXT = "</td>";
        private static String PROPERTIES_RECOGNIZER_TEXT = "Properties:";
        private List<DataItem> properties = null;

        public DataItemModule(String docUrl) {
            super("ojModule", docUrl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DataItem> getProperies() {
            if (this.properties == null) {
                this.properties = new ArrayList<DataItem>();
                InputStream in = null;
                try {
                    String line;
                    in = DataItemImpl.getInputStream(new URL(this.getDocUrl()));
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    boolean inProperties = false;
                    boolean inDescription = false;
                    String name = "";
                    String description = "";
                    while ((line = br.readLine()) != null) {
                        int index;
                        if (!inProperties && line.contains(PROPERTIES_RECOGNIZER_TEXT)) {
                            inProperties = true;
                        }
                        if (!inProperties) continue;
                        if (inDescription) {
                            index = line.indexOf(END_DESCRIPTION_RECOGNIZER_TEXT);
                            if (index > -1) {
                                description = description + "\n" + line.substring(0, index);
                                inDescription = false;
                                this.properties.add(new DataItemModuleProperty(name, description, this.getDocUrl()));
                                continue;
                            }
                            description = description + "\n" + line;
                            continue;
                        }
                        if (line.contains(NAME_RECOGNIZER_TEXT)) {
                            index = line.indexOf(NAME_RECOGNIZER_TEXT) + NAME_RECOGNIZER_TEXT.length();
                            name = line.substring(index, line.indexOf(60, index));
                        }
                        if (!line.contains(START_DESCRIPTION_RECOGNIZER_TEXT)) continue;
                        inDescription = true;
                        description = line.substring(line.indexOf(START_DESCRIPTION_RECOGNIZER_TEXT) + START_DESCRIPTION_RECOGNIZER_TEXT.length());
                    }
                    br.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return Collections.unmodifiableCollection(this.properties);
        }
    }
}

