/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.web.ChainServlet;
import org.apache.commons.chain.web.servlet.ServletWebContext;

public class ChainProcessor
extends ChainServlet {
    public static final String CATALOG = "org.apache.commons.chain.CATALOG";
    public static final String CATALOG_DEFAULT = "org.apache.commons.chain.CATALOG";
    public static final String COMMAND = "org.apache.commons.chain.COMMAND";
    private static final String COMMAND_DEFAULT = "command";
    private String attribute = null;
    private String catalog = null;
    private String command = null;

    public void destroy() {
        super.destroy();
        this.attribute = null;
        this.catalog = null;
        this.command = null;
    }

    public void init() throws ServletException {
        super.init();
        this.attribute = this.getServletConfig().getInitParameter("org.apache.commons.chain.CONFIG_ATTR");
        this.catalog = this.getServletConfig().getInitParameter("org.apache.commons.chain.CATALOG");
        this.command = this.getServletConfig().getInitParameter(COMMAND);
        if (this.command == null) {
            this.command = COMMAND_DEFAULT;
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletWebContext context = new ServletWebContext(this.getServletContext(), request, response);
        Catalog theCatalog = null;
        theCatalog = this.attribute != null ? (Catalog)this.getServletContext().getAttribute(this.attribute) : (this.catalog != null ? CatalogFactory.getInstance().getCatalog(this.catalog) : CatalogFactory.getInstance().getCatalog());
        if (this.attribute == null) {
            request.setAttribute("org.apache.commons.chain.CATALOG", (Object)theCatalog);
        }
        Command command = theCatalog.getCommand(this.command);
        try {
            command.execute(context);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

