/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class TldAntLogger
extends AntLogger {
    private static final Pattern TLD_ERROR = Pattern.compile("(.*)(org.apache.jasper.JasperException:)(.*)( file )(.*)");
    private static final Pattern FILE_PATTERN = Pattern.compile("([^\\(]*)(: )\\(line ([0-9]+), col ([0-9-]+)\\)");
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final Logger ERR = Logger.getLogger(TldAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public String[] interestedInTasks(AntSession session) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        AntSession session = event.getSession();
        int messageLevel = event.getLogLevel();
        int sessionLevel = session.getVerbosity();
        String line = event.getMessage();
        assert (line != null);
        Matcher m = TLD_ERROR.matcher(line);
        if (m.matches()) {
            block14: {
                Matcher fileMatcher;
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "matched line: " + line);
                }
                String errorText = m.group(3) + m.group(4);
                session.println(m.group(2) + errorText, true, null);
                String filePart = m.group(5).trim();
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "file part: " + filePart);
                }
                if ((fileMatcher = FILE_PATTERN.matcher(filePart)).matches()) {
                    String tldFile = fileMatcher.group(1).trim();
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "tld file: " + tldFile);
                    }
                    int lineNumber = Integer.parseInt(fileMatcher.group(3));
                    int columnNumber = Integer.parseInt(fileMatcher.group(4));
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "linking line: " + lineNumber + ", column: " + columnNumber);
                    }
                    File scriptLoc = event.getScriptLocation();
                    FileObject scriptLocFO = FileUtil.toFileObject((File)scriptLoc);
                    WebModule wm = WebModule.getWebModule((FileObject)scriptLocFO);
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "wm: " + wm);
                    }
                    if (wm == null) {
                        session.println(tldFile, true, null);
                        event.consume();
                        return;
                    }
                    FileObject tldSource = wm.getDocumentBase().getFileObject(tldFile);
                    if (LOGGABLE) {
                        ERR.log(Level.FINE, "tldSource: " + tldSource);
                    }
                    if (tldSource == null) {
                        session.println(tldFile, true, null);
                        event.consume();
                        return;
                    }
                    if (messageLevel <= sessionLevel && !event.isConsumed()) {
                        try {
                            session.println(tldFile, true, session.createStandardHyperlink(tldSource.getURL(), errorText + tldFile, lineNumber, columnNumber, -1, -1));
                        }
                        catch (FileStateInvalidException e) {
                            if ($assertionsDisabled) break block14;
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
            event.consume();
        }
    }
}

