/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.spi.ConfigurationResourceProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.editor.JsfFacesComponentsProvider;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.EmptyServletContext;
import org.netbeans.modules.web.jsf.editor.facelets.PureCompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.WebFaceletTaglibResourceProvider;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.ConfigManager;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.FaceletsTaglibConfigProcessor;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FaceletsLibrarySupport {
    private static final RequestProcessor RP = new RequestProcessor(FaceletsLibrarySupport.class);
    private static final RequestProcessor FC_REFRESH_RP = new RequestProcessor("FLSFacesComponentsRefresh", 1);
    private JsfSupportImpl jsfSupport;
    private Map<String, Library> faceletsLibraries;
    private long libraries_hash;
    private boolean checkLibrariesUpToDate;
    private static final Logger LOGGER = Logger.getLogger(FaceletsLibrarySupport.class.getSimpleName());
    private RequestProcessor.Task facesComponentsRefreshTask;
    private volatile Collection<? extends Library> facesComponentsCache = new ArrayList<Library>();
    private FileChangeListener DDLISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Invalidating facelets libraries due to changes in web.xml deployment descriptor.");
                    FaceletsLibrarySupport.this.invalidateLibrariesCache();
                }
            });
        }
    };
    private static final String DD_FILE_NAME = "web.xml";

    public FaceletsLibrarySupport(JsfSupportImpl jspSupport) {
        this.jsfSupport = jspSupport;
        WebModule webModule = this.jsfSupport.getWebModule();
        if (webModule != null) {
            FileObject webInf;
            FileObject dd = webModule.getDeploymentDescriptor();
            if (dd != null) {
                dd.addFileChangeListener(this.DDLISTENER);
            }
            if ((webInf = webModule.getWebInf()) != null) {
                webInf.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fe) {
                        FileObject file = fe.getFile();
                        if (file.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                            file.addFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                        }
                    }

                    public void fileDeleted(FileEvent fe) {
                        FileObject file = fe.getFile();
                        if (file.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                            file.removeFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                        }
                    }
                });
            }
        }
    }

    public JsfSupportImpl getJsfSupport() {
        return this.jsfSupport;
    }

    private synchronized void invalidateLibrariesCache() {
        this.faceletsLibraries = null;
    }

    public void indexedContentPossiblyChanged() {
        this.checkLibraryDescriptorsUpToDate();
    }

    public synchronized Map<String, Library> getLibraries() {
        if (this.faceletsLibraries == null) {
            this.refreshFacesComponentsCache(0);
            this.faceletsLibraries = this.findLibraries();
            if (this.faceletsLibraries == null) {
                return Collections.emptyMap();
            }
            this.updateCompositeLibraries(this.faceletsLibraries);
        }
        this.updateFacesComponentLibraries(this.faceletsLibraries);
        return this.faceletsLibraries;
    }

    private void checkLibraryDescriptorsUpToDate() {
        long hash = 7L;
        for (IndexedFile indexedFile : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            String md5checksum = indexedFile.getMD5Checksum();
            hash = 79L * hash + (long)md5checksum.hashCode();
        }
        for (String ccLibName : this.getJsfSupport().getIndex().getAllCompositeLibraryNames()) {
            hash = 79L * hash + (long)ccLibName.hashCode();
        }
        if (hash != this.libraries_hash) {
            LOGGER.info("Invalidating facelets libraries due to a library descriptor change.");
            this.invalidateLibrariesCache();
            this.libraries_hash = hash;
        }
    }

    private void updateCompositeLibraries(Map<String, Library> faceletsLibraries) {
        ArrayList<String> libraryNames = new ArrayList<String>(this.jsfSupport.getIndex().getAllCompositeLibraryNames());
        HashMap<String, CompositeComponentLibrary> cclibsMap = new HashMap<String, CompositeComponentLibrary>();
        for (Library lib : faceletsLibraries.values()) {
            if (!(lib instanceof CompositeComponentLibrary)) continue;
            CompositeComponentLibrary cclib = (CompositeComponentLibrary)lib;
            cclibsMap.put(cclib.getDefaultNamespace(), cclib);
            String libraryName = cclib.getLibraryName();
            libraryNames.remove(libraryName);
        }
        faceletsLibraries.putAll(cclibsMap);
        for (String libraryName : libraryNames) {
            PureCompositeComponentLibrary ccl = new PureCompositeComponentLibrary(this, libraryName);
            faceletsLibraries.put(ccl.getDefaultNamespace(), ccl);
        }
    }

    private void updateFacesComponentLibraries(Map<String, Library> faceletsLibraries) {
        this.refreshFacesComponentsCache(300);
        Iterator<Map.Entry<String, Library>> iterator = faceletsLibraries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Library> entry = iterator.next();
            if (entry.getValue().getType() != LibraryType.COMPONENT) continue;
            iterator.remove();
        }
        for (Library library : this.facesComponentsCache) {
            faceletsLibraries.put(library.getDefaultNamespace(), library);
        }
    }

    private Map<String, Library> findLibraries() {
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(FaceletsLibrarySupport.class, (String)"MSG_ParsingFaceletsLibraries"));
        progress.start();
        progress.switchToIndeterminate();
        try {
            Map<String, Library> map = this._findLibraries();
            return map;
        }
        finally {
            progress.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Library> _findLibraries() {
        ClassLoader originalLoader = this.getClass().getClassLoader();
        LOGGER.log(Level.FINE, "Scanning facelets libraries, current classloader class={0}, the used URLClassLoader will also contain following roots:", originalLoader.getClass().getName());
        ArrayList<URL> urlsToLoad = new ArrayList<URL>();
        for (FileObject cpRoot : this.getJsfSupport().getClassPath().getRoots()) {
            try {
                String fsName = cpRoot.getFileSystem().getDisplayName();
                if (!fsName.endsWith("javax.faces.jar")) {
                    urlsToLoad.add(URLMapper.findURL((FileObject)cpRoot, (int)0));
                    LOGGER.log(Level.FINE, "+++{0}", cpRoot);
                    continue;
                }
                LOGGER.log(Level.FINE, "---{0}", cpRoot);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        URLClassLoader proxyLoader = new URLClassLoader(urlsToLoad.toArray(new URL[0]), originalLoader){

            @Override
            public URL findResource(String name) {
                return name.startsWith("META-INF/services") ? null : super.findResource(name);
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                if (name.startsWith("META-INF/services")) {
                    return Collections.enumeration(Collections.emptyList());
                }
                return super.findResources(name);
            }
        };
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(proxyLoader);
            Map<String, Library> map = this.parseLibraries();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    private Map<String, Library> parseLibraries() {
        JSFVersion jsfVersion;
        ArrayList<ConfigurationResourceProvider> faceletTaglibProviders = new ArrayList<ConfigurationResourceProvider>();
        WebModule webModule = this.getJsfSupport().getWebModule();
        if (webModule != null) {
            faceletTaglibProviders.add(new WebFaceletTaglibResourceProvider(webModule));
        }
        final ArrayList<URI> uris = new ArrayList<URI>();
        for (IndexedFile file : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            try {
                uris.add(URLMapper.findURL((FileObject)file.getFile(), (int)1).toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        faceletTaglibProviders.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext sc) {
                return uris;
            }
        });
        Collection<FileObject> libraryDescriptorFiles = DefaultFaceletLibraries.getInstance().getLibrariesDescriptorsFiles();
        final ArrayList<URI> libraryURIs = new ArrayList<URI>();
        for (FileObject fo : libraryDescriptorFiles) {
            try {
                libraryURIs.add(fo.toURL().toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        faceletTaglibProviders.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext sc) {
                return libraryURIs;
            }
        });
        EmptyServletContext sc = new EmptyServletContext();
        DocumentInfo[] documents = ConfigManager.getConfigDocuments(sc, faceletTaglibProviders, null, true);
        if (documents == null) {
            return null;
        }
        FaceletsTaglibConfigProcessor processor = new FaceletsTaglibConfigProcessor(this);
        processor.process(new EmptyServletContext(), documents);
        HashMap<String, Library> libsMap = new HashMap<String, Library>();
        for (Library lib : processor.compiler.libraries) {
            if (lib.getLegacyNamespace() != null) {
                libsMap.put(lib.getLegacyNamespace(), lib);
                continue;
            }
            libsMap.put(lib.getNamespace(), lib);
        }
        if (webModule != null && (jsfVersion = JSFVersion.forWebModule((WebModule)webModule)) != null && jsfVersion.isAtLeast(JSFVersion.JSF_2_2)) {
            libsMap.putAll(DefaultFaceletLibraries.getJsf22FaceletPseudoLibraries(this));
        }
        return libsMap;
    }

    private synchronized void refreshFacesComponentsCache(int timeToWait) {
        if (this.facesComponentsRefreshTask == null || this.facesComponentsRefreshTask.isFinished()) {
            this.facesComponentsRefreshTask = FC_REFRESH_RP.post((Runnable)new RefreshFacesComponentsTask(), timeToWait);
        }
    }

    private final class RefreshFacesComponentsTask
    implements Runnable {
        private RefreshFacesComponentsTask() {
        }

        @Override
        public void run() {
            Collection libraries = JsfFacesComponentsProvider.getLibraries((Project)FaceletsLibrarySupport.this.jsfSupport.getProject());
            FaceletsLibrarySupport.this.facesComponentsCache = libraries;
        }
    }

    public static class Compiler {
        private Collection<Library> libraries = new HashSet<Library>();

        public void addTagLibrary(Library lib) {
            this.libraries.add(lib);
        }
    }
}

