/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.jpqleditor.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.Bundle;
import org.netbeans.modules.j2ee.persistence.jpqleditor.ui.ReflectionInfo;

public class ReflectiveTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(ReflectiveTableModel.class.getName());
    private final List<ReflectionInfo> reflectionInfo;
    private final List<Object> data;

    public ReflectiveTableModel(List<ReflectionInfo> reflectionInfo, List<Object> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        this.reflectionInfo = reflectionInfo;
        this.data = data;
    }

    @Override
    public String getColumnName(int columnIndex) {
        ReflectionInfo ri = this.reflectionInfo.get(columnIndex);
        if (ri.getIndex() == null && ri.getPropertyName() == null) {
            return Bundle.LBL_QueryResultDefaultColumnName();
        }
        if (ri.getIndex() != null && ri.getPropertyName() == null) {
            return Bundle.LBL_Index(ri.getIndex());
        }
        if (ri.getIndex() == null && ri.getPropertyName() != null) {
            return ri.getPropertyName();
        }
        return Bundle.LBL_IndexProperty(ri.getIndex(), ri.getPropertyName());
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.reflectionInfo.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object dataItem = this.data.get(rowIndex);
        if (dataItem == null) {
            return null;
        }
        ReflectionInfo ri = this.reflectionInfo.get(columnIndex);
        if (ri.getIndex() != null) {
            dataItem = ((Object[])dataItem)[ri.getIndex()];
        }
        if (dataItem == null || ri.getPropertyName() == null) {
            return dataItem;
        }
        Class<?> klass = dataItem.getClass();
        String property = ri.getPropertyName();
        String getterString = "get" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
        String isString = "is" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1);
        try {
            Method getter = klass.getMethod(getterString, new Class[0]);
            return getter.invoke(dataItem, new Object[0]);
        }
        catch (NoSuchMethodException getter) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.WARNING, "Failed to reflect", ex);
            return null;
        }
        try {
            Method getter = klass.getMethod(isString, new Class[0]);
            return getter.invoke(dataItem, new Object[0]);
        }
        catch (NoSuchMethodException getter) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.WARNING, "Failed to reflect", ex);
            return null;
        }
        return null;
    }
}

