/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class CoverageHighlightsContainer
extends AbstractHighlightsContainer
implements DocumentListener {
    private AttributeSet covered;
    private AttributeSet uncovered;
    private AttributeSet inferred;
    private AttributeSet partial;
    private List<Position> lastPositions;
    private List<CoverageType> lastTypes;
    private boolean enabled;
    private boolean listening;
    private final JTextComponent component;
    private final BaseDocument doc;
    private final String mimeType;
    private long version = 0L;
    private FileObject fileObject;
    private Project project;

    CoverageHighlightsContainer(JTextComponent component) {
        this.component = component;
        Document document = component.getDocument();
        this.doc = document instanceof BaseDocument ? (BaseDocument)document : null;
        this.mimeType = (String)document.getProperty("mimeType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        this.enabled = false;
        CoverageManagerImpl manager = CoverageManagerImpl.getInstance();
        if (this.doc == null || manager == null || !manager.isEnabled(this.mimeType)) {
            return HighlightsSequence.EMPTY;
        }
        this.enabled = true;
        CoverageHighlightsContainer coverageHighlightsContainer = this;
        synchronized (coverageHighlightsContainer) {
            if (this.fileObject == null) {
                this.fileObject = GsfUtilities.findFileObject((Document)this.doc);
                this.project = this.fileObject != null ? FileOwnerQuery.getOwner((FileObject)this.fileObject) : null;
                if (this.fileObject == null || this.project == null) {
                    return HighlightsSequence.EMPTY;
                }
            }
        }
        FileCoverageDetails details = manager.getDetails(this.project, this.fileObject, this.component);
        if (details == null) {
            return HighlightsSequence.EMPTY;
        }
        this.initColors();
        if (!this.listening) {
            this.listening = true;
            this.doc.addDocumentListener(WeakListeners.document((DocumentListener)this, null));
        }
        return new Highlights(0L, startOffset, endOffset, details);
    }

    private static Color getColoring(FontColorSettings fcs, String tokenName) {
        AttributeSet as = fcs.getTokenFontColors(tokenName);
        if (as != null) {
            return (Color)as.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private void initColors() {
        if (this.covered != null) {
            return;
        }
        Color coveredBc = null;
        Color uncoveredBc = null;
        Color inferredBc = null;
        Color partialBc = null;
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)this.mimeType).lookup(FontColorSettings.class);
        if (fcs != null) {
            coveredBc = CoverageHighlightsContainer.getColoring(fcs, "covered");
            uncoveredBc = CoverageHighlightsContainer.getColoring(fcs, "uncovered");
            inferredBc = CoverageHighlightsContainer.getColoring(fcs, "inferred");
            partialBc = CoverageHighlightsContainer.getColoring(fcs, "partial");
        }
        if (coveredBc == null) {
            coveredBc = new Color(204, 255, 204);
        }
        if (uncoveredBc == null) {
            uncoveredBc = new Color(255, 204, 204);
        }
        if (inferredBc == null) {
            inferredBc = new Color(224, 255, 224);
        }
        if (partialBc == null) {
            partialBc = new Color(255, 255, 224);
        }
        this.covered = coveredBc == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, coveredBc, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", Boolean.TRUE});
        this.uncovered = uncoveredBc == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, uncoveredBc, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", Boolean.TRUE});
        this.inferred = inferredBc == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, inferredBc, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", Boolean.TRUE});
        this.partial = partialBc == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, partialBc, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", Boolean.TRUE});
    }

    void refresh() {
        this.lastPositions = null;
        this.lastTypes = null;
        this.fireHighlightsChange(0, this.doc.getLength());
    }

    private void handleEdits(int offset, int length, boolean inserted) {
        try {
            int positionIndex;
            List<Position> positions;
            String s;
            assert (length > 0);
            if (inserted && (s = this.doc.getText(offset, length)).trim().length() == 0 && (Utilities.isRowEmpty((BaseDocument)this.doc, (int)offset) || offset >= Utilities.getRowLastNonWhite((BaseDocument)this.doc, (int)offset) + 1 || offset <= Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset))) {
                this.fireHighlightsChange(offset, offset + length);
                return;
            }
            int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)offset);
            if (lineStart == -1) {
                lineStart = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
            }
            if ((positions = this.lastPositions) != null && (positionIndex = this.findPositionIndex(positions, lineStart)) >= 0) {
                ArrayList<Position> copy = new ArrayList<Position>(positions);
                copy.remove(positionIndex);
                this.lastPositions = copy;
                this.fireHighlightsChange(offset, offset + length);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        if (this.enabled) {
            this.handleEdits(ev.getOffset(), ev.getLength(), true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    private int findPositionIndex(List<Position> positions, final int target) {
        return Collections.binarySearch(positions, new Position(){

            @Override
            public int getOffset() {
                return target;
            }
        }, new Comparator<Position>(){

            @Override
            public int compare(Position pos1, Position pos2) {
                return pos1.getOffset() - pos2.getOffset();
            }
        });
    }

    private class Highlights
    implements HighlightsSequence {
        private final List<Position> positions;
        private final List<CoverageType> types;
        private final long version;
        private final int startOffsetBoundary;
        private final int endOffsetBoundary;
        private int startOffset;
        private int endOffset;
        private AttributeSet attributeSet;
        private boolean finished = false;
        private int index;

        private Highlights(long version, int startOffset, int endOffset, FileCoverageDetails details) {
            this.version = version;
            this.startOffsetBoundary = startOffset;
            this.endOffsetBoundary = endOffset;
            if (CoverageHighlightsContainer.this.lastPositions == null) {
                this.positions = new ArrayList<Position>();
                this.types = new ArrayList<CoverageType>();
                int maxLines = details.getLineCount();
                for (int lineno = 0; lineno < maxLines; ++lineno) {
                    CoverageType type = details.getType(lineno);
                    if (type != CoverageType.COVERED && type != CoverageType.INFERRED && type != CoverageType.NOT_COVERED && type != CoverageType.PARTIAL) continue;
                    try {
                        int offset = Utilities.getRowStartFromLineOffset((BaseDocument)CoverageHighlightsContainer.this.doc, (int)lineno);
                        if (offset == -1) continue;
                        int rowStart = Utilities.getRowFirstNonWhite((BaseDocument)CoverageHighlightsContainer.this.doc, (int)offset);
                        if (rowStart != -1) {
                            offset = rowStart;
                        }
                        Position pos = CoverageHighlightsContainer.this.doc.createPosition(offset, Position.Bias.Forward);
                        this.positions.add(pos);
                        this.types.add(type);
                        continue;
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                CoverageHighlightsContainer.this.lastPositions = this.positions;
                CoverageHighlightsContainer.this.lastTypes = this.types;
            } else {
                this.positions = CoverageHighlightsContainer.this.lastPositions;
                this.types = CoverageHighlightsContainer.this.lastTypes;
            }
            try {
                int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)CoverageHighlightsContainer.this.doc, (int)this.startOffsetBoundary);
                if (lineStart == -1) {
                    lineStart = Utilities.getRowStart((BaseDocument)CoverageHighlightsContainer.this.doc, (int)this.startOffsetBoundary);
                    this.index = CoverageHighlightsContainer.this.findPositionIndex(this.positions, lineStart);
                    if (this.index < 0) {
                        this.index = -this.index;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private boolean _moveNext() {
            while (this.index < this.positions.size()) {
                Position pos = this.positions.get(this.index);
                int offset = pos.getOffset();
                try {
                    offset = Utilities.getRowStart((BaseDocument)CoverageHighlightsContainer.this.doc, (int)offset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (offset > this.endOffsetBoundary) break;
                if (offset >= this.startOffsetBoundary) {
                    this.startOffset = offset;
                    try {
                        this.endOffset = Utilities.getRowEnd((BaseDocument)CoverageHighlightsContainer.this.doc, (int)offset);
                        if (this.endOffset < CoverageHighlightsContainer.this.doc.getLength()) {
                            ++this.endOffset;
                        }
                        CoverageType type = this.types.get(this.index);
                        switch (type) {
                            case COVERED: {
                                this.attributeSet = CoverageHighlightsContainer.this.covered;
                                break;
                            }
                            case NOT_COVERED: {
                                this.attributeSet = CoverageHighlightsContainer.this.uncovered;
                                break;
                            }
                            case INFERRED: {
                                this.attributeSet = CoverageHighlightsContainer.this.inferred;
                                break;
                            }
                            case PARTIAL: {
                                this.attributeSet = CoverageHighlightsContainer.this.partial;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    ++this.index;
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.checkVersion() && this._moveNext()) {
                    return true;
                }
            }
            this.finished = true;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.startOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.endOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsContainer.this;
            synchronized (coverageHighlightsContainer) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == CoverageHighlightsContainer.this.version;
        }
    }
}

