/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class TokenReplacer {
    private Map<String, String> tokens = new HashMap<String, String>();
    private final ClientStubsGenerator clientStubsGenerator;

    TokenReplacer(ClientStubsGenerator clientStubsGenerator) {
        this.clientStubsGenerator = clientStubsGenerator;
    }

    public Map<String, String> getTokens() {
        return Collections.unmodifiableMap(this.tokens);
    }

    public void addToken(String name, String value) {
        this.tokens.put(name, value);
    }

    public void setTokens(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    public void replaceTokens(FileObject fo) throws IOException {
        this.replaceTokens(fo, this.getTokens());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTokens(FileObject fo, Map<String, String> tokenMap) throws IOException {
        FileLock lock = fo.lock();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)fo)), Charset.forName("UTF-8")));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                line = this.replaceTokens(line, "", "", tokenMap);
                sb.append(line);
                sb.append("\n");
            }
            OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), this.clientStubsGenerator.getBaseEncoding());
            try {
                writer.write(sb.toString());
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected ClientStubsGenerator getGenerator() {
        return this.clientStubsGenerator;
    }

    private String replaceTokens(String line, String object, String pkg, Map<String, String> tokenMap) {
        String replacedLine = line;
        for (Map.Entry<String, String> e : tokenMap.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key == null || value == null) continue;
            replacedLine = replacedLine.replaceAll(key, value);
        }
        return replacedLine;
    }
}

