/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.matchers;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import com.oracle.truffle.regex.tregex.matchers.RangeTreeMatcherNodeGen;
import com.oracle.truffle.regex.tregex.util.MathUtil;

public abstract class RangeTreeMatcher
extends InvertibleCharMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final char[] tree;

    public static RangeTreeMatcher fromRanges(boolean invert, char[] ranges) {
        char[] tree = new char[ranges.length];
        RangeTreeMatcher.buildTree(tree, 0, ranges, 0, ranges.length / 2);
        return RangeTreeMatcherNodeGen.create(invert, tree);
    }

    private static void buildTree(char[] tree, int curTreeElement, char[] ranges, int offset, int nRanges) {
        int nRight;
        int nLeft;
        if (nRanges == 0) {
            return;
        }
        if (nRanges == 1) {
            tree[curTreeElement] = ranges[offset];
            tree[curTreeElement + 1] = ranges[offset + 1];
            return;
        }
        int nearestPowerOf2 = Integer.highestOneBit(nRanges);
        int remainder = nRanges - (nearestPowerOf2 - 1);
        if (remainder <= nearestPowerOf2 / 2) {
            nLeft = (nearestPowerOf2 - 2) / 2 + remainder;
            nRight = (nearestPowerOf2 - 2) / 2;
        } else {
            nLeft = nearestPowerOf2 - 1;
            nRight = remainder - 1;
        }
        int median = offset + nLeft * 2;
        tree[curTreeElement] = ranges[median];
        tree[curTreeElement + 1] = ranges[median + 1];
        RangeTreeMatcher.buildTree(tree, RangeTreeMatcher.leftChild(curTreeElement), ranges, offset, nLeft);
        RangeTreeMatcher.buildTree(tree, RangeTreeMatcher.rightChild(curTreeElement), ranges, median + 2, nRight);
    }

    private static int leftChild(int i) {
        return i * 2 + 2;
    }

    private static int rightChild(int i) {
        return i * 2 + 4;
    }

    RangeTreeMatcher(boolean invert, char[] tree) {
        super(invert);
        this.tree = tree;
    }

    @Specialization
    public boolean match(char c, boolean compactString) {
        assert (!compactString) : "this matcher should be avoided via ProfilingCharMatcher on compact strings";
        int i = 0;
        while (i < this.tree.length) {
            char lo = this.tree[i];
            char hi = this.tree[i + 1];
            if (lo <= c) {
                if (hi >= c) {
                    return this.result(true);
                }
                i = RangeTreeMatcher.rightChild(i);
                continue;
            }
            i = RangeTreeMatcher.leftChild(i);
        }
        return this.result(false);
    }

    @Override
    public int estimatedCost() {
        return 6 * (MathUtil.log2ceil(this.tree.length / 2) - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "tree " + this.modifiersToString() + "[" + CharSet.rangesToString(this.tree) + "]";
    }
}

