/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.nfa.ASTNodeSet;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.ASTDebugDumpVisitor;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.CompilationFinalBitSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class RegexAST
implements StateIndex<RegexASTNode>,
JsonConvertible {
    private final RegexSource source;
    private final RegexFlags flags;
    private final RegexOptions options;
    private final Counter.ThresholdCounter nodeCount = new Counter.ThresholdCounter(4000, "parse tree explosion");
    private final Counter.ThresholdCounter groupCount = new Counter.ThresholdCounter(127, "too many capture groups");
    private final RegexProperties properties = new RegexProperties();
    private RegexASTNode[] nodes;
    private Group root;
    private Group wrappedRoot;
    private Group[] captureGroups;
    private final List<LookBehindAssertion> lookBehinds = new ArrayList<LookBehindAssertion>();
    private final List<PositionAssertion> reachableCarets = new ArrayList<PositionAssertion>();
    private final List<PositionAssertion> reachableDollars = new ArrayList<PositionAssertion>();
    private ASTNodeSet<PositionAssertion> nfaAnchoredInitialStates;
    private ASTNodeSet<RegexASTNode> hardPrefixNodes;
    private final EconomicMap<GroupBoundaries, GroupBoundaries> groupBoundariesDeduplicationMap = EconomicMap.create();
    private int negativeLookaheads = 0;
    private int negativeLookbehinds = 0;
    private final EconomicMap<RegexASTNode, List<SourceSection>> sourceSections;

    public RegexAST(RegexSource source, RegexFlags flags, RegexOptions options) {
        this.source = source;
        this.flags = flags;
        this.options = options;
        this.sourceSections = options.isDumpAutomata() ? EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE) : null;
    }

    public RegexSource getSource() {
        return this.source;
    }

    public RegexFlags getFlags() {
        return this.flags;
    }

    public RegexOptions getOptions() {
        return this.options;
    }

    public Group getRoot() {
        return this.root;
    }

    public void setRoot(Group root) {
        this.root = root;
    }

    public Group getWrappedRoot() {
        return this.wrappedRoot;
    }

    public boolean rootIsWrapped() {
        return this.wrappedRoot != null && this.root != this.wrappedRoot;
    }

    public Counter.ThresholdCounter getNodeCount() {
        return this.nodeCount;
    }

    public int getNumberOfNodes() {
        return this.nodeCount.getCount();
    }

    public Counter.ThresholdCounter getGroupCount() {
        return this.groupCount;
    }

    public int getNumberOfCaptureGroups() {
        return this.groupCount.getCount();
    }

    public Group getGroupByBoundaryIndex(int index) {
        if (this.captureGroups == null) {
            this.captureGroups = new Group[this.getNumberOfCaptureGroups()];
            for (RegexASTNode n : this.nodes) {
                if (!(n instanceof Group) || !((Group)n).isCapturing()) continue;
                this.captureGroups[((Group)n).getGroupNumber()] = (Group)n;
            }
        }
        return this.captureGroups[index / 2];
    }

    public RegexProperties getProperties() {
        return this.properties;
    }

    public boolean isLiteralString() {
        Group r = this.getRoot();
        RegexProperties p = this.getProperties();
        return !p.hasAlternations() && !p.hasLookAroundAssertions() && !r.hasLoops() && (!r.startsWithCaret() && !r.endsWithDollar() || !this.getFlags().isMultiline()) && (!p.hasCharClasses() || p.charClassesCanBeMatchedWithMask());
    }

    @Override
    public int getNumberOfStates() {
        return this.nodes.length;
    }

    @Override
    public RegexASTNode getState(int id) {
        return this.nodes[id];
    }

    public void setIndex(RegexASTNode[] index) {
        this.nodes = index;
    }

    public int getWrappedPrefixLength() {
        if (this.rootIsWrapped()) {
            return this.wrappedRoot.getAlternatives().get(0).size() - 3;
        }
        return 0;
    }

    public RegexASTNode getEntryAfterPrefix() {
        if (this.rootIsWrapped()) {
            return this.wrappedRoot.getAlternatives().get(0).getTerms().get(this.getWrappedPrefixLength());
        }
        return this.wrappedRoot;
    }

    public List<LookBehindAssertion> getLookBehinds() {
        return this.lookBehinds;
    }

    public List<PositionAssertion> getReachableCarets() {
        return this.reachableCarets;
    }

    public List<PositionAssertion> getReachableDollars() {
        return this.reachableDollars;
    }

    public ASTNodeSet<PositionAssertion> getNfaAnchoredInitialStates() {
        return this.nfaAnchoredInitialStates;
    }

    public ASTNodeSet<RegexASTNode> getHardPrefixNodes() {
        return this.hardPrefixNodes;
    }

    public RegexASTRootNode createRootNode() {
        RegexASTRootNode node = new RegexASTRootNode();
        this.createEndPoint(node);
        return node;
    }

    public BackReference createBackReference(int groupNumber) {
        return this.register(new BackReference(groupNumber));
    }

    public CharacterClass createCharacterClass(CharSet matcherBuilder) {
        return this.register(new CharacterClass(matcherBuilder));
    }

    public Group createGroup() {
        return this.register(new Group());
    }

    public Group createCaptureGroup(int groupNumber) {
        return this.register(new Group(groupNumber));
    }

    public LookAheadAssertion createLookAheadAssertion(boolean negated) {
        LookAheadAssertion assertion = new LookAheadAssertion(negated);
        this.createEndPoint(assertion);
        return this.register(assertion);
    }

    public LookBehindAssertion createLookBehindAssertion(boolean negated) {
        LookBehindAssertion assertion = new LookBehindAssertion(negated);
        this.createEndPoint(assertion);
        return this.register(assertion);
    }

    public void createEndPoint(RegexASTSubtreeRootNode assertion) {
        this.nodeCount.inc();
        MatchFound end = new MatchFound();
        assertion.setMatchFound(end);
    }

    public PositionAssertion createPositionAssertion(PositionAssertion.Type type) {
        return this.register(new PositionAssertion(type));
    }

    public Sequence createSequence() {
        return this.register(new Sequence());
    }

    public BackReference register(BackReference backReference) {
        this.nodeCount.inc();
        this.properties.setBackReferences();
        return backReference;
    }

    public CharacterClass register(CharacterClass characterClass) {
        this.nodeCount.inc();
        if (!characterClass.getCharSet().matchesSingleChar()) {
            if (!characterClass.getCharSet().matches2CharsWith1BitDifference()) {
                this.properties.unsetCharClassesCanBeMatchedWithMask();
            }
            this.properties.setCharClasses();
        }
        return characterClass;
    }

    public Group register(Group group) {
        this.nodeCount.inc();
        if (group.isCapturing() && group.getGroupNumber() != 0) {
            this.properties.setCaptureGroups();
        }
        return group;
    }

    public LookAheadAssertion register(LookAheadAssertion lookAheadAssertion) {
        this.nodeCount.inc();
        this.properties.setLookAheadAssertions();
        if (lookAheadAssertion.isNegated()) {
            ++this.negativeLookaheads;
            this.properties.setNegativeLookAheadAssertions();
        }
        return lookAheadAssertion;
    }

    public LookBehindAssertion register(LookBehindAssertion lookBehindAssertion) {
        this.nodeCount.inc();
        this.properties.setLookBehindAssertions();
        if (lookBehindAssertion.isNegated()) {
            ++this.negativeLookbehinds;
            this.properties.setNegativeLookBehindAssertions();
        }
        this.lookBehinds.add(lookBehindAssertion);
        return lookBehindAssertion;
    }

    public void invertNegativeLookAround(LookAroundAssertion assertion) {
        assert (assertion.isNegated());
        assertion.setNegated(false);
        if (assertion instanceof LookAheadAssertion) {
            assert (this.negativeLookaheads > 0);
            if (--this.negativeLookaheads == 0) {
                this.properties.setNegativeLookAheadAssertions(false);
            }
        } else {
            assert (this.negativeLookbehinds > 0);
            if (--this.negativeLookbehinds == 0) {
                this.properties.setNegativeLookBehindAssertions(false);
            }
        }
    }

    public PositionAssertion register(PositionAssertion positionAssertion) {
        this.nodeCount.inc();
        switch (positionAssertion.type) {
            case CARET: {
                this.reachableCarets.add(positionAssertion);
                break;
            }
            case DOLLAR: {
                this.reachableDollars.add(positionAssertion);
            }
        }
        return positionAssertion;
    }

    public Sequence register(Sequence sequence) {
        this.nodeCount.inc();
        return sequence;
    }

    public void removeUnreachablePositionAssertions() {
        this.reachableCarets.removeIf(RegexASTNode::isDead);
        this.reachableDollars.removeIf(RegexASTNode::isDead);
    }

    public boolean isNFAInitialState(RegexASTNode node) {
        return node.getId() >= 1 && node.getId() <= this.getWrappedPrefixLength() * 2 + 2;
    }

    private void createNFAInitialStates() {
        if (this.nfaAnchoredInitialStates != null) {
            return;
        }
        this.hardPrefixNodes = new ASTNodeSet(this);
        this.nfaAnchoredInitialStates = new ASTNodeSet(this);
        int nextID = 1;
        MatchFound mf = new MatchFound();
        this.initNodeId(mf, nextID++);
        mf.setNext(this.getEntryAfterPrefix());
        PositionAssertion pos = new PositionAssertion(PositionAssertion.Type.CARET);
        this.initNodeId(pos, nextID++);
        this.nfaAnchoredInitialStates.add(pos);
        pos.setNext(this.getEntryAfterPrefix());
        for (int i = this.getWrappedPrefixLength() - 1; i >= 0; --i) {
            RegexASTNode prefixNode = this.getWrappedRoot().getAlternatives().get(0).getTerms().get(i);
            this.hardPrefixNodes.add(prefixNode);
            mf = new MatchFound();
            this.initNodeId(mf, nextID++);
            mf.setNext(prefixNode);
            pos = new PositionAssertion(PositionAssertion.Type.CARET);
            this.initNodeId(pos, nextID++);
            this.nfaAnchoredInitialStates.add(pos);
            pos.setNext(prefixNode);
        }
    }

    public MatchFound getNFAUnAnchoredInitialState(int prefixOffset) {
        this.createNFAInitialStates();
        assert (this.nodes[prefixOffset * 2 + 1] != null);
        return (MatchFound)this.nodes[prefixOffset * 2 + 1];
    }

    public PositionAssertion getNFAAnchoredInitialState(int prefixOffset) {
        this.createNFAInitialStates();
        assert (this.nodes[prefixOffset * 2 + 2] != null);
        return (PositionAssertion)this.nodes[prefixOffset * 2 + 2];
    }

    public void createPrefix() {
        if (this.root.startsWithCaret()) {
            this.wrappedRoot = this.root;
            return;
        }
        int prefixLength = 0;
        for (LookBehindAssertion lb : this.lookBehinds) {
            int minPath = lb.getMinPath();
            RegexASTSubtreeRootNode laParent = lb.getSubTreeParent();
            while (!(laParent instanceof RegexASTRootNode)) {
                if (laParent instanceof LookBehindAssertion) {
                    throw new UnsupportedRegexException("nested look-behind assertions");
                }
                minPath += laParent.getMinPath();
                laParent = laParent.getSubTreeParent();
            }
            prefixLength = Math.max(prefixLength, lb.getLength() - minPath);
        }
        if (prefixLength == 0) {
            this.wrappedRoot = this.root;
            return;
        }
        Group wrapRoot = this.createGroup();
        wrapRoot.setPrefix();
        Sequence wrapRootSeq = this.createSequence();
        wrapRoot.add(wrapRootSeq);
        wrapRootSeq.setPrefix();
        for (int i = 0; i < prefixLength; ++i) {
            wrapRootSeq.add(this.createPrefixAnyMatcher());
        }
        Group prevOpt = null;
        for (int i = 0; i < prefixLength; ++i) {
            Group opt = this.createGroup();
            opt.setPrefix();
            opt.add(this.createSequence());
            opt.add(this.createSequence());
            opt.getAlternatives().get(0).setPrefix();
            opt.getAlternatives().get(1).setPrefix();
            opt.getAlternatives().get(1).add(this.createPrefixAnyMatcher());
            if (prevOpt != null) {
                opt.getAlternatives().get(1).add(prevOpt);
            }
            prevOpt = opt;
        }
        this.root.getSubTreeParent().setGroup(wrapRoot);
        MatchFound matchFound = this.root.getSubTreeParent().getMatchFound();
        wrapRootSeq.add(prevOpt);
        wrapRootSeq.add(this.root);
        wrapRootSeq.add(matchFound);
        this.wrappedRoot = wrapRoot;
    }

    public GroupBoundaries createGroupBoundaries(CompilationFinalBitSet updateIndices, CompilationFinalBitSet clearIndices) {
        if (updateIndices.isEmpty() && clearIndices.isEmpty()) {
            return GroupBoundaries.getEmptyInstance();
        }
        GroupBoundaries lookup = new GroupBoundaries(updateIndices, clearIndices);
        if (this.groupBoundariesDeduplicationMap.containsKey((Object)lookup)) {
            return (GroupBoundaries)this.groupBoundariesDeduplicationMap.get((Object)lookup);
        }
        GroupBoundaries gb = new GroupBoundaries(updateIndices.copy(), clearIndices.copy());
        this.groupBoundariesDeduplicationMap.put((Object)gb, (Object)gb);
        return gb;
    }

    private CharacterClass createPrefixAnyMatcher() {
        CharacterClass anyMatcher = this.createCharacterClass(CharSet.getFull());
        anyMatcher.setPrefix();
        return anyMatcher;
    }

    private void addToIndex(RegexASTNode node) {
        assert (node.getId() >= 0);
        assert (node.getId() < this.nodes.length);
        assert (this.nodes[node.getId()] == null);
        this.nodes[node.getId()] = node;
    }

    private void initNodeId(RegexASTNode node, int id) {
        node.setId(id);
        this.addToIndex(node);
    }

    public List<SourceSection> getSourceSections(RegexASTNode node) {
        return this.options.isDumpAutomata() ? (List)this.sourceSections.get((Object)node) : null;
    }

    public void addSourceSection(RegexASTNode node, Token token) {
        if (this.options.isDumpAutomata() && token != null && token.getSourceSection() != null) {
            this.getOrCreateSourceSections(node).add(token.getSourceSection());
        }
    }

    public void addSourceSections(RegexASTNode node, Collection<SourceSection> src) {
        if (this.options.isDumpAutomata() && src != null) {
            this.getOrCreateSourceSections(node).addAll(src);
        }
    }

    private List<SourceSection> getOrCreateSourceSections(RegexASTNode node) {
        ArrayList sections = (ArrayList)this.sourceSections.get((Object)node);
        if (sections == null) {
            sections = new ArrayList();
            this.sourceSections.put((Object)node, sections);
        }
        return sections;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("source", this.source), Json.prop("root", this.root), Json.prop("debugAST", ASTDebugDumpVisitor.getDump(this.wrappedRoot)), Json.prop("wrappedRoot", this.wrappedRoot), Json.prop("reachableCarets", this.reachableCarets), Json.prop("startsWithCaret", this.root.startsWithCaret()), Json.prop("endsWithDollar", this.root.endsWithDollar()), Json.prop("reachableDollars", this.reachableDollars), Json.prop("properties", this.properties));
    }
}

