/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class CompilationFinalBitSet
implements Iterable<Integer> {
    private static final int BYTE_RANGE = 256;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private long[] words;

    private static int wordIndex(int i) {
        return i >> 6;
    }

    public static CompilationFinalBitSet valueOf(int ... values) {
        CompilationFinalBitSet bs = new CompilationFinalBitSet(256);
        for (int v : values) {
            bs.set(v);
        }
        return bs;
    }

    public CompilationFinalBitSet(int nbits) {
        this.words = new long[CompilationFinalBitSet.wordIndex(nbits - 1) + 1];
    }

    public CompilationFinalBitSet(long[] words) {
        this.words = words;
    }

    private CompilationFinalBitSet(CompilationFinalBitSet copy) {
        this.words = Arrays.copyOf(copy.words, copy.words.length);
    }

    public CompilationFinalBitSet copy() {
        return new CompilationFinalBitSet(this);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.words.length);
    }

    public boolean isEmpty() {
        for (long word : this.words) {
            if (word == 0L) continue;
            return false;
        }
        return true;
    }

    public int numberOfSetBits() {
        int ret = 0;
        for (long w : this.words) {
            ret += Long.bitCount(w);
        }
        return ret;
    }

    public boolean get(int b) {
        return CompilationFinalBitSet.wordIndex(b) < this.words.length && (this.words[CompilationFinalBitSet.wordIndex(b)] & 1L << b) != 0L;
    }

    private void ensureCapacity(int nWords) {
        if (this.words.length < nWords) {
            this.words = Arrays.copyOf(this.words, Math.max(2 * this.words.length, nWords));
        }
    }

    public void set(int b) {
        int wordIndex = CompilationFinalBitSet.wordIndex(b);
        this.ensureCapacity(wordIndex + 1);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << b;
    }

    public void setRange(int lo, int hi) {
        int wordIndexLo = CompilationFinalBitSet.wordIndex(lo);
        int wordIndexHi = CompilationFinalBitSet.wordIndex(hi);
        this.ensureCapacity(wordIndexHi + 1);
        long rangeLo = -1L << lo;
        long rangeHi = -1L >>> 63 - (hi & 0x3F);
        if (wordIndexLo == wordIndexHi) {
            int n = wordIndexLo;
            this.words[n] = this.words[n] | rangeLo & rangeHi;
            return;
        }
        int n = wordIndexLo;
        this.words[n] = this.words[n] | rangeLo;
        for (int i = wordIndexLo + 1; i < wordIndexHi; ++i) {
            this.words[i] = -1L;
        }
        int n2 = wordIndexHi;
        this.words[n2] = this.words[n2] | rangeHi;
    }

    public void clear() {
        Arrays.fill(this.words, 0L);
    }

    public void clear(int b) {
        int wordIndex = CompilationFinalBitSet.wordIndex(b);
        this.ensureCapacity(wordIndex + 1);
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << b ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void invert() {
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = this.words[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void intersect(CompilationFinalBitSet other) {
        int i;
        for (i = 0; i < Math.min(this.words.length, other.words.length); ++i) {
            int n = i;
            this.words[n] = this.words[n] & other.words[i];
        }
        while (i < this.words.length) {
            this.words[i] = 0L;
            ++i;
        }
    }

    public void subtract(CompilationFinalBitSet other) {
        for (int i = 0; i < Math.min(this.words.length, other.words.length); ++i) {
            int n = i;
            this.words[n] = this.words[n] & (other.words[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void union(CompilationFinalBitSet other) {
        this.ensureCapacity(other.words.length);
        for (int i = 0; i < Math.min(this.words.length, other.words.length); ++i) {
            int n = i;
            this.words[n] = this.words[n] | other.words[i];
        }
    }

    public boolean isDisjoint(CompilationFinalBitSet other) {
        for (int i = 0; i < Math.min(this.words.length, other.words.length); ++i) {
            if ((this.words[i] & other.words[i]) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean contains(CompilationFinalBitSet other) {
        for (int i = 0; i < other.words.length; ++i) {
            if (!(i >= this.words.length ? other.words[i] != 0L : (this.words[i] & other.words[i]) != other.words[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CompilationFinalBitSet && Arrays.equals(this.words, ((CompilationFinalBitSet)obj).words);
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.words.length;
        while (--i >= 0) {
            h ^= this.words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public PrimitiveIterator.OfInt iterator() {
        return new CompilationFinalBitSetIterator();
    }

    @CompilerDirectives.TruffleBoundary
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 277);
    }

    @CompilerDirectives.TruffleBoundary
    public IntStream stream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder("[ ");
        for (int b = 0; b < 256; ++b) {
            if (!this.get(b)) continue;
            sb.append(DebugUtil.charToString(b));
            int seq = 0;
            while (b + 1 < 256 && this.get(b + 1)) {
                ++b;
                ++seq;
            }
            if (seq > 0) {
                sb.append('-');
                sb.append(DebugUtil.charToString(b));
            }
            sb.append(" ");
        }
        sb.append(']');
        return sb.toString();
    }

    private final class CompilationFinalBitSetIterator
    implements PrimitiveIterator.OfInt {
        private int wordIndex = 0;
        private byte bitIndex = 0;
        private long curWord;
        private int last;

        private CompilationFinalBitSetIterator() {
            if (this.hasNext()) {
                this.curWord = CompilationFinalBitSet.this.words[0];
            }
            this.findNext();
        }

        private void findNext() {
            while (this.curWord == 0L) {
                ++this.wordIndex;
                this.bitIndex = 0;
                if (this.hasNext()) {
                    this.curWord = CompilationFinalBitSet.this.words[this.wordIndex];
                    continue;
                }
                return;
            }
            assert (this.hasNext());
            assert (this.curWord != 0L);
            int trailingZeros = Long.numberOfTrailingZeros(this.curWord);
            this.curWord >>>= trailingZeros;
            this.bitIndex = (byte)(this.bitIndex + trailingZeros);
        }

        @Override
        public boolean hasNext() {
            return this.wordIndex < CompilationFinalBitSet.this.words.length;
        }

        @Override
        public int nextInt() {
            assert (this.hasNext());
            this.last = this.wordIndex * 64 + this.bitIndex;
            this.curWord >>>= 1;
            this.bitIndex = (byte)(this.bitIndex + 1);
            this.findNext();
            return this.last;
        }

        @Override
        public void remove() {
            CompilationFinalBitSet.this.clear(this.last);
        }
    }
}

