/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

public class SpringHelper {
    private static final String BEAN_TAG = "bean";
    private static final String ANNOTATION_DRIVEN_TAG = "tx:annotation-driven";
    private static final String PROPERTY_TAG = "property";
    private static final String PROPS_TAG = "props";
    private static final String PROP_TAG = "prop";
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String REF_ATTR = "ref";
    private static final String KEY_ATTR = "key";
    private static final String EMF_ID = "entityManagerFactory";
    private static final String TXM_ID = "transactionManager";
    private static final String EMF_CLASS = "org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean";
    private static final String SIMPLE_EMF_CLASS = "org.springframework.orm.jpa.LocalEntityManagerFactoryBean";
    private static final String DATA_SOURCE_CLASS = "org.springframework.jdbc.datasource.DriverManagerDataSource";
    private static final String WEAVER_CLASS = "org.springframework.instrument.classloading.glassfish.GlassFishLoadTimeWeaver";
    private static final String JPA_ADAPTER_CLASS = "org.springframework.orm.jpa.vendor.TopLinkJpaVendorAdapter";
    private static final String JTA_TXM_CLASS = "org.springframework.transaction.jta.JtaTransactionManager";
    private static final String JPA_TXM_CLASS = "org.springframework.orm.jpa.JpaTransactionManager";
    private static final String DATABASE_PLATFORM_CLASS = "oracle.toplink.essentials.platform.database.DerbyPlatform";
    private static final String PERSISTENCE_ANNOTATION_POST_PROCESSOR_CLASS = "org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor";
    private static final String HIBERNATE_TRANSACTION_FACTORY_CLASS = "org.hibernate.transaction.JTATransactionFactory";
    private static final String HIBERANTE_TRANSACTION_LOOKUP_CLASS = "org.hibernate.transaction.SunONETransactionManagerLookup";
    private static final String PERSISTENCE_UNIT_NAME_PROP = "persistenceUnitName";
    private static final String DATA_SOURCE_PROP = "dataSource";
    private static final String DRIVER_CLASS_NAME_PROP = "driverClassName";
    private static final String URL_PROP = "url";
    private static final String USER_NAME_PROP = "username";
    private static final String PASSWORD_PROP = "password";
    private static final String LOAD_TIME_WEAVER_PROP = "loadTimeWeaver";
    private static final String JPA_VENDOR_ADAPTER_PROP = "jpaVendorAdapter";
    private static final String JPA_PROPERTIES_PROP = "jpaProperties";
    private static final String DATABASE_PLATFORM_PROP = "databasePlatform";
    private static final String SHOW_SQL_PROP = "showSql";
    private static final String GENERATE_DDL_PROP = "generateDdl";
    private static final String HIBERNATE_TRANSACTION_FACTORY_CLASS_PROP = "hibernate.transaction.factory_class";
    private static final String HIBERANTE_TRANSACTION_LOOKUP_CLASS_PROP = "hibernate.transaction.manager_lookup_class";
    private static final String HIBERNATE_PROVIDER = "org.hibernate.ejb.HibernatePersistence";
    private Project project;
    private PersistenceHelper.PersistenceUnit pu;
    private DOMHelper helper;
    private boolean generateDdl;

    public SpringHelper(Project project, PersistenceHelper.PersistenceUnit pu) {
        this.project = project;
        this.pu = pu;
        this.generateDdl = false;
    }

    public void configure() {
        FileObject fobj = this.getApplicationContextXml(this.project);
        if (fobj == null) {
            return;
        }
        this.helper = new DOMHelper(fobj);
        Element emfElement = this.helper.findElement(BEAN_TAG, ID_ATTR, EMF_ID);
        if (emfElement != null) {
            return;
        }
        boolean hasJTASupport = RestUtils.hasJTASupport(this.project);
        if (hasJTASupport) {
            emfElement = this.createBean(EMF_ID, EMF_CLASS);
            emfElement.appendChild(this.createProperty(PERSISTENCE_UNIT_NAME_PROP, this.pu.getName()));
            Element propElement = this.createJpaProperties();
            if (propElement != null) {
                emfElement.appendChild(propElement);
            }
        } else {
            emfElement = this.createBean(EMF_ID, SIMPLE_EMF_CLASS);
            emfElement.appendChild(this.createProperty(PERSISTENCE_UNIT_NAME_PROP, this.pu.getName()));
        }
        this.helper.appendChild(emfElement);
        if (hasJTASupport) {
            this.helper.appendChild(this.createBean(TXM_ID, JTA_TXM_CLASS));
        } else {
            Element txmElement = this.createBean(TXM_ID, JPA_TXM_CLASS);
            txmElement.appendChild(this.createProperty(EMF_ID, EMF_ID, true));
            this.helper.appendChild(txmElement);
        }
        this.helper.appendChild(this.createBean(null, PERSISTENCE_ANNOTATION_POST_PROCESSOR_CLASS));
        this.helper.appendChild(this.helper.createElement(ANNOTATION_DRIVEN_TAG));
        this.helper.save();
    }

    private FileObject getApplicationContextXml(Project project) {
        return MiscUtilities.getApplicationContextXml((Project)project);
    }

    private Element createBean(String id, String clazz) {
        Element beanElement = this.helper.createElement(BEAN_TAG);
        if (id != null) {
            beanElement.setAttribute(ID_ATTR, id);
        }
        if (clazz != null) {
            beanElement.setAttribute(CLASS_ATTR, clazz);
        }
        return beanElement;
    }

    private Element createProperty(String name, String value) {
        return this.createProperty(name, value, false);
    }

    private Element createProperty(String name, String value, boolean useRef) {
        Element propElement = this.helper.createElement(PROPERTY_TAG);
        propElement.setAttribute(NAME_ATTR, name);
        if (value != null) {
            if (useRef) {
                propElement.setAttribute(REF_ATTR, value);
            } else {
                propElement.setAttribute(VALUE_ATTR, value);
            }
        }
        return propElement;
    }

    private Element createDataSourceProperty() {
        Element propElement = this.createProperty(DATA_SOURCE_PROP, null);
        Element beanElement = this.createBean(null, DATA_SOURCE_CLASS);
        String url = "";
        String username = "";
        String password = "";
        String driverClass = "";
        Datasource ds = this.pu.getDatasource();
        if (ds != null) {
            url = ds.getUrl();
            username = ds.getUsername();
            password = ds.getPassword();
            driverClass = ds.getDriverClassName();
        }
        beanElement.appendChild(this.createProperty(DRIVER_CLASS_NAME_PROP, driverClass));
        beanElement.appendChild(this.createProperty(URL_PROP, url));
        beanElement.appendChild(this.createProperty(USER_NAME_PROP, username));
        beanElement.appendChild(this.createProperty(PASSWORD_PROP, password));
        propElement.appendChild(beanElement);
        return propElement;
    }

    private Element createWeaverProperty() {
        Element propElement = this.createProperty(LOAD_TIME_WEAVER_PROP, null);
        propElement.appendChild(this.createBean(null, WEAVER_CLASS));
        return propElement;
    }

    private Element createJpaVendorAdapterProperty() {
        Element propElement = this.createProperty(JPA_VENDOR_ADAPTER_PROP, null);
        Element beanElement = this.createBean(null, JPA_ADAPTER_CLASS);
        beanElement.appendChild(this.createProperty(DATABASE_PLATFORM_PROP, DATABASE_PLATFORM_CLASS));
        beanElement.appendChild(this.createProperty(SHOW_SQL_PROP, "true"));
        beanElement.appendChild(this.createProperty(GENERATE_DDL_PROP, String.valueOf(this.generateDdl)));
        propElement.appendChild(beanElement);
        return propElement;
    }

    private Element createJpaProperties() {
        Element propertyElement = null;
        if (HIBERNATE_PROVIDER.equals(this.pu.getProvider())) {
            propertyElement = this.createProperty(JPA_PROPERTIES_PROP, null);
            Element propsElement = this.helper.createElement(PROPS_TAG);
            Element propElement = this.helper.createElement(PROP_TAG, HIBERNATE_TRANSACTION_FACTORY_CLASS);
            propElement.setAttribute(KEY_ATTR, HIBERNATE_TRANSACTION_FACTORY_CLASS_PROP);
            propsElement.appendChild(propElement);
            propElement = this.helper.createElement(PROP_TAG, HIBERANTE_TRANSACTION_LOOKUP_CLASS);
            propElement.setAttribute(KEY_ATTR, HIBERANTE_TRANSACTION_LOOKUP_CLASS_PROP);
            propsElement.appendChild(propElement);
            propertyElement.appendChild(propsElement);
        }
        return propertyElement;
    }
}

