/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.GradleDistributionManager;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.execute.GradleDaemonExecutor;
import org.netbeans.modules.gradle.execute.GradleExecutor;
import org.netbeans.modules.gradle.execute.ProxyNonSelectableInputOutput;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.LifecycleManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public final class RunUtils {
    private static final Logger LOG = Logger.getLogger(RunUtils.class.getName());
    public static final String PROP_JDK_PLATFORM = "jdkPlatform";
    public static final String PROP_COMPILE_ON_SAVE = "compile.on.save";
    public static final String PROP_AUGMENTED_BUILD = "augmented.build";
    public static final String PROP_INCLUDE_OPEN_PROJECTS = "include.open.projects";
    public static final String PROP_DEFAULT_CLI = "gradle.cli";
    private static final Map<RunConfig, GradleExecutor> GRADLE_TASKS = new WeakHashMap<RunConfig, GradleExecutor>();

    private RunUtils() {
    }

    public static FileObject extractFileObjectfromLookup(Lookup lookup) {
        FileObject[] fos = RunUtils.extractFileObjectsfromLookup(lookup);
        return fos.length > 0 ? fos[0] : null;
    }

    public static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookupAll(DataObject.class)) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static ExecutorTask executeGradle(RunConfig config, String initialOutput) {
        LifecycleManager.getDefault().saveAll();
        GradleDaemonExecutor exec = new GradleDaemonExecutor(config);
        ExecutorTask task = RunUtils.executeGradleImpl(config.getTaskDisplayName(), exec, initialOutput);
        GRADLE_TASKS.put(config, exec);
        return task;
    }

    public static RunConfig createRunConfig(Project project, String action, String displayName, Set<RunConfig.ExecFlag> flags, String ... args) {
        GradleBaseProject gbp = GradleBaseProject.get(project);
        GradleCommandLine syscmd = GradleCommandLine.getDefaultCommandLine();
        GradleCommandLine prjcmd = RunUtils.getDefaultCommandLine(project);
        GradleCommandLine basecmd = syscmd;
        if (prjcmd != null) {
            basecmd = GradleCommandLine.combine(syscmd, prjcmd);
        }
        if (RunUtils.isIncludeOpenProjectsEnabled(project)) {
            GradleCommandLine include = RunUtils.getIncludedOpenProjects(project);
            basecmd = GradleCommandLine.combine(basecmd, include);
        }
        RunUtils.validateExclude(basecmd, gbp, "test");
        RunUtils.validateExclude(basecmd, gbp, "check");
        GradleCommandLine cmd = GradleCommandLine.combine(basecmd, new GradleCommandLine(args));
        RunConfig ret = new RunConfig(project, action, displayName, flags, cmd);
        return ret;
    }

    @Deprecated
    public static RunConfig createRunConfig(Project project, String action, String displayName, String[] args) {
        return RunUtils.createRunConfig(project, action, displayName, EnumSet.of(RunConfig.ExecFlag.REPEATABLE), args);
    }

    public static boolean cancelGradle(RunConfig config) {
        GradleExecutor exec = GRADLE_TASKS.get(config);
        return exec != null ? exec.cancel() : false;
    }

    private static ExecutorTask executeGradleImpl(String runtimeName, GradleExecutor exec, String initialOutput) {
        InputOutput io = exec.getInputOutput();
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, (InputOutput)new ProxyNonSelectableInputOutput(io));
        if (initialOutput != null) {
            try {
                if (IOColorPrint.isSupported((InputOutput)io)) {
                    IOColorPrint.print((InputOutput)io, (CharSequence)initialOutput, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
                } else {
                    io.getOut().println(initialOutput);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't write initial output: " + initialOutput, ex);
            }
        }
        exec.setTask(task);
        return task;
    }

    public static boolean isCompileOnSaveEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_COMPILE_ON_SAVE, false);
    }

    public static boolean isAugmentedBuildEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_AUGMENTED_BUILD, true);
    }

    public static boolean isIncludeOpenProjectsEnabled(Project project) {
        return RunUtils.isOptionEnabled(project, PROP_INCLUDE_OPEN_PROJECTS, false);
    }

    public static GradleCommandLine getDefaultCommandLine(Project project) {
        String args = NbGradleProject.getPreferences(project, true).get(PROP_DEFAULT_CLI, null);
        return args != null ? new GradleCommandLine((CharSequence)args) : null;
    }

    public static File evaluateGradleDistribution(Project project, boolean forceCompatibility) {
        File f;
        GradleDistributionManager.NbGradleVersion ngv;
        File ret = null;
        GradleSettings settings = GradleSettings.getDefault();
        GradleDistributionManager mgr = GradleDistributionManager.get(settings.getGradleUserHome());
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null && settings.isWrapperPreferred()) {
            ngv = mgr.evaluateGradleWrapperDistribution(gbp.getRootDir());
            if (ngv != null && forceCompatibility && !ngv.isCompatibleWithSystemJava()) {
                ngv = mgr.defaultToolingVersion();
            }
            if (ngv != null && ngv.isAvailable()) {
                ret = ngv.distributionDir();
            }
        }
        if (ret == null && settings.useCustomGradle() && !settings.getDistributionHome().isEmpty() && (f = FileUtil.normalizeFile((File)new File(settings.getDistributionHome()))).isDirectory()) {
            ret = f;
        }
        if (ret == null) {
            ngv = mgr.createVersion(settings.getGradleVersion());
            if (ngv != null && forceCompatibility && !ngv.isCompatibleWithSystemJava()) {
                ngv = mgr.defaultToolingVersion();
            }
            if (ngv != null && ngv.isAvailable()) {
                ret = ngv.distributionDir();
            }
        }
        return ret;
    }

    private static boolean isOptionEnabled(Project project, String option, boolean defaultValue) {
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            String value = gbp.getNetBeansProperty(option);
            if (value != null) {
                return Boolean.getBoolean(value);
            }
            return NbGradleProject.getPreferences(project, false).getBoolean(option, defaultValue);
        }
        return false;
    }

    private static void validateExclude(GradleCommandLine cmd, GradleBaseProject gbp, String task) {
        boolean exclude = gbp.getTaskNames().contains(task) || gbp.isRoot() && !gbp.getSubProjects().isEmpty();
        if (exclude &= cmd.getExcludedTasks().contains(task) && !cmd.getTasks().contains(task)) {
            cmd.addParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        } else {
            cmd.removeParameter(GradleCommandLine.Parameter.EXCLUDE_TASK, task);
        }
    }

    public static ReplaceTokenProvider simpleReplaceTokenProvider(final String token, final String value) {
        return new ReplaceTokenProvider(){

            @Override
            public Set<String> getSupportedTokens() {
                return Collections.singleton(token);
            }

            @Override
            public Map<String, String> createReplacements(String action, Lookup context) {
                return Collections.singletonMap(token, value);
            }
        };
    }

    public static Pair<String, JavaPlatform> getActivePlatform(String activePlatformId) {
        JavaPlatform[] installedPlatforms;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            JavaPlatform p = pm.getDefaultPlatform();
            return Pair.of(p.getProperties().get("platform.ant.name"), (Object)p);
        }
        for (JavaPlatform installedPlatform : installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null))) {
            String antName = (String)installedPlatform.getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return Pair.of((Object)activePlatformId, (Object)installedPlatform);
        }
        return Pair.of((Object)activePlatformId, null);
    }

    public static Pair<String, JavaPlatform> getActivePlatform(Project project) {
        Preferences prefs = NbGradleProject.getPreferences(project, false);
        String platformId = prefs.get(PROP_JDK_PLATFORM, null);
        if (platformId == null) {
            GradleBaseProject gbp = GradleBaseProject.get(project);
            platformId = gbp != null ? gbp.getNetBeansProperty(PROP_JDK_PLATFORM) : null;
        }
        return RunUtils.getActivePlatform(platformId);
    }

    static GradleCommandLine getIncludedOpenProjects(Project project) {
        GradleCommandLine ret = new GradleCommandLine(new String[0]);
        HashSet<File> openRoots = new HashSet<File>();
        for (Project openProject : OpenProjects.getDefault().getOpenProjects()) {
            GradleBaseProject gpb = GradleBaseProject.get(openProject);
            if (gpb == null) continue;
            openRoots.add(gpb.getRootDir());
        }
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            openRoots.remove(gbp.getRootDir());
            openRoots.removeAll(gbp.getIncludedBuilds().values());
            Path projectPath = gbp.getProjectDir().toPath();
            for (File openRoot : openRoots) {
                Path root = openRoot.toPath();
                String ib = root.toString();
                try {
                    Path rel = projectPath.relativize(root);
                    if (rel.getNameCount() < root.getNameCount()) {
                        ib = rel.toString();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ret.addParameter(GradleCommandLine.Parameter.INCLUDE_BUILD, ib);
            }
        }
        return ret;
    }
}

