/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CacheSourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private String FILE_PROTOCOL = "file";

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        if (!this.FILE_PROTOCOL.equals(binaryRoot.getProtocol())) {
            return null;
        }
        URL sourceURL = JavaIndex.getSourceRootForClassFolder(binaryRoot);
        R result = null;
        if (sourceURL != null) {
            SourceForBinaryQueryImplementation impl;
            Iterator iterator = Lookup.getDefault().lookupAll(SourceForBinaryQueryImplementation.class).iterator();
            while (iterator.hasNext() && ((impl = (SourceForBinaryQueryImplementation)iterator.next()) == this || (result = impl.findSourceRoots(sourceURL)) == null)) {
            }
            result = new R(sourceURL, result);
        }
        return result;
    }

    private static class R
    implements SourceForBinaryQuery.Result {
        private final FileObject sourceRoot;
        private final SourceForBinaryQuery.Result delegate;

        public R(URL sourceRootURL, SourceForBinaryQuery.Result delegate) {
            assert (sourceRootURL != null);
            this.sourceRoot = URLMapper.findFileObject((URL)sourceRootURL);
            this.delegate = delegate;
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public void addChangeListener(ChangeListener l) {
        }

        public FileObject[] getRoots() {
            FileObject[] result;
            if (this.delegate != null) {
                result = this.delegate.getRoots();
                if (result.length == 0) {
                    result = this.sourceRoot != null && GlobalPathRegistry.getDefault().getSourceRoots().contains(this.sourceRoot) ? new FileObject[]{this.sourceRoot} : new FileObject[]{};
                }
            } else if (this.sourceRoot == null) {
                result = new FileObject[]{};
            } else {
                FileObject[] aptRoots = R.resolveAptSourceCache(this.sourceRoot);
                if (aptRoots.length == 0) {
                    result = new FileObject[]{this.sourceRoot};
                } else {
                    result = new FileObject[1 + aptRoots.length];
                    result[0] = this.sourceRoot;
                    System.arraycopy(aptRoots, 0, result, 1, aptRoots.length);
                }
            }
            return result;
        }

        private static FileObject[] resolveAptSourceCache(FileObject sourceRoot) {
            try {
                FileObject[] fileObjectArray;
                AnnotationProcessingQuery.Result result = AnnotationProcessingQuery.getAnnotationProcessingOptions((FileObject)sourceRoot);
                URL annotationOutputURL = result.sourceOutputDirectory();
                FileObject userAnnotationOutput = annotationOutputURL == null ? null : URLMapper.findFileObject((URL)annotationOutputURL);
                FileObject cacheAnnoationOutput = FileUtil.toFileObject((File)JavaIndex.getAptFolder(sourceRoot.getURL(), false));
                if (userAnnotationOutput == null) {
                    if (cacheAnnoationOutput == null) {
                        fileObjectArray = new FileObject[]{};
                    } else {
                        FileObject[] fileObjectArray2 = new FileObject[1];
                        fileObjectArray = fileObjectArray2;
                        fileObjectArray2[0] = cacheAnnoationOutput;
                    }
                } else if (cacheAnnoationOutput == null) {
                    FileObject[] fileObjectArray3 = new FileObject[1];
                    fileObjectArray = fileObjectArray3;
                    fileObjectArray3[0] = userAnnotationOutput;
                } else {
                    FileObject[] fileObjectArray4 = new FileObject[2];
                    fileObjectArray4[0] = userAnnotationOutput;
                    fileObjectArray = fileObjectArray4;
                    fileObjectArray4[1] = cacheAnnoationOutput;
                }
                return fileObjectArray;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

