/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToPrimitiveNode.class)
public final class JSToPrimitiveNodeGen
extends JSToPrimitiveNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
    @Node.Child
    private JSObjectData jSObject_cache;
    @Node.Child
    private TruffleJavaObject0Data truffleJavaObject0_cache;
    @Node.Child
    private JSForeignToJSTypeNode truffleJavaObject1_toJSType_;

    private JSToPrimitiveNodeGen(JSToPrimitiveNode.Hint hint) {
        super(hint);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object execute(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return this.doInt(arg0Value_2);
        }
        if ((state & 2) != 0 && arg0Value instanceof LargeInteger) {
            LargeInteger arg0Value_3 = (LargeInteger)arg0Value;
            return this.doLargeInteger(arg0Value_3);
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_4 = (Long)arg0Value;
            return this.doLong(arg0Value_4);
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, arg0Value)) {
            double arg0Value_5 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, arg0Value);
            return this.doDouble(arg0Value_5);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_6 = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_6);
        }
        if ((state & 0x20) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x780000) >>> 19, arg0Value)) {
            CharSequence arg0Value_7 = JSTypesGen.asImplicitCharSequence((state & 0x780000) >>> 19, arg0Value);
            return this.doString(arg0Value_7);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_8 = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_8);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_9 = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_9);
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
            if ((state & 0x200) != 0 && JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
        }
        if ((state & 0xC00) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            JSObjectData s12_;
            arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 0x400) != 0 && JSGuards.isJSSIMD(arg0Value_)) {
                return this.doSIMD(arg0Value_);
            }
            if ((state & 0x800) != 0 && (s12_ = this.jSObject_cache) != null && JSGuards.isJSObject(arg0Value_)) {
                return this.doJSObject(arg0Value_, s12_.getToPrimitive_, s12_.isPrimitive_, s12_.ordinaryToPrimitive_, s12_.exoticToPrimProfile_, s12_.callExoticToPrim_);
            }
        }
        if ((state & 0x3000) != 0 && arg0Value instanceof TruffleObject) {
            arg0Value_ = (TruffleObject)arg0Value;
            if ((state & 0x1000) != 0) {
                TruffleJavaObject0Data s13_ = this.truffleJavaObject0_cache;
                while (s13_ != null) {
                    if (s13_.interop_.accepts((Object)arg0Value_) && JSGuards.isForeignObject((TruffleObject)arg0Value_)) {
                        return this.doTruffleJavaObject((TruffleObject)arg0Value_, s13_.interop_, this.javaScriptLanguageContextReference_, s13_.toJSType_);
                    }
                    s13_ = s13_.next_;
                }
            }
            if ((state & 0x2000) != 0 && JSGuards.isForeignObject((TruffleObject)arg0Value_)) {
                return this.truffleJavaObject1Boundary(state, (TruffleObject)arg0Value_);
            }
        }
        if ((state & 0x4000) != 0 && JSToPrimitiveNodeGen.fallbackGuard_(state, arg0Value)) {
            return this.doFallback(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object truffleJavaObject1Boundary(int state, TruffleObject arg0Value_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Object object = this.doTruffleJavaObject(arg0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), this.javaScriptLanguageContextReference_, this.truffleJavaObject1_toJSType_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.doInt(arg0Value_);
                return n;
            }
            if (arg0Value instanceof LargeInteger) {
                LargeInteger arg0Value_ = (LargeInteger)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                LargeInteger largeInteger = this.doLargeInteger(arg0Value_);
                return largeInteger;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Long l = this.doLong(arg0Value_);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_2 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 15;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Double d = this.doDouble(arg0Value_2);
                return d;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_2 = this.doBoolean(arg0Value_);
                return arg0Value_2;
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (charSequenceCast0 != 0) {
                CharSequence arg0Value_3 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                state |= charSequenceCast0 << 19;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                CharSequence charSequence = this.doString(arg0Value_3);
                return charSequence;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Symbol arg0Value_3 = this.doSymbol(arg0Value_);
                return arg0Value_3;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                BigInt arg0Value_3 = this.doBigInt(arg0Value_);
                return arg0Value_3;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_ = this.doNull(arg0Value);
                return arg0Value_;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_ = this.doUndefined(arg0Value);
                return arg0Value_;
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if (JSGuards.isJSSIMD(arg0Value_)) {
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject arg0Value_3 = this.doSIMD(arg0Value_);
                    return arg0Value_3;
                }
                if (JSGuards.isJSObject(arg0Value_)) {
                    JSObjectData s12_ = (JSObjectData)super.insert((Node)new JSObjectData());
                    s12_.getToPrimitive_ = s12_.insertAccessor(JSToPrimitiveNode.createGetToPrimitive(arg0Value_));
                    s12_.isPrimitive_ = s12_.insertAccessor(IsPrimitiveNode.create());
                    s12_.ordinaryToPrimitive_ = s12_.insertAccessor(this.createOrdinaryToPrimitive(arg0Value_));
                    s12_.exoticToPrimProfile_ = ConditionProfile.createBinaryProfile();
                    s12_.callExoticToPrim_ = s12_.insertAccessor(JSFunctionCallNode.createCall());
                    this.jSObject_cache = s12_;
                    this.state_ = state |= 0x800;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doJSObject(arg0Value_, s12_.getToPrimitive_, s12_.isPrimitive_, s12_.ordinaryToPrimitive_, s12_.exoticToPrimProfile_, s12_.callExoticToPrim_);
                    return object;
                }
            }
            if (arg0Value instanceof TruffleObject) {
                Object object;
                TruffleObject arg0Value_ = (TruffleObject)arg0Value;
                if (exclude == 0) {
                    int count13_ = 0;
                    TruffleJavaObject0Data s13_ = this.truffleJavaObject0_cache;
                    if ((state & 0x1000) != 0) {
                        while (!(s13_ == null || s13_.interop_.accepts((Object)arg0Value_) && JSGuards.isForeignObject(arg0Value_))) {
                            s13_ = s13_.next_;
                            ++count13_;
                        }
                    }
                    if (s13_ == null && JSGuards.isForeignObject(arg0Value_) && count13_ < 5) {
                        s13_ = (TruffleJavaObject0Data)super.insert((Node)new TruffleJavaObject0Data(this.truffleJavaObject0_cache));
                        s13_.interop_ = (InteropLibrary)s13_.insertAccessor(INTEROP_LIBRARY_.create((Object)arg0Value_));
                        TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                        if (javaScriptLanguageContextReference__ == null) {
                            this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                        }
                        s13_.toJSType_ = s13_.insertAccessor(JSForeignToJSTypeNode.create());
                        this.truffleJavaObject0_cache = s13_;
                        this.state_ = state |= 0x1000;
                    }
                    if (s13_ != null) {
                        lock.unlock();
                        hasLock = false;
                        object = this.doTruffleJavaObject(arg0Value_, s13_.interop_, this.javaScriptLanguageContextReference_, s13_.toJSType_);
                        return object;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (JSGuards.isForeignObject(arg0Value_)) {
                        TruffleLanguage.ContextReference javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                        if (javaScriptLanguageContextReference__ == null) {
                            this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                        }
                        this.truffleJavaObject1_toJSType_ = (JSForeignToJSTypeNode)super.insert((Node)JSForeignToJSTypeNode.create());
                        this.exclude_ = exclude |= 1;
                        this.truffleJavaObject0_cache = null;
                        state &= 0xFFFFEFFF;
                        this.state_ = state |= 0x2000;
                        lock.unlock();
                        hasLock = false;
                        object = this.doTruffleJavaObject(arg0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), (TruffleLanguage.ContextReference<JSRealm>)javaScriptLanguageContextReference__, this.truffleJavaObject1_toJSType_);
                        return object;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            this.state_ = state |= 0x4000;
            lock.unlock();
            hasLock = false;
            Object object = this.doFallback(arg0Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        TruffleJavaObject0Data s13_;
        int state = this.state_;
        if ((state & Short.MAX_VALUE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & Short.MAX_VALUE & (state & Short.MAX_VALUE) - 1) == 0 && ((s13_ = this.truffleJavaObject0_cache) == null || s13_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[16];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doSIMD";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            JSObjectData s12_ = this.jSObject_cache;
            if (s12_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s12_.getToPrimitive_, s12_.isPrimitive_, s12_.ordinaryToPrimitive_, s12_.exoticToPrimProfile_, s12_.callExoticToPrim_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObject";
        if ((state & 0x1000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            TruffleJavaObject0Data s13_ = this.truffleJavaObject0_cache;
            while (s13_ != null) {
                cached.add(Arrays.asList(new Object[]{s13_.interop_, this.javaScriptLanguageContextReference_, s13_.toJSType_}));
                s13_ = s13_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObject";
        if ((state & 0x2000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[]{INTEROP_LIBRARY_.getUncached(), this.javaScriptLanguageContextReference_, this.truffleJavaObject1_toJSType_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 0x4000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        DynamicObject arg0Value_;
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state & 0x10) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if (JSTypesGen.isImplicitCharSequence(arg0Value)) {
            return false;
        }
        if ((state & 0x40) == 0 && arg0Value instanceof Symbol) {
            return false;
        }
        if ((state & 0x80) == 0 && arg0Value instanceof BigInt) {
            return false;
        }
        if ((state & 0x100) == 0 && JSGuards.isJSNull(arg0Value)) {
            return false;
        }
        if ((state & 0x200) == 0 && JSGuards.isUndefined(arg0Value)) {
            return false;
        }
        if (JSTypes.isDynamicObject(arg0Value)) {
            arg0Value_ = (DynamicObject)arg0Value;
            if (JSGuards.isJSSIMD(arg0Value_)) {
                return false;
            }
            arg0Value_ = (DynamicObject)arg0Value;
            if (JSGuards.isJSObject(arg0Value_)) {
                return false;
            }
        }
        return !(arg0Value instanceof TruffleObject) || !JSGuards.isForeignObject((TruffleObject)(arg0Value_ = (TruffleObject)arg0Value));
    }

    public static JSToPrimitiveNode create(JSToPrimitiveNode.Hint hint) {
        return new JSToPrimitiveNodeGen(hint);
    }

    @GeneratedBy(value=JSToPrimitiveNode.class)
    private static final class TruffleJavaObject0Data
    extends Node {
        @Node.Child
        TruffleJavaObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        JSForeignToJSTypeNode toJSType_;

        TruffleJavaObject0Data(TruffleJavaObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSToPrimitiveNode.class)
    private static final class JSObjectData
    extends Node {
        @Node.Child
        PropertyNode getToPrimitive_;
        @Node.Child
        IsPrimitiveNode isPrimitive_;
        @Node.Child
        OrdinaryToPrimitiveNode ordinaryToPrimitive_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile exoticToPrimProfile_;
        @Node.Child
        JSFunctionCallNode callExoticToPrim_;

        JSObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

