/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryPlusNodeGen;

@NodeInfo(shortName="+")
public abstract class JSUnaryPlusNode
extends JSToNumberNode.JSToNumberUnaryNode {
    protected JSUnaryPlusNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JSUnaryPlusNode create(JavaScriptNode operand) {
        return JSUnaryPlusNodeGen.create(operand);
    }

    @Override
    @Specialization
    protected Object doDefault(Object value) {
        return super.doDefault(value);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("operator", ((Object)((Object)this)).getClass().getAnnotation(NodeInfo.class).shortName());
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSUnaryPlusNodeGen.create(JSUnaryPlusNode.cloneUninitialized(this.getOperand()));
    }

    @Override
    public String expressionToString() {
        return "(+" + this.getOperand().expressionToString() + ")";
    }
}

