/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.text.Normalizer;
import java.util.EnumSet;
import java.util.Locale;
import java.util.regex.Pattern;

public final class JSCollator
extends JSBuiltinObject
implements JSConstructorFactory.Default.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Collator";
    public static final String PROTOTYPE_NAME = "Collator.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final JSCollator INSTANCE;

    private JSCollator() {
    }

    public static boolean isJSCollator(Object obj) {
        return JSObject.isDynamicObject(obj) && JSCollator.isJSCollator((DynamicObject)obj);
    }

    public static boolean isJSCollator(DynamicObject obj) {
        return JSCollator.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject collatorPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, collatorPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, collatorPrototype, PROTOTYPE_NAME);
        JSObjectUtil.putConstantAccessorProperty(ctx, collatorPrototype, "compare", JSCollator.createCompareFunctionGetter(realm, ctx), Undefined.instance);
        JSObjectUtil.putDataProperty(ctx, collatorPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Object", JSAttributes.configurableNotEnumerableNotWritable());
        return collatorPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static void initializeCollator(JSContext ctx, InternalState state, String[] locales, String usage, String localeMatcher, Boolean optkn, String optkf, String sensitivity, Boolean ignorePunctuation) {
        Boolean kn = optkn;
        String kf = optkf;
        state.initializedCollator = true;
        state.usage = usage;
        String selectedTag = IntlUtil.selectedLocale(ctx, locales);
        Locale selectedLocale = selectedTag != null ? Locale.forLanguageTag(selectedTag) : ctx.getLocale();
        Locale strippedLocale = selectedLocale.stripExtensions();
        for (String ek : selectedLocale.getUnicodeLocaleKeys()) {
            String ktype;
            if (kn == null && ek.equals("kn") && ((ktype = selectedLocale.getUnicodeLocaleType(ek)).isEmpty() || ktype.equals("true"))) {
                kn = true;
            }
            if (kf != null || !ek.equals("kf") || (ktype = selectedLocale.getUnicodeLocaleType(ek)).isEmpty()) continue;
            kf = ktype;
        }
        if (kn != null) {
            state.numeric = kn;
        }
        if (kf != null) {
            state.caseFirst = kf;
        }
        if (sensitivity != null) {
            state.sensitivity = sensitivity;
        }
        state.ignorePunctuation = ignorePunctuation;
        state.locale = strippedLocale.toLanguageTag();
        state.collator = Collator.getInstance((Locale)Locale.forLanguageTag(state.locale));
        state.collator.setDecomposition(17);
        switch (state.sensitivity) {
            case "base": {
                state.collator.setStrength(0);
                break;
            }
            case "accent": {
                state.collator.setStrength(1);
                break;
            }
            case "case": 
            case "variant": {
                state.collator.setStrength(2);
            }
        }
        if (state.ignorePunctuation && state.collator instanceof RuleBasedCollator) {
            ((RuleBasedCollator)state.collator).setAlternateHandlingShifted(true);
        }
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getCollatorFactory(), state);
        assert (JSCollator.isJSCollator(result));
        return result;
    }

    public static Collator getCollatorProperty(DynamicObject obj) {
        return JSCollator.getInternalState(obj).collator;
    }

    @CompilerDirectives.TruffleBoundary
    public static int compare(DynamicObject collatorObj, String one, String two) {
        Collator collator = JSCollator.getCollatorProperty(collatorObj);
        return collator.compare(one, two);
    }

    @CompilerDirectives.TruffleBoundary
    public static int caseSensitiveCompare(DynamicObject collatorObj, String one, String two) {
        Collator collator = JSCollator.getCollatorProperty(collatorObj);
        String a = JSCollator.stripAccents(one);
        String b = JSCollator.stripAccents(two);
        return collator.compare(a, b);
    }

    private static String stripAccents(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder resultBuilder = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFD));
        JSCollator.stripLlAccents(resultBuilder);
        Pattern accentMatchingPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return accentMatchingPattern.matcher(resultBuilder).replaceAll("");
    }

    private static void stripLlAccents(StringBuilder s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\u0141') {
                s.setCharAt(i, 'L');
                continue;
            }
            if (s.charAt(i) != '\u0142') continue;
            s.setCharAt(i, 'l');
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject collatorObj) {
        InternalState state = JSCollator.getInternalState(collatorObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject collatorObj) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(collatorObj, JSCollator.isJSCollator(collatorObj));
    }

    private static CallTarget createGetCompareCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final ConditionProfile isAsyncProfile;
            private final ConditionProfile setProtoProfile;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> realmRef;
            {
                super(lang, sourceSection, frameDescriptor);
                this.isAsyncProfile = ConditionProfile.createBinaryProfile();
                this.setProtoProfile = ConditionProfile.createBinaryProfile();
            }

            public Object execute(VirtualFrame frame) {
                Object[] frameArgs = frame.getArguments();
                Object collatorObj = JSArguments.getThisObject(frameArgs);
                if (JSCollator.isJSCollator(collatorObj)) {
                    InternalState state = JSCollator.getInternalState((DynamicObject)collatorObj);
                    if (state == null || !state.initializedCollator) {
                        throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("compare");
                    }
                    if (state.boundCompareFunction == null) {
                        DynamicObject compareFn;
                        if (this.realmRef == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                        }
                        JSRealm realm = (JSRealm)this.realmRef.get();
                        if (state.sensitivity.equals("case")) {
                            JSFunctionData compareFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorCaseSensitiveCompare, c -> JSCollator.createCaseSensitiveCompareFunctionData(c));
                            compareFn = JSFunction.create(realm, compareFunctionData);
                        } else {
                            JSFunctionData compareFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorCompare, c -> JSCollator.createCompareFunctionData(c));
                            compareFn = JSFunction.create(realm, compareFunctionData);
                        }
                        DynamicObject boundFn = JSFunction.boundFunctionCreate(context, compareFn, collatorObj, new Object[0], JSObject.getPrototype(compareFn), true, this.isAsyncProfile, this.setProtoProfile);
                        state.boundCompareFunction = boundFn;
                    }
                    return state.boundCompareFunction;
                }
                throw Errors.createTypeErrorTypeXExpected(JSCollator.CLASS_NAME);
            }
        });
    }

    private static JSFunctionData createCompareFunctionData(JSContext context) {
        return JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private JSToStringNode toString1Node = JSToStringNode.create();
            @Node.Child
            private JSToStringNode toString2Node = JSToStringNode.create();

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)JSArguments.getThisObject(arguments);
                int argumentCount = JSArguments.getUserArgumentCount(arguments);
                String one = argumentCount > 0 ? this.toString1Node.executeString(JSArguments.getUserArgument(arguments, 0)) : "undefined";
                String two = argumentCount > 1 ? this.toString2Node.executeString(JSArguments.getUserArgument(arguments, 1)) : "undefined";
                return JSCollator.compare(thisObj, one, two);
            }
        }), 2, "compare");
    }

    private static JSFunctionData createCaseSensitiveCompareFunctionData(JSContext context) {
        return JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private JSToStringNode toString1Node = JSToStringNode.create();
            @Node.Child
            private JSToStringNode toString2Node = JSToStringNode.create();

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)JSArguments.getThisObject(arguments);
                int argumentCount = JSArguments.getUserArgumentCount(arguments);
                String one = argumentCount > 0 ? this.toString1Node.executeString(JSArguments.getUserArgument(arguments, 0)) : "undefined";
                String two = argumentCount > 1 ? this.toString2Node.executeString(JSArguments.getUserArgument(arguments, 1)) : "undefined";
                return JSCollator.caseSensitiveCompare(thisObj, one, two);
            }
        }), 2, "compare");
    }

    private static DynamicObject createCompareFunctionGetter(JSRealm realm, JSContext context) {
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorGetCompare, c -> {
            CallTarget ct = JSCollator.createGetCompareCallTarget(context);
            return JSFunctionData.create(context, ct, ct, 0, "get compare", false, false, false, true);
        });
        return JSFunction.create(realm, fd);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getCollatorPrototype();
    }

    static {
        INSTANCE = new JSCollator();
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
    }

    public static class InternalState {
        private boolean initializedCollator = false;
        private Collator collator;
        private DynamicObject boundCompareFunction = null;
        private String locale;
        private String usage = "sort";
        private String sensitivity = "variant";
        private String collation = "default";
        private boolean ignorePunctuation = false;
        private boolean numeric = false;
        private String caseFirst = "false";

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSUserObject.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "usage", this.usage, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "sensitivity", this.sensitivity, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "ignorePunctuation", this.ignorePunctuation, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "collation", this.collation, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "numeric", this.numeric, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "caseFirst", this.caseFirst, JSAttributes.getDefault());
            return result;
        }
    }
}

