/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.payara.common.CreateDomain;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraInstanceProvider;
import org.netbeans.modules.payara.common.PortCollection;
import org.netbeans.modules.payara.common.ServerDetails;
import org.netbeans.modules.payara.common.wizards.AddDomainLocationPanel;
import org.netbeans.modules.payara.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.payara.common.wizards.Retriever;
import org.netbeans.modules.payara.spi.RegisteredDerbyServer;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ServerWizardIterator
extends PortCollection
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddDomainLocationPanel locationPanel2 = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private final transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String domainsDir;
    private String domainName;
    private ServerDetails serverDetails;
    private final PayaraInstanceProvider instanceProvider;
    ServerDetails[] acceptedValues;
    ServerDetails[] downloadableValues;
    private String targetValue;
    private transient String[] steps = null;
    private String userName;
    private String password;
    private String installRoot;
    private String payaraRoot;
    private String hostName;
    private boolean isLocal;
    private boolean useDefaultPorts;
    private boolean defaultJavaSESupported;

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public ServerWizardIterator(ServerDetails[] possibleValues) {
        this.acceptedValues = possibleValues;
        this.downloadableValues = (ServerDetails[])Arrays.stream(possibleValues).filter(ServerDetails::isDownloadable).sorted(Collections.reverseOrder()).toArray(ServerDetails[]::new);
        this.instanceProvider = PayaraInstanceProvider.getProvider();
        this.hostName = "localhost";
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return "Payara Server AddInstanceIterator";
    }

    public static void showInformation(final String msg, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public Set instantiate() throws IOException {
        File f;
        HashSet<ServerInstance> result = new HashSet<ServerInstance>();
        File ir = new File(this.installRoot);
        this.ensureExecutable(ir);
        if (null != this.domainsDir) {
            this.handleLocalDomains(result, ir);
        } else {
            this.handleRemoteDomains(result, ir);
        }
        RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
        if (null != db && (f = new File(ir, "javadb")).exists() && f.isDirectory() && f.canRead()) {
            db.initialize(f.getAbsolutePath());
        }
        NbPreferences.forModule(this.getClass()).put("INSTALL_ROOT_KEY", this.installRoot);
        return result;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_Domain")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.locationPanel2 == null) {
            this.locationPanel2 = new AddDomainLocationPanel(this);
            this.locationPanel2.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.locationPanel2};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel result = this.getPanels()[this.index];
        JComponent component = (JComponent)result.getComponent();
        component.putClientProperty("WizardPanel_contentData", this.getSteps());
        component.putClientProperty("WizardPanel_contentSelectedIndex", this.getIndex());
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    protected final void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public boolean isUseDefaultPorts() {
        return this.useDefaultPorts;
    }

    public void setUseDefaultPorts(boolean useDefaultPorts) {
        this.useDefaultPorts = useDefaultPorts;
    }

    public void serDefaultJavaSESupported(boolean defaultJavaSESupported) {
        this.defaultJavaSESupported = defaultJavaSESupported;
    }

    public boolean isDefaultJavaSESupported() {
        return this.defaultJavaSESupported;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public String formatUri(String host, int port, String target, String domainsD, String domainN) {
        String domainInfo = DEFAULT_PASSWORD;
        if (null != domainsD && domainsD.length() > 0 && null != domainN && domainN.length() > 0) {
            domainInfo = File.pathSeparator + domainsD + File.separator + domainN;
        }
        if (null == target || DEFAULT_PASSWORD.equals(target.trim())) {
            return null != this.serverDetails ? "[" + this.payaraRoot + domainInfo + "]" + this.serverDetails.getUriFragment() + ":" + host + ":" + port : "[" + this.payaraRoot + domainInfo + "]null:" + host + ":" + port;
        }
        return null != this.serverDetails ? "[" + this.payaraRoot + domainInfo + "]" + this.serverDetails.getUriFragment() + ":" + host + ":" + port + ":" + target : "[" + this.payaraRoot + domainInfo + "]null:" + host + ":" + port + ":" + target;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    String getPayaraRoot() {
        return this.payaraRoot;
    }

    public void setPayaraRoot(String payaraRoot) {
        this.payaraRoot = payaraRoot;
    }

    boolean hasServer(String uri) {
        return this.instanceProvider.hasServer(uri);
    }

    ServerDetails isValidInstall(File installDir, File payaraDir, WizardDescriptor wizard) {
        String errMsg = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)FileUtil.normalizeFile((File)installDir).getPath());
        wizard.putProperty("WizardPanel_errorMessage", (Object)errMsg);
        File jar = ServerUtilities.getJarName(payaraDir.getAbsolutePath(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (jar == null || !jar.exists()) {
            return null;
        }
        File containerRef = new File(payaraDir, "config" + File.separator + "glassfish.container");
        if (!containerRef.exists()) {
            return null;
        }
        for (ServerDetails candidate : this.acceptedValues) {
            if (!candidate.isInstalledInDirectory(payaraDir)) continue;
            wizard.putProperty("WizardPanel_errorMessage", (Object)"   ");
            this.serverDetails = candidate;
            return candidate;
        }
        return null;
    }

    public void setRemoteDomain(String domainName) {
        this.domainsDir = null;
        this.domainName = domainName;
    }

    public void setDomainLocation(String absolutePath) {
        if (null == absolutePath) {
            this.domainsDir = null;
            this.domainName = null;
        } else {
            int dex = absolutePath.lastIndexOf(File.separator);
            this.domainsDir = absolutePath.substring(0, dex);
            this.domainName = absolutePath.substring(dex + 1);
        }
    }

    private void ensureExecutable(File installDir) {
        if (Utilities.isWindows()) {
            return;
        }
        if (!Utils.canWrite(installDir)) {
            return;
        }
        ArrayList<File> binList = new ArrayList<File>();
        for (String binPath : new String[]{"bin", "glassfish/bin", "javadb/bin", "javadb/frameworks/NetworkServer/bin", "javadb/frameworks/embedded/bin"}) {
            File dir = new File(installDir, binPath);
            if (!dir.exists()) continue;
            binList.add(dir);
        }
        if (binList.isEmpty()) {
            return;
        }
        File chmod = new File("/bin/chmod");
        if (!chmod.isFile()) {
            chmod = new File("/usr/bin/chmod");
        }
        if (chmod.isFile()) {
            try {
                for (File binDir : binList) {
                    String[] files;
                    ArrayList<String> argv = new ArrayList<String>();
                    argv.add(chmod.getAbsolutePath());
                    argv.add("u+rx");
                    for (String file : files = binDir.list()) {
                        if (file.indexOf(46) != -1 && !file.endsWith(".ksh")) continue;
                        argv.add(file);
                    }
                    ProcessBuilder pb = new ProcessBuilder(argv);
                    pb.directory(binDir);
                    Process process = pb.start();
                    int chmoded = process.waitFor();
                    if (chmoded == 0) continue;
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodFailed", argv, (Object)chmoded));
                }
            }
            catch (IOException | InterruptedException | MissingResourceException ex) {
                Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        } else {
            String message = NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodNotFound");
            StringBuilder builder = new StringBuilder(message.length() + 50 * binList.size());
            builder.append(message);
            for (File binDir : binList) {
                builder.append('\n');
                builder.append(binDir);
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)builder.toString(), 2));
        }
    }

    private void handleLocalDomains(Set<ServerInstance> result, File ir) {
        File domainDir = new File(this.domainsDir, this.domainName);
        String canonicalPath = null;
        try {
            canonicalPath = domainDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            Logger.getLogger("payara").log(Level.INFO, domainDir.getAbsolutePath(), ioe);
        }
        if (null != canonicalPath && !canonicalPath.equals(domainDir.getAbsolutePath())) {
            this.setDomainLocation(canonicalPath);
            domainDir = new File(this.domainsDir, this.domainName);
        }
        if (!domainDir.exists() && AddServerLocationPanel.canCreate(domainDir)) {
            HashMap<String, String> ip = new HashMap<String, String>();
            ip.put("installfolder", this.installRoot);
            ip.put("homefolder", this.payaraRoot);
            ip.put("displayName", (String)this.wizard.getProperty("ServInstWizard_displayName"));
            ip.put("domainsfolder", this.domainsDir);
            ip.put("domainname", this.domainName);
            ip.put("httpportnumber", Integer.toString(this.getHttpPort()));
            ip.put("adminPort", Integer.toString(this.getAdminPort()));
            this.userName = this.userName == null || this.userName.trim().isEmpty() ? DEFAULT_USERNAME : this.userName;
            this.password = this.password == null || this.password.trim().isEmpty() ? DEFAULT_PASSWORD : this.password;
            CreateDomain cd = new CreateDomain(this.userName, this.password, new File(this.payaraRoot), ip, this.instanceProvider, false, this.useDefaultPorts, "INSTALL_ROOT_KEY");
            int newHttpPort = cd.getHttpPort();
            int newAdminPort = cd.getAdminPort();
            cd.start();
            PayaraInstance instance = PayaraInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.payaraRoot, this.domainsDir, this.domainName, newHttpPort, newAdminPort, this.userName, this.password, this.targetValue, this.formatUri(this.hostName, newAdminPort, this.getTargetValue(), this.domainsDir, this.domainName), this.instanceProvider);
            result.add(instance.getCommonInstance());
        } else {
            PayaraInstance instance = PayaraInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.payaraRoot, this.domainsDir, this.domainName, this.getHttpPort(), this.getAdminPort(), this.userName, this.password, this.targetValue, this.formatUri(this.hostName, this.getAdminPort(), this.getTargetValue(), this.domainsDir, this.domainName), this.instanceProvider);
            result.add(instance.getCommonInstance());
        }
    }

    private void handleRemoteDomains(Set<ServerInstance> result, File ir) {
        String hn = this.getHostName();
        if ("localhost".equals(hn)) {
            hn = "127.0.0.1";
        }
        PayaraInstance instance = PayaraInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.payaraRoot, null, this.domainName, this.getHttpPort(), this.getAdminPort(), this.userName, this.password, this.targetValue, this.formatUri(hn, this.getAdminPort(), this.getTargetValue(), null, this.domainName), this.instanceProvider);
        result.add(instance.getCommonInstance());
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }
}

