/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.util.HelpCtx;

public final class StopAction
extends ProfilingAwareAction {
    private static final int[] enabledStates = new int[]{8, 4, 2};
    private boolean taskPosted = false;
    private int mode = -1;

    private StopAction() {
        this.updateAction();
    }

    public static StopAction getInstance() {
        return Singleton.INSTANCE;
    }

    public void performAction() {
        if (this.taskPosted) {
            return;
        }
        Runnable task = null;
        if (this.mode == 0) {
            Boolean ret = ProfilerDialogs.displayCancellableConfirmationDNSA((String)Bundle.StopAction_DoYouWantToTerminateMsg(), (String)Bundle.StopAction_DoYouWantToTerminateCap(), null, (String)StopAction.class.getName(), (boolean)false);
            if (Boolean.TRUE.equals(ret)) {
                task = new Runnable(){

                    @Override
                    public void run() {
                        Profiler.getDefault().stopApp();
                        StopAction.this.taskPosted = false;
                    }
                };
            } else if (Boolean.FALSE.equals(ret)) {
                task = new Runnable(){

                    @Override
                    public void run() {
                        Profiler.getDefault().detachFromApp();
                        StopAction.this.taskPosted = false;
                    }
                };
            }
        } else {
            task = new Runnable(){

                @Override
                public void run() {
                    Profiler.getDefault().stopApp();
                    StopAction.this.taskPosted = false;
                }
            };
        }
        if (task != null) {
            this.taskPosted = true;
            this.updateAction();
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)task);
        }
    }

    @Override
    protected int[] enabledStates() {
        return enabledStates;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StopAction.class);
    }

    public String getName() {
        return this.mode == 1 ? Bundle.LBL_StopAction() : Bundle.LBL_DetachAction();
    }

    @Override
    protected void updateAction() {
        super.updateAction();
        this.mode = Profiler.getDefault().getProfilingMode();
        if (this.mode == 1) {
            this.setToStop();
        } else if (this.mode == 0) {
            this.setToDetach();
        }
        this.firePropertyChange("SmallIcon", null, null);
    }

    @Override
    protected boolean shouldBeEnabled(Profiler profiler) {
        return super.shouldBeEnabled(profiler) && (profiler.getProfilingState() == 1 || profiler.getServerState() == 0);
    }

    private void setToDetach() {
        this.putValue("Name", Bundle.LBL_DetachAction());
        this.putValue("ShortDescription", Bundle.HINT_DetachAction());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Detach"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Detach"));
        this.setIcon(Icons.getIcon((String)"GeneralIcons.Detach"));
    }

    private void setToStop() {
        this.putValue("Name", Bundle.LBL_StopAction());
        this.putValue("ShortDescription", Bundle.HINT_StopAction());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Stop"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Stop"));
        this.setIcon(Icons.getIcon((String)"GeneralIcons.Stop"));
    }

    private static final class Singleton {
        private static final StopAction INSTANCE = new StopAction();

        private Singleton() {
        }
    }
}

