/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.net.URI;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.spi.debugger.ui.DebuggingView;

public final class TruffleDVFrame
implements DebuggingView.DVFrame {
    private final DebuggingView.DVThread thread;
    private final TruffleStackFrame truffleFrame;

    TruffleDVFrame(DebuggingView.DVThread thread, TruffleStackFrame truffleFrame) {
        this.thread = thread;
        this.truffleFrame = truffleFrame;
    }

    TruffleStackFrame getTruffleFrame() {
        return this.truffleFrame;
    }

    public String getName() {
        return this.truffleFrame.getMethodName();
    }

    public DebuggingView.DVThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(this.truffleFrame.getThread());
        if (currentPCInfo != null) {
            currentPCInfo.setSelectedStackFrame(this.truffleFrame);
        }
    }

    public URI getSourceURI() {
        return this.truffleFrame.getSourcePosition().getSource().getURI();
    }

    public int getLine() {
        return this.truffleFrame.getSourcePosition().getStartLine();
    }

    public int getColumn() {
        return this.truffleFrame.getSourcePosition().getStartColumn();
    }
}

