/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.parsers.SAXParserFactory;
import nu.validator.io.NcrEscapingWindows1252OutputStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlSerializer
implements ContentHandler {
    public static final int NO_DOCTYPE = 0;
    public static final int DOCTYPE_HTML401_TRANSITIONAL = 1;
    public static final int DOCTYPE_HTML401_STRICT = 2;
    public static final int DOCTYPE_HTML5 = 3;
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final String[] emptyElements = new String[]{"area", "base", "basefont", "br", "col", "command", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    private static final String[] booleanAttributes = new String[]{"active", "async", "autofocus", "autosubmit", "checked", "compact", "declare", "default", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "required", "selected"};
    protected Writer writer;
    private int doctype;
    private String encoding;
    private boolean emitMeta;

    public HtmlSerializer(OutputStream out) {
        this(out, 2, false, "UTF-8");
    }

    public HtmlSerializer(OutputStream out, int doctype, boolean emitMeta) {
        this(out, doctype, emitMeta, "UTF-8");
    }

    public HtmlSerializer(OutputStream out, int doctype, boolean emitMeta, String enc) {
        this.emitMeta = emitMeta;
        if (doctype < 0 || doctype > 3) {
            throw new IllegalArgumentException("Bad doctype constant.");
        }
        this.doctype = doctype;
        if ("UTF-8".equalsIgnoreCase(enc)) {
            try {
                this.encoding = "UTF-8";
                this.writer = new OutputStreamWriter(out, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("UTF-8 not supported", uee);
            }
        } else if ("Windows-1252".equalsIgnoreCase(enc)) {
            this.encoding = "Windows-1252";
            this.writer = new NcrEscapingWindows1252OutputStreamWriter(out);
        } else {
            throw new IllegalArgumentException("Encoding must be UTF-8 or Windows-1252.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            block7: for (int j = 0; j < length; ++j) {
                char c = ch[start + j];
                switch (c) {
                    case '<': {
                        this.writer.write("&lt;");
                        continue block7;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        continue block7;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        continue block7;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw (SAXException)new SAXException(ioe).initCause(ioe);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.close();
        }
        catch (IOException ioe) {
            throw (SAXException)new SAXException(ioe).initCause(ioe);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (XHTML_NS.equals(namespaceURI) && Arrays.binarySearch(emptyElements, localName) < 0) {
                this.writer.write("</");
                this.writer.write(localName);
                this.writer.write(62);
            }
        }
        catch (IOException ioe) {
            throw (SAXException)new SAXException(ioe).initCause(ioe);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            switch (this.doctype) {
                case 0: {
                    return;
                }
                case 3: {
                    this.writer.write("<!DOCTYPE html>\n");
                    return;
                }
                case 2: {
                    this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n");
                    return;
                }
                case 1: {
                    this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                    return;
                }
            }
        }
        catch (IOException ioe) {
            throw (SAXException)new SAXException(ioe).initCause(ioe);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (XHTML_NS.equals(namespaceURI)) {
                if ("meta".equals(localName) && (atts.getIndex("", "http-equiv") != -1 || atts.getIndex("", "httpequiv") != -1)) {
                    return;
                }
                this.writer.write(60);
                this.writer.write(localName);
                int length = atts.getLength();
                boolean langPrinted = false;
                for (int i = 0; i < length; ++i) {
                    String ns = atts.getURI(i);
                    String name = null;
                    if ("".equals(ns)) {
                        name = atts.getLocalName(i);
                    } else if ("http://www.w3.org/XML/1998/namespace".equals(ns) && "lang".equals(atts.getLocalName(i))) {
                        name = "lang";
                    }
                    if (name == null || langPrinted && "lang".equals(name)) continue;
                    this.writer.write(32);
                    this.writer.write(name);
                    if ("lang".equals(name)) {
                        langPrinted = true;
                    }
                    if (Arrays.binarySearch(booleanAttributes, name) >= 0) continue;
                    this.writer.write("=\"");
                    String value = atts.getValue(i);
                    block9: for (int j = 0; j < value.length(); ++j) {
                        char c = value.charAt(j);
                        switch (c) {
                            case '<': {
                                this.writer.write("&lt;");
                                continue block9;
                            }
                            case '>': {
                                this.writer.write("&gt;");
                                continue block9;
                            }
                            case '&': {
                                this.writer.write("&amp;");
                                continue block9;
                            }
                            case '\"': {
                                this.writer.write("&quot;");
                                continue block9;
                            }
                            default: {
                                this.writer.write(c);
                            }
                        }
                    }
                    this.writer.write(34);
                }
                this.writer.write(62);
                if (this.emitMeta && "head".equals(localName)) {
                    this.writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    this.writer.write(this.encoding);
                    this.writer.write("\">");
                }
            }
        }
        catch (IOException ioe) {
            throw (SAXException)new SAXException(ioe).initCause(ioe);
        }
    }

    public static void main(String[] args) {
        try {
            SAXParserFactory fac = SAXParserFactory.newInstance();
            fac.setNamespaceAware(true);
            fac.setValidating(false);
            XMLReader parser = fac.newSAXParser().getXMLReader();
            parser.setContentHandler(new HtmlSerializer(System.out));
            parser.parse(args[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endPrefixMapping(String str) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    @Override
    public void processingInstruction(String str, String str1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String str) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String str, String str1) throws SAXException {
    }
}

