/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Bundle {
    private Properties resources = new Properties();

    public void load(InputStream stream) throws IOException {
        this.resources.load(stream);
    }

    public void loadFromFile(String fileName) throws IOException, FileNotFoundException {
        this.load(new FileInputStream(fileName));
    }

    public void loadFromJar(String fileName, String entryName) throws IOException, FileNotFoundException {
        JarFile jFile = new JarFile(fileName);
        this.load(jFile.getInputStream(jFile.getEntry(entryName)));
    }

    public void loadFromZip(String fileName, String entryName) throws IOException, FileNotFoundException, ZipException {
        ZipFile zFile = new ZipFile(fileName);
        this.load(zFile.getInputStream(zFile.getEntry(entryName)));
    }

    public void print(PrintWriter writer) {
        Enumeration<Object> keys = this.resources.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            writer.println(key + "=" + this.getResource(key));
        }
    }

    public void print(PrintStream stream) {
        this.print(new PrintWriter(stream));
    }

    public String getResource(String key) {
        return this.resources.getProperty(key);
    }
}

