/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.Bundle;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        HashSet<Project> projects = new HashSet<Project>();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (project.getClass().getName().equals("org.netbeans.modules.project.ui.LazyProject")) continue;
            projects.add(project);
        }
        return projects.toArray(new Project[0]);
    }

    public static boolean hasAction(Project project, String actionName) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return false;
        }
        String[] actions = ap.getSupportedActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actionName.equals(actions[i])) continue;
            return true;
        }
        return false;
    }

    public static FileObject getOrCreateBuildFolder(Project project, String buildDirProp) {
        FileObject buildDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)buildDirProp));
        if (buildDir == null) {
            try {
                buildDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)buildDirProp);
            }
            catch (IOException e) {
                Bundle.ProjectUtilities_FailedCreateOutputFolderMsg(e.getMessage());
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        return buildDir;
    }

    public static Properties getProjectProperties(Project project) {
        final Properties props = new Properties();
        final FileObject propFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (propFile != null) {
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    InputStream in = null;
                    try {
                        in = propFile.getInputStream();
                        props.load(in);
                    }
                    catch (IOException ex) {
                        LOGGER.finest("Could not load properties file: " + propFile.getPath());
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project) {
        FileObject buildFile = project.getProjectDirectory().getFileObject("build.xml");
        RandomAccessFile file = null;
        byte[] data = null;
        try {
            file = new RandomAccessFile(FileUtil.toFile((FileObject)buildFile), "r");
            data = new byte[(int)buildFile.getSize()];
            file.readFully(data);
        }
        catch (FileNotFoundException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        catch (IOException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
            }
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return null;
        }
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] projectPackagesDescr) {
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[projectPackagesDescr[1].length];
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            ret[i] = "".equals(projectPackagesDescr[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(projectPackagesDescr[1][i] + ".**", "", "");
        }
        return ret;
    }

    public static Project getProjectForBuildScript(String fileName) {
        FileObject projectFO = FileUtil.toFileObject((File)new File(fileName));
        while (projectFO != null) {
            try {
                if (projectFO.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Trying: " + projectFO);
                    }
                    Project p = ProjectManager.getDefault().findProject(projectFO);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Got: " + (p != null ? ProjectUtilities.getProjectName((Lookup.Provider)p) : null));
                    }
                    if (p != null) {
                        return p;
                    }
                }
                projectFO = projectFO.getParent();
            }
            catch (IOException e) {
                ProfilerLogger.severe((String)("Got: IOException : " + e.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Lookup.Provider project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return new ImageIcon();
        }
        return info.getIcon();
    }

    public static String getProjectName(Lookup.Provider project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        return info != null ? info.getDisplayName() : "UNKNOWN";
    }

    public static FileObject[] getSourceRoots(Lookup.Provider project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Lookup.Provider project, boolean traverse) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        HashSet<Lookup.Provider> projects = new HashSet<Lookup.Provider>();
        projects.add(project);
        ProjectUtilities.getSourceRoots(project, traverse, projects, set);
        return set.toArray(new FileObject[0]);
    }

    public static void fetchSubprojects(Project project, Set<Project> projects) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            for (Project p : spp.getSubprojects()) {
                if (!projects.add(p)) continue;
                ProjectUtilities.fetchSubprojects(p, projects);
            }
        }
    }

    public static String computeProjectOnlyInstrumentationFilter(Project project, boolean useSubprojects, String[][] projectPackagesDescr) {
        if (!useSubprojects) {
            ProjectUtilities.computeProjectPackages(project, false, projectPackagesDescr);
            StringBuilder projectPackages = new StringBuilder();
            for (int i = 0; i < projectPackagesDescr[0].length; ++i) {
                projectPackages.append("".equals(projectPackagesDescr[0][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[0][i] + ". ");
            }
            return projectPackages.toString().trim();
        }
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        StringBuilder projectPackages = new StringBuilder();
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            projectPackages.append("".equals(projectPackagesDescr[1][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : projectPackagesDescr[1][i] + ". ");
        }
        return projectPackages.toString().trim();
    }

    public static String getDefaultPackageClassNames(Project project) {
        Collection<String> classNames = ProjectUtilities.getDefaultPackageClassNamesSet(project);
        StringBuilder classNamesBuf = new StringBuilder();
        for (String className : classNames) {
            classNamesBuf.append(className).append(" ");
        }
        return classNamesBuf.toString();
    }

    public static JavaSource getSources(Project project) {
        if (project == null) {
            return ProjectUtilities.getSources((FileObject[])null);
        }
        return ProjectUtilities.getSources(ProjectUtilities.getSourceRoots((Lookup.Provider)project, true));
    }

    public static void computeProjectPackages(Project project, boolean subprojects, String[][] storage) {
        if (storage == null || storage.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (storage[0] == null || storage[0].length == 0) {
            ArrayList<String> packages1 = new ArrayList<String>();
            for (FileObject root : ProjectUtilities.getSourceRoots((Lookup.Provider)project, false)) {
                ProjectUtilities.addSubpackages(packages1, "", root);
            }
            storage[0] = packages1.toArray(new String[0]);
        }
        if (subprojects && (storage[1] == null || storage[1].length == 0)) {
            FileObject[] srcRoots2 = ProjectUtilities.getSourceRoots((Lookup.Provider)project, true);
            ArrayList<String> packages2 = new ArrayList<String>();
            for (FileObject root : srcRoots2) {
                ProjectUtilities.addSubpackages(packages2, "", root);
            }
            storage[1] = packages2.toArray(new String[0]);
        }
    }

    public static FileObject findTestForFile(FileObject selectedFO) {
        if (selectedFO == null || !selectedFO.getExt().equalsIgnoreCase("java")) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)selectedFO, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        FileObject packageRoot = cp.findOwnerRoot(selectedFO);
        if (packageRoot == null) {
            return null;
        }
        URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)packageRoot);
        FileObject fileToOpen = null;
        for (int j = 0; j < testRoots.length; ++j) {
            fileToOpen = ProjectUtilities.findUnitTestInTestRoot(cp, selectedFO, testRoots[j]);
            if (fileToOpen == null) continue;
            return fileToOpen;
        }
        return null;
    }

    public static void invokeAction(Project project, String s) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        ap.invokeAction(s, Lookup.getDefault());
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        return sourceGroups.length > 0;
    }

    private static void getSourceRoots(Lookup.Provider project, boolean traverse, Set<Lookup.Provider> projects, Set<FileObject> roots) {
        if (project instanceof Project) {
            SubprojectProvider spp;
            Sources sources = ProjectUtils.getSources((Project)((Project)project));
            for (SourceGroup sg : sources.getSourceGroups("java")) {
                roots.add(sg.getRootFolder());
            }
            if (traverse && (spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
                for (Project p : spp.getSubprojects()) {
                    if (!projects.add((Lookup.Provider)p)) continue;
                    ProjectUtilities.getSourceRoots((Lookup.Provider)p, traverse, projects, roots);
                }
            }
        }
    }

    private static void addSubpackages(Collection<String> packages, String prefix, FileObject packageFO) {
        FileObject child;
        int i;
        if (!packageFO.isFolder()) {
            return;
        }
        FileObject[] children = packageFO.getChildren();
        if (!packages.contains(prefix)) {
            for (i = 0; i < children.length; ++i) {
                child = children[i];
                if (!child.getExt().equals("java")) continue;
                packages.add(prefix);
                break;
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!child.isFolder()) continue;
            if ("".equals(prefix)) {
                ProjectUtilities.addSubpackages(packages, child.getName(), child);
                continue;
            }
            ProjectUtilities.addSubpackages(packages, prefix + "." + child.getName(), child);
        }
    }

    public static boolean hasSubprojects(Project project) {
        if (project == null) {
            return false;
        }
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp == null) {
            return false;
        }
        return spp.getSubprojects().size() > 0;
    }

    private static FileObject findUnitTestInTestRoot(ClassPath cp, FileObject selectedFO, URL testRoot) {
        ClassPath testClassPath = null;
        if (testRoot == null) {
            testClassPath = cp;
        } else {
            try {
                ArrayList<PathResourceImplementation> cpItems = new ArrayList<PathResourceImplementation>();
                cpItems.add(ClassPathSupport.createResource((URL)testRoot));
                testClassPath = ClassPathSupport.createClassPath(cpItems);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                testClassPath = cp;
            }
        }
        String testName = ProjectUtilities.getTestName(cp, selectedFO);
        return testClassPath.findResource(testName + ".java");
    }

    private static String getTestName(ClassPath cp, FileObject selectedFO) {
        String resource = cp.getResourceName(selectedFO, '/', false);
        String testName = null;
        testName = selectedFO.isFolder() ? ProjectUtilities.convertPackage2SuiteName(resource) : ProjectUtilities.convertClass2TestName(resource);
        return testName;
    }

    private static String convertClass2TestName(String classFileName) {
        if (classFileName == null || "".equals(classFileName)) {
            return "";
        }
        int index = classFileName.lastIndexOf(47);
        String pkg = index > -1 ? classFileName.substring(0, index) : "";
        String clazz = index > -1 ? classFileName.substring(index + 1) : classFileName;
        clazz = clazz.substring(0, 1).toUpperCase() + clazz.substring(1);
        if (pkg.length() > 0) {
            pkg = pkg + "/";
        }
        return pkg + clazz + "Test";
    }

    private static String convertPackage2SuiteName(String packageFileName) {
        if (packageFileName == null || "".equals(packageFileName)) {
            return "";
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + pkg + "Test";
    }

    private static Collection<String> getDefaultPackageClassNamesSet(Project project) {
        ArrayList<String> classNames = new ArrayList<String>();
        JavaSource js = ProjectUtilities.getSources(project);
        Set<ElementHandle<TypeElement>> types = ProjectUtilities.getProjectTypes(project, js);
        for (ElementHandle<TypeElement> typeHandle : types) {
            int firstPkgSeparIndex = typeHandle.getQualifiedName().indexOf(46);
            if (firstPkgSeparIndex > 0) continue;
            classNames.add(typeHandle.getQualifiedName().substring(firstPkgSeparIndex + 1));
        }
        return classNames;
    }

    private static JavaSource getSources(FileObject[] roots) {
        ClassPath compilePath;
        ClassPath bootPath;
        ClassPath srcPath;
        if (roots == null || roots.length == 0) {
            srcPath = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/source").toArray(new ClassPath[0]));
            bootPath = JavaPlatform.getDefault().getBootstrapLibraries();
            compilePath = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/compile").toArray(new ClassPath[0]));
        } else {
            srcPath = ClassPathSupport.createClassPath((FileObject[])roots);
            bootPath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot");
            compilePath = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile");
        }
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)srcPath);
        return JavaSource.create((ClasspathInfo)cpInfo, Collections.emptyList());
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(FileObject[] roots, JavaSource js) {
        HashSet<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();
        scope.add(ClassIndex.SearchScope.SOURCE);
        if (js != null) {
            return js.getClasspathInfo().getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, scope);
        }
        return null;
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(Project project, JavaSource js) {
        return ProjectUtilities.getProjectTypes(ProjectUtilities.getSourceRoots((Lookup.Provider)project, true), js);
    }
}

