/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MoveClassTransformer
extends RefactoringVisitor {
    private Problem problem;
    private final ElementHandle<TypeElement> elementHandle;
    private final URL targetURL;
    private boolean inMovingClass;
    private String targetPackageName;
    private String targetFqn;
    private boolean moveToDefaulPackageProblem = false;
    private String originalPackage;
    private Map<Tree, Tree> original2Translated;
    private Set<ImportTree> importToRemove;
    private boolean isThisFileReferencingOldPackage = false;
    private final ElementHandle<TypeElement> targetHandle;
    private final FileObject targetFile;
    private final FileObject sourceFile;
    private boolean deleteFile;

    public MoveClassTransformer(TreePathHandle elementHandle, URL targetURL) {
        this((ElementHandle<TypeElement>)elementHandle.getElementHandle(), targetURL, null, null, null);
        this.targetPackageName = RefactoringUtils.getPackageName(targetURL);
    }

    public MoveClassTransformer(TreePathHandle elementHandle, ElementHandle<TypeElement> targetHandle, FileObject targetFile, FileObject sourceFile) {
        this((ElementHandle<TypeElement>)elementHandle.getElementHandle(), null, targetHandle, targetFile, sourceFile);
    }

    public MoveClassTransformer(ElementHandle<TypeElement> elementHandle, ElementHandle<TypeElement> targetHandle, FileObject targetFile, FileObject sourceFile) {
        this(elementHandle, null, targetHandle, targetFile, sourceFile);
    }

    private MoveClassTransformer(ElementHandle<TypeElement> elementHandle, URL targetURL, ElementHandle<TypeElement> targetHandle, FileObject targetFile, FileObject sourceFile) {
        this.elementHandle = elementHandle;
        this.targetURL = targetURL;
        this.targetHandle = targetHandle;
        this.targetFile = targetFile;
        this.sourceFile = sourceFile;
    }

    Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        if (this.sourceFile != null) {
            SourceUtils.forceSource((CompilationController)workingCopy, (FileObject)this.sourceFile);
        }
        super.setWorkingCopy(workingCopy);
        TypeElement element = (TypeElement)this.elementHandle.resolve((CompilationInfo)workingCopy);
        this.originalPackage = this.getPackageOf(element).getQualifiedName().toString();
        if (this.targetHandle != null) {
            TypeElement targetElement = (TypeElement)this.targetHandle.resolve((CompilationInfo)workingCopy);
            this.targetFqn = targetElement.getQualifiedName().toString() + "." + element.getSimpleName();
            this.targetPackageName = this.getPackageOf(targetElement).getQualifiedName().toString();
        } else {
            this.targetFqn = RefactoringUtils.getPackageName(this.targetURL) + "." + element.getSimpleName();
        }
        this.importToRemove = new HashSet<ImportTree>();
    }

    /*
     * WARNING - void declaration
     */
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.original2Translated = new HashMap<Tree, Tree>();
        boolean deleteThisFile = false;
        Tree result = (Tree)super.visitCompilationUnit(node, (Object)p);
        List<? extends Tree> typeDecls = node.getTypeDecls();
        CompilationUnitTree cut = node;
        for (Tree tree : typeDecls) {
            TypeMirror type = this.workingCopy.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree));
            TypeMirror sourceType = ((TypeElement)this.elementHandle.resolve((CompilationInfo)this.workingCopy)).asType();
            if (type == null || sourceType == null || !this.workingCopy.getTypes().isSameType(type, sourceType)) continue;
            if (typeDecls.size() > 1) {
                cut = this.make.removeCompUnitTypeDecl(cut, tree);
            } else {
                deleteThisFile = true;
                this.deleteFile = true;
            }
            if (this.targetURL == null) continue;
            this.createNewFileForType(cut, tree, node);
        }
        TreeUtilities treeUtilities = this.workingCopy.getTreeUtilities();
        if (deleteThisFile || treeUtilities.isSynthetic(this.getCurrentPath())) {
            return result;
        }
        cut = (CompilationUnitTree)treeUtilities.translate((Tree)cut, this.original2Translated);
        List<? extends ImportTree> list = cut.getImports();
        if (!this.importToRemove.isEmpty()) {
            ArrayList<? extends ImportTree> temp = new ArrayList<ImportTree>(list);
            temp.removeAll(this.importToRemove);
            ArrayList<? extends ImportTree> arrayList = temp;
        }
        if (!this.importToRemove.isEmpty()) {
            void var8_11;
            cut = this.make.CompilationUnit(cut.getPackageName(), (List)var8_11, cut.getTypeDecls(), cut.getSourceFile());
        }
        this.rewrite(node, cut);
        return result;
    }

    public Tree visitClass(ClassTree node, Element p) {
        TreePath currentPath = this.getCurrentPath();
        Element element = this.workingCopy.getTrees().getElement(currentPath);
        if (this.isTopLevelClass(element)) {
            boolean bl = this.inMovingClass = element == this.elementHandle.resolve((CompilationInfo)this.workingCopy);
        }
        if (this.targetHandle != null) {
            Element resolved;
            TypeMirror type = this.workingCopy.getTrees().getTypeMirror(currentPath);
            TypeMirror targetType = ((TypeElement)this.targetHandle.resolve((CompilationInfo)this.workingCopy)).asType();
            if (targetType != null && this.workingCopy.getTypes().isSameType(type, targetType) && (resolved = this.elementHandle.resolve((CompilationInfo)this.workingCopy)) != null) {
                final TreePath resolvedPath = this.workingCopy.getTrees().getPath(resolved);
                GeneratorUtilities get = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                ClassTree classTree = (ClassTree)this.workingCopy.getTrees().getTree(resolved);
                ClassTree origTree = (ClassTree)get.importComments((Tree)classTree, this.workingCopy.getTrees().getPath(resolved).getCompilationUnit());
                final HashMap org2trans = new HashMap();
                ErrorAwareTreeScanner<Object, Element> scanner = new ErrorAwareTreeScanner<Object, Element>(){

                    public Object visitIdentifier(IdentifierTree node, Element p) {
                        Element el = MoveClassTransformer.this.workingCopy.getTrees().getElement(new TreePath(resolvedPath, node));
                        if (el != null) {
                            if (MoveClassTransformer.this.isElementMoving(el)) {
                                ExpressionTree newIdent = MoveClassTransformer.this.make.QualIdent(MoveClassTransformer.this.targetFqn);
                                org2trans.put(node, newIdent);
                            } else if (MoveClassTransformer.this.isParentElementMoving(el)) {
                                org2trans.put(node, MoveClassTransformer.this.make.Identifier((CharSequence)node.getName()));
                            }
                            if (MoveClassTransformer.this.isTopLevelClass(el) && !MoveClassTransformer.this.isElementMoving(el) && MoveClassTransformer.this.getPackageOf(el).toString().equals(MoveClassTransformer.this.originalPackage)) {
                                MoveClassTransformer.this.isThisFileReferencingOldPackage = true;
                            }
                        }
                        return super.visitIdentifier(node, (Object)p);
                    }
                };
                scanner.scan((Tree)classTree, (Object)p);
                if (!org2trans.isEmpty()) {
                    classTree = (ClassTree)this.workingCopy.getTreeUtilities().translate((Tree)classTree, org2trans);
                }
                ClassTree newClass = classTree;
                ModifiersTree modifiers = newClass.getModifiers();
                EnumSet<Modifier> flags = EnumSet.noneOf(Modifier.class);
                if (!modifiers.getFlags().isEmpty()) {
                    flags.addAll(modifiers.getFlags());
                }
                flags.add(Modifier.STATIC);
                switch (newClass.getKind()) {
                    case CLASS: {
                        newClass = this.make.Class(this.make.Modifiers(flags, modifiers.getAnnotations()), (CharSequence)newClass.getSimpleName(), newClass.getTypeParameters(), newClass.getExtendsClause(), newClass.getImplementsClause(), newClass.getMembers());
                        break;
                    }
                    case INTERFACE: {
                        newClass = this.make.Interface(this.make.Modifiers(flags, modifiers.getAnnotations()), (CharSequence)newClass.getSimpleName(), newClass.getTypeParameters(), newClass.getImplementsClause(), newClass.getMembers());
                        break;
                    }
                    case ENUM: {
                        newClass = this.make.Enum(this.make.Modifiers(flags, modifiers.getAnnotations()), (CharSequence)newClass.getSimpleName(), newClass.getImplementsClause(), newClass.getMembers());
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        newClass = this.make.AnnotationType(this.make.Modifiers(flags, modifiers.getAnnotations()), (CharSequence)newClass.getSimpleName(), newClass.getMembers());
                    }
                }
                get.copyComments((Tree)origTree, (Tree)newClass, true);
                get.copyComments((Tree)origTree, (Tree)newClass, false);
                newClass = (ClassTree)get.importFQNs((Tree)newClass);
                newClass = get.insertClassMember(node, (Tree)newClass);
                this.original2Translated.put(node, newClass);
            }
        }
        return (Tree)super.visitClass(node, (Object)p);
    }

    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        Element el;
        if (!JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (this.isElementMoving(el)) {
                String newPackageName = this.targetPackageName;
                if (!"".equals(newPackageName)) {
                    ExpressionTree nju = this.make.QualIdent(this.targetFqn);
                    this.original2Translated.put(node, nju);
                } else if (!this.moveToDefaulPackageProblem) {
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage")));
                    this.moveToDefaulPackageProblem = true;
                }
            } else if (this.inMovingClass) {
                if (el.getKind() != ElementKind.PACKAGE) {
                    TypeElement outermostTypeElement;
                    TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                    EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                    TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                    Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                    if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                        neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                    }
                    if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                        outermostTypeElement = (TypeElement)el;
                    }
                    if (!(this.targetPackageName.equals(this.originalPackage) || !this.getPackageOf(el).toString().equals(this.originalPackage) || this.containsAnyOf(el, neededMods) && (enclosingTypeElement == null || this.containsAnyOf(enclosingTypeElement, neededMods)) || this.isElementMoving(outermostTypeElement))) {
                        this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                    }
                }
            } else if (el.getKind() != ElementKind.PACKAGE) {
                TypeElement outermostTypeElement;
                TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                    neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                }
                if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                    outermostTypeElement = (TypeElement)el;
                }
                if (!this.targetPackageName.equals(this.originalPackage) && this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.isElementMoving(outermostTypeElement)) {
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                }
            }
        }
        return (Tree)super.visitMemberSelect(node, (Object)p);
    }

    public Tree visitIdentifier(IdentifierTree node, Element p) {
        Element el;
        if (!this.inMovingClass && !JavaPluginUtils.isSyntheticPath((CompilationInfo)this.workingCopy, this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (this.isElementMoving(el)) {
                ExpressionTree newIdent = this.make.QualIdent(this.targetFqn);
                this.original2Translated.put(node, newIdent);
            } else if (el.getKind() != ElementKind.PACKAGE) {
                TypeElement outermostTypeElement;
                TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(el);
                EnumSet<Modifier> neededMods = EnumSet.of(Modifier.PUBLIC);
                TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false);
                Element enclosingClass = this.workingCopy.getTrees().getElement(enclosingClassPath);
                if (enclosingTypeElement != null && enclosingClass != null && this.workingCopy.getTypes().isSubtype(enclosingClass.asType(), enclosingTypeElement.asType())) {
                    neededMods = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED);
                }
                if ((outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el)) == null && (el.getKind().isClass() || el.getKind().isInterface())) {
                    outermostTypeElement = (TypeElement)el;
                }
                if (!this.targetPackageName.equals(this.originalPackage) && this.getPackageOf(el).toString().equals(this.originalPackage) && (!this.containsAnyOf(el, neededMods) || enclosingTypeElement != null && !this.containsAnyOf(enclosingTypeElement, neededMods)) && this.isElementMoving(outermostTypeElement)) {
                    this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)el, (Object)outermostTypeElement.getSimpleName())));
                }
            }
        }
        return (Tree)super.visitIdentifier(node, (Object)p);
    }

    public Tree visitImport(ImportTree node, Element p) {
        Element el;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getQualifiedIdentifier()))) != null && this.isElementMoving(el)) {
            this.importToRemove.add(node);
            return node;
        }
        return (Tree)super.visitImport(node, (Object)p);
    }

    private boolean isElementMoving(Element el) {
        if (el == null) {
            return false;
        }
        ElementKind kind = el.getKind();
        if (!kind.isClass() && !kind.isInterface()) {
            return false;
        }
        TypeElement resolved = (TypeElement)this.elementHandle.resolve((CompilationInfo)this.workingCopy);
        return el == resolved;
    }

    private boolean isParentElementMoving(Element el) {
        TypeElement outermostTypeElement = this.workingCopy.getElementUtilities().outermostTypeElement(el);
        return this.isElementMoving(outermostTypeElement);
    }

    private PackageElement getPackageOf(Element el) {
        return this.workingCopy.getElements().getPackageOf(el);
    }

    private boolean containsAnyOf(Element el, EnumSet<Modifier> neededMods) {
        for (Modifier mod : neededMods) {
            if (!el.getModifiers().contains((Object)mod)) continue;
            return true;
        }
        return false;
    }

    private boolean isTopLevelClass(Element el) {
        return el != null && (el.getKind().isClass() || el.getKind().isInterface()) && el.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    private FileObject getOrCreateFolder(URL url) throws IOException {
        try {
            FileObject result = URLMapper.findFileObject((URL)url);
            if (result != null) {
                return result;
            }
            File f = Utilities.toFile((URI)url.toURI());
            result = FileUtil.createFolder((File)f);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public boolean deleteFile() {
        return this.deleteFile;
    }

    private void createNewFileForType(CompilationUnitTree cut, Tree clazz, CompilationUnitTree node) throws MissingResourceException {
        try {
            ExpressionTree newPackageName;
            FileObject targetRoot = RefactoringUtils.getClassPathRoot(this.targetURL);
            FileObject target = this.getOrCreateFolder(this.targetURL);
            String relativePath = FileUtil.getRelativePath((FileObject)targetRoot, (FileObject)target);
            if (this.isThisFileReferencingOldPackage && (newPackageName = cut.getPackageName()) != null && !this.moveToDefaulPackageProblem) {
                this.problem = JavaPluginUtils.chainProblems(this.problem, new Problem(false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage")));
                this.moveToDefaulPackageProblem = true;
            }
            GeneratorUtilities.get((WorkingCopy)this.workingCopy).importComments(clazz, node);
            String cuPath = relativePath + "/" + ((ClassTree)clazz).getSimpleName() + ".java";
            CompilationUnitTree compilationUnit = JavaPluginUtils.createCompilationUnit(targetRoot, cuPath, clazz, this.workingCopy, this.make);
            compilationUnit = (CompilationUnitTree)GeneratorUtilities.get((WorkingCopy)this.workingCopy).importFQNs((Tree)compilationUnit);
            this.rewrite(null, compilationUnit);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

