/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.Action;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class SelectNodeAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private static final String SELECT_IN_PROJECTS_ICON = "org/netbeans/modules/project/ui/resources/projectTab.png";
    private static final String SELECT_IN_FILES_ICON = "org/netbeans/modules/project/ui/resources/filesTab.png";
    private final String findIn;

    public static SelectNodeAction inProjects() {
        return new SelectNodeAction(SELECT_IN_PROJECTS_ICON, Bundle.LBL_SelectInProjectsAction_MainMenuName(), "projectTabLogical_tc", null);
    }

    public static SelectNodeAction inFiles() {
        return new SelectNodeAction(SELECT_IN_FILES_ICON, Bundle.LBL_SelectInFilesAction_MainMenuName(), "projectTab_tc", null);
    }

    private SelectNodeAction(String icon, String name, String findIn, Lookup lookup) {
        super(null, lookup, new Class[]{DataObject.class, FileObject.class});
        this.putValue("iconBase", icon);
        this.findIn = findIn;
        this.setDisplayName(name);
    }

    @Override
    protected void actionPerformed(Lookup context) {
        FileObject fo = this.getFileFromLookup(context);
        if (fo != null) {
            ProjectTab pt = ProjectTab.findDefault(this.findIn);
            pt.selectNodeAsync(fo);
        }
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        FileObject fo = this.getFileFromLookup(context);
        this.setEnabled(fo != null);
    }

    private FileObject getFileFromLookup(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return fo;
        }
        DataObject dobj = (DataObject)context.lookup(DataObject.class);
        return dobj == null ? null : dobj.getPrimaryFile();
    }

    public Action createContextAwareInstance(Lookup context) {
        return new SelectNodeAction((String)this.getValue("iconBase"), (String)this.getValue("Name"), this.findIn, context);
    }
}

