/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.javaee.wildfly.config.JBossDataSourceRefModifier;
import org.netbeans.modules.javaee.wildfly.config.JBossEjbRefModifier;
import org.netbeans.modules.javaee.wildfly.config.JBossMsgDestRefModifier;
import org.netbeans.modules.javaee.wildfly.config.ResourceConfigurationHelper;
import org.netbeans.modules.javaee.wildfly.config.WarDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.WildflyDatasource;
import org.netbeans.modules.javaee.wildfly.config.WildflyDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.gen.EnterpriseBeans;
import org.netbeans.modules.javaee.wildfly.config.gen.Entity;
import org.netbeans.modules.javaee.wildfly.config.gen.Jboss;
import org.netbeans.modules.javaee.wildfly.config.gen.MessageDriven;
import org.netbeans.modules.javaee.wildfly.config.gen.ResourceRef;
import org.netbeans.modules.javaee.wildfly.config.gen.Session;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EjbDeploymentConfiguration
extends WildflyDeploymentConfiguration
implements ModuleConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private static final String SESSION_RESOURCE_REF = "/ejb-jar/enterprise-beans/session/resource-ref";
    private static final String ENTITY_RESOURCE_REF = "/ejb-jar/enterprise-beans/entity/resource-ref";
    private static final String MSGDRV_RESOURCE_REF = "/ejb-jar/enterprise-beans/message-driven/resource-ref";
    private static final String SESSION_EJB_REF = "/ejb-jar/enterprise-beans/session/ejb-ref";
    private static final String ENTITY_EJB_REF = "/ejb-jar/enterprise-beans/entity/ejb-ref";
    private static final String MSGDRV_EJB_REF = "/ejb-jar/enterprise-beans/message-driven/ejb-ref";
    private static final String MSGDRV = "/ejb-jar/enterprise-beans/message-driven";
    private static final String MSGDRV_MSG_DEST = "/ejb-jar/enterprise-beans/message-driven/message-destination-link";
    private static final String SESSION_MSG_DEST_REF = "/ejb-jar/enterprise-beans/session/message-destination-ref";
    private static final String ENTITY_MSG_DEST_REF = "/ejb-jar/enterprise-beans/entity/message-destination-ref";
    private static final String MSGDRV_MSG_DEST_REF = "/ejb-jar/enterprise-beans/message-driven/message-destination-ref";
    private File jbossFile;
    private Jboss jboss;
    private String tempEjbName;

    public EjbDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, true);
    }

    public EjbDeploymentConfiguration(J2eeModule j2eeModule, WildflyPluginUtils.Version version, boolean isWildFly) {
        super(j2eeModule, version, isWildFly);
        this.jbossFile = j2eeModule.getDeploymentConfigurationFile("META-INF/jboss.xml");
        this.getJboss();
        if (this.deploymentDescriptorDO == null && this.jbossFile != null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace((Throwable)donfe);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    private final synchronized Jboss getJboss() {
        if (this.jboss == null) {
            try {
                if (this.jbossFile != null && this.jbossFile.exists()) {
                    try {
                        this.jboss = Jboss.createGraph(this.jbossFile);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException ioe) {}
                } else {
                    this.jboss = this.generateJboss();
                    if (this.jbossFile != null) {
                        ResourceConfigurationHelper.writeFile(this.jbossFile, this.jboss);
                    }
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.jboss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("modified".equals(evt.getPropertyName()) && evt.getNewValue() == Boolean.FALSE && evt.getSource() == this.deploymentDescriptorDO) {
            EjbDeploymentConfiguration ejbDeploymentConfiguration = this;
            synchronized (ejbDeploymentConfiguration) {
                this.jboss = null;
            }
        }
    }

    private Set getRelevantBeansDataRef(String desc, String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] descs = resRefs[j].getText("description");
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (descs.length <= 0 || names.length <= 0 || types.length <= 0 || !descs[0].equals(desc) || !names[0].equals(resRefName) || !"javax.sql.DataSource".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansDataRef(String desc, String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] descs = resRefs[j].getText("description");
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (descs.length <= 0 || names.length <= 0 || types.length <= 0 || !descs[0].equals(desc) || !names[0].equals(resRefName) || !"javax.sql.DataSource".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansEjbRef(String ejbRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] ejbRefs = bean.getChildBean("ejb-ref");
            for (int j = 0; ejbRefs != null && j < ejbRefs.length; ++j) {
                String[] names = ejbRefs[j].getText("ejb-ref-name");
                String[] types = ejbRefs[j].getText("ejb-ref-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(ejbRefName) || !"Session".equals(types[0]) && !"Entity".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansEjbRef(String ejbRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] ejbRefs = bean.getChildBean("ejb-ref");
            for (int j = 0; ejbRefs != null && j < ejbRefs.length; ++j) {
                String[] names = ejbRefs[j].getText("ejb-ref-name");
                String[] types = ejbRefs[j].getText("ejb-ref-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(ejbRefName) || !"Session".equals(types[0]) && !"Entity".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansMailRef(String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.mail.Session".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansMailRef(String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.mail.Session".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansConnectionFactoryRef(String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.jms.ConnectionFactory".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansConnectionFactoryRef(String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.jms.ConnectionFactory".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansMsgDestRef(String msgDestRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] msgDestRefs = bean.getChildBean("message-destination-ref");
            for (int j = 0; msgDestRefs != null && j < msgDestRefs.length; ++j) {
                String[] names = msgDestRefs[j].getText("message-destination-ref-name");
                if (names.length <= 0 || !names[0].equals(msgDestRefName)) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansMsgDestRef(String msgDestRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] msgDestRefs = bean.getChildBean("message-destination-ref");
            for (int j = 0; msgDestRefs != null && j < msgDestRefs.length; ++j) {
                String[] names = msgDestRefs[j].getText("message-destination-ref-name");
                if (names.length <= 0 || !names[0].equals(msgDestRefName)) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    @Override
    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.add(ejbName);
        if ("Session".equals(ejbType)) {
            this.addResReference(jndiName, referenceName, beanNames, BEAN_TYPE.SESSION);
        } else if ("Entity".equals(ejbType)) {
            this.addResReference(jndiName, referenceName, beanNames, BEAN_TYPE.ENTITY);
        } else if ("MessageDriven".equals(ejbType)) {
            this.addMsgDrvResReference(jndiName, referenceName, ejbName);
        }
    }

    @Override
    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        MessageDriven[] mdbs;
        Entity[] entities;
        Session[] sessions;
        EnterpriseBeans beans = this.getJboss().getEnterpriseBeans();
        if (beans == null) {
            return null;
        }
        for (Session session : sessions = beans.getSession()) {
            ResourceRef[] resourceRefs;
            if (!ejbName.equals(session.getEjbName())) continue;
            for (ResourceRef resourceRef : resourceRefs = session.getResourceRef()) {
                String jndiName;
                String rrn = resourceRef.getResRefName();
                if (!referenceName.equals(rrn) || (jndiName = resourceRef.getJndiName()) == null) continue;
                return WildflyDatasource.getJndiName(jndiName);
            }
            return null;
        }
        for (Entity entity : entities = beans.getEntity()) {
            ResourceRef[] resourceRefs;
            if (!ejbName.equals(entity.getEjbName())) continue;
            for (ResourceRef resourceRef : resourceRefs = entity.getResourceRef()) {
                String rrn = resourceRef.getResRefName();
                if (!referenceName.equals(rrn)) continue;
                return resourceRef.getJndiName();
            }
            return null;
        }
        for (MessageDriven mdb : mdbs = beans.getMessageDriven()) {
            ResourceRef[] resourceRefs;
            if (!ejbName.equals(mdb.getEjbName())) continue;
            for (ResourceRef resourceRef : resourceRefs = mdb.getResourceRef()) {
                String rrn = resourceRef.getResRefName();
                if (!referenceName.equals(rrn)) continue;
                return resourceRef.getJndiName();
            }
            return null;
        }
        return null;
    }

    private void addResReference(final String jndiName, final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    private void addMsgDrvResReference(final String jndiName, final String resRefName, final String mdbName) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossDataSourceRefModifier.modifyMsgDrv(modifiedJboss, resRefName, mdbName, jndiName);
            }
        });
    }

    @Override
    public void bindEjbReferenceForEjb(String ejbName, String ejbType, String referenceName, String referencedEjbName) throws ConfigurationException {
        if (Double.parseDouble(this.j2eeModule.getModuleVersion()) > 2.1) {
            return;
        }
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.add(ejbName);
        if ("Session".equals(ejbType)) {
            this.addEjbReference(referenceName, referencedEjbName, beanNames, BEAN_TYPE.SESSION);
        } else if ("Entity".equals(ejbType)) {
            this.addEjbReference(referenceName, referencedEjbName, beanNames, BEAN_TYPE.ENTITY);
        } else if ("MessageDriven".equals(ejbType)) {
            this.addMsgDrvEjbReference(referenceName, referencedEjbName, ejbName);
        }
    }

    private void addEjbReference(final String ejbRefName, final String referencedEjbName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossEjbRefModifier.modify(modifiedJboss, ejbRefName, referencedEjbName, beanNames, beanType);
            }
        });
    }

    private void addMsgDrvEjbReference(final String ejbRefName, final String referencedEjbName, final String mdbName) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossEjbRefModifier.modifyMsgDrv(modifiedJboss, mdbName, ejbRefName, referencedEjbName);
            }
        });
    }

    private void addMailReference(final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                String jndiName = "java:Mail";
                JBossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    @Override
    public void bindMdbToMessageDestination(String mdbName, String name, MessageDestination.Type type) throws ConfigurationException {
        if (Double.parseDouble(this.j2eeModule.getModuleVersion()) > 2.1) {
            return;
        }
        this.addMDB(mdbName, name, type);
    }

    @Override
    public String findMessageDestinationName(String mdbName) throws ConfigurationException {
        MessageDriven[] mdbs;
        EnterpriseBeans beans = this.getJboss().getEnterpriseBeans();
        if (beans == null) {
            return null;
        }
        for (MessageDriven mdb : mdbs = beans.getMessageDriven()) {
            if (!mdbName.equals(mdb.getEjbName())) continue;
            String destJndiName = mdb.getDestinationJndiName();
            if (destJndiName != null) {
                if (destJndiName.startsWith("queue/") || destJndiName.startsWith("topic/")) {
                    return destJndiName.substring(6);
                }
                Logger.getLogger("global").log(Level.INFO, NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_NoPrefix", (Object)destJndiName));
            }
            return null;
        }
        return null;
    }

    private void addMDB(final String name, final String destName, final MessageDestination.Type destType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
                if (eb == null) {
                    eb = new EnterpriseBeans();
                    modifiedJboss.setEnterpriseBeans(eb);
                }
                MessageDriven[] mdbs = eb.getMessageDriven();
                for (int i = 0; i < mdbs.length; ++i) {
                    String en = mdbs[i].getEjbName();
                    if (!name.equals(en)) continue;
                    return;
                }
                MessageDriven mdb = new MessageDriven();
                mdb.setEjbName(name);
                if (MessageDestination.Type.QUEUE.equals((Object)destType)) {
                    mdb.setDestinationJndiName("queue/" + destName);
                } else if (MessageDestination.Type.TOPIC.equals((Object)destType)) {
                    mdb.setDestinationJndiName("topic/" + destName);
                }
                eb.addMessageDriven(mdb);
            }
        });
    }

    private void addConnectionFactoryReference(final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                String jndiName = "ConnectionFactory";
                JBossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    private void addMsgDrvConnectionFactoryReference(final String connectionFactoryName, final String mdbName) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                String jndiName = "ConnectionFactory";
                JBossDataSourceRefModifier.modifyMsgDrv(modifiedJboss, connectionFactoryName, mdbName, jndiName);
            }
        });
    }

    @Override
    public void bindMessageDestinationReferenceForEjb(String ejbName, String ejbType, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.add(ejbName);
        String destPrefix = null;
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            destPrefix = "queue/";
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            destPrefix = "topic/";
        }
        if ("Session".equals(ejbType)) {
            this.addConnectionFactoryReference(connectionFactoryName, beanNames, BEAN_TYPE.SESSION);
            this.addMsgDestReference(referenceName, destPrefix, destName, beanNames, BEAN_TYPE.SESSION);
        } else if ("Entity".equals(ejbType)) {
            this.addConnectionFactoryReference(connectionFactoryName, beanNames, BEAN_TYPE.ENTITY);
            this.addMsgDestReference(referenceName, destPrefix, destName, beanNames, BEAN_TYPE.ENTITY);
        } else if ("MessageDriven".equals(ejbType)) {
            this.addMsgDrvConnectionFactoryReference(connectionFactoryName, ejbName);
            this.addMsgDrvMsgDestReference(referenceName, destPrefix, destName, ejbName);
        }
    }

    private void addMsgDestReference(final String msgDestRefName, final String destPrefix, final String destName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossMsgDestRefModifier.modify(modifiedJboss, msgDestRefName, beanNames, beanType, destPrefix, destName);
            }
        });
    }

    private void addMsgDrvMsgDestReference(final String msgDestRefName, final String destPrefix, final String destName, final String mdbName) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            @Override
            public void modify(Jboss modifiedJboss) {
                JBossMsgDestRefModifier.modifyMsgDrv(modifiedJboss, msgDestRefName, mdbName, destPrefix, destName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJboss(JbossModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Jboss newJboss = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJboss = Jboss.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Jboss oldJboss = this.getJboss();
                if (oldJboss == null) {
                    String msg = NbBundle.getMessage(WildflyDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossFile.getAbsolutePath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossXmlNotValid", (Object)"jboss.xml"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJboss = oldJboss;
            }
            modifier.modify(newJboss);
            boolean modified = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(doc, newJboss);
            if (!modified && (cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            EjbDeploymentConfiguration ejbDeploymentConfiguration = this;
            synchronized (ejbDeploymentConfiguration) {
                this.jboss = newJboss;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        Jboss jboss = this.getJboss();
        if (jboss == null) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        try {
            jboss.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(EjbDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private Jboss generateJboss() {
        return new Jboss();
    }

    static interface JbossModifier {
        public void modify(Jboss var1);
    }

    static class BEAN_TYPE {
        private String type;
        static final BEAN_TYPE SESSION = new BEAN_TYPE("session");
        static final BEAN_TYPE ENTITY = new BEAN_TYPE("entity");
        static final BEAN_TYPE MSGDRV = new BEAN_TYPE("message-driven");

        private BEAN_TYPE(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }
    }
}

