/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.StringEscapeUtils;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class CombinedAssignmentOperatorSuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Combined.Assignment.Operator.Suggestion";

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.CombinedAssignmentOperatorSuggestion_Description();
    }

    public String getDisplayName() {
        return Bundle.CombinedAssignmentOperatorSuggestion_DisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset) && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, this, context.doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    protected PhpVersion getPhpVersion(FileObject fileObject) {
        return CodeUtils.getPhpVersion(fileObject);
    }

    private boolean isAtLeastPhp74(FileObject fileObject) {
        return this.getPhpVersion(fileObject).compareTo((Enum)PhpVersion.PHP_74) >= 0;
    }

    private static final class Fix
    implements HintFix {
        private final FixInfo fixInfo;
        private final BaseDocument document;

        private Fix(FixInfo fixInfo, BaseDocument document) {
            this.fixInfo = fixInfo;
            this.document = document;
        }

        public String getDescription() {
            return Bundle.CombinedAssignmentOperatorSuggestion_Fix_Description(StringEscapeUtils.escapeHtml((String)this.fixInfo.getOperator()) + "=");
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            OffsetRange removalOffsetRange = this.fixInfo.getRemovalOffsetRange();
            String combinedOperator = String.format(" %s= ", this.fixInfo.getOperator());
            edits.replace(removalOffsetRange.getStart(), removalOffsetRange.getLength(), combinedOperator, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class FixInfo {
        private final String operator;
        private final OffsetRange removalOffsetRange;

        public FixInfo(String operator, OffsetRange removingOffsetRange) {
            this.operator = operator;
            this.removalOffsetRange = removingOffsetRange;
        }

        public String getOperator() {
            return this.operator;
        }

        public OffsetRange getRemovalOffsetRange() {
            return this.removalOffsetRange;
        }

        public HintFix createFix(BaseDocument document) {
            return new Fix(this, document);
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final CombinedAssignmentOperatorSuggestion suggestion;
        private final BaseDocument document;
        private final OffsetRange lineRange;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();

        public CheckVisitor(FileObject fileObject, CombinedAssignmentOperatorSuggestion suggestion, BaseDocument document, OffsetRange lineRange) {
            this.fileObject = fileObject;
            this.suggestion = suggestion;
            this.document = document;
            this.lineRange = lineRange;
        }

        public List<Hint> getHints() {
            ArrayList<Hint> hints = new ArrayList<Hint>();
            for (FixInfo fixInfo : this.fixInfos) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                hints.add(new Hint((Rule)this.suggestion, Bundle.CombinedAssignmentOperatorSuggestion_Hint_Description(), this.fileObject, this.lineRange, this.createFixes(fixInfo), 500));
            }
            return hints;
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.add(fixInfo.createFix(this.document));
            return hintFixes;
        }

        @Override
        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineRange.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processAssignment(node);
            }
        }

        private void processAssignment(Assignment node) {
            Expression rightHandSide = node.getRightHandSide();
            if (this.suggestion.isAtLeastPhp74(this.fileObject) && rightHandSide instanceof ConditionalExpression) {
                this.processConditionalExpression((ConditionalExpression)rightHandSide, node);
            } else if (rightHandSide instanceof InfixExpression) {
                this.processInfixExpression((InfixExpression)rightHandSide, node);
            }
        }

        private void processConditionalExpression(ConditionalExpression conditionalExpression, Assignment assignment) {
            if (conditionalExpression.getOperator() == ConditionalExpression.OperatorType.COALESCE) {
                Expression condition = conditionalExpression.getCondition();
                this.addFixInfo(conditionalExpression.getOperator().toString(), condition, conditionalExpression.getIfFalse(), assignment);
            }
        }

        private void processInfixExpression(InfixExpression infixExpression, Assignment assignment) {
            if (CheckVisitor.isValidInfixExpressionOperator(infixExpression.getOperator())) {
                Expression left = infixExpression.getLeft();
                Expression right = infixExpression.getRight();
                String operator = infixExpression.getOperator().toString();
                if (!(left instanceof InfixExpression || right instanceof InfixExpression || right instanceof ParenthesisExpression)) {
                    this.addFixInfo(operator, left, right, assignment);
                }
            }
        }

        private void addFixInfo(String operator, Expression removalExpression, Expression removalEndExpression, Assignment assignment) {
            VariableBase leftHandSide = assignment.getLeftHandSide();
            if (removalExpression instanceof VariableBase && leftHandSide.toString().equals(removalExpression.toString())) {
                int removalStart = leftHandSide.getEndOffset();
                int removalEnd = removalEndExpression.getStartOffset();
                this.fixInfos.add(new FixInfo(operator, new OffsetRange(removalStart, removalEnd)));
            }
        }

        private static boolean isValidInfixExpressionOperator(InfixExpression.OperatorType operator) {
            return operator == InfixExpression.OperatorType.PLUS || operator == InfixExpression.OperatorType.MINUS || operator == InfixExpression.OperatorType.MUL || operator == InfixExpression.OperatorType.DIV || operator == InfixExpression.OperatorType.CONCAT || operator == InfixExpression.OperatorType.MOD || operator == InfixExpression.OperatorType.SL || operator == InfixExpression.OperatorType.SR || operator == InfixExpression.OperatorType.AND || operator == InfixExpression.OperatorType.OR || operator == InfixExpression.OperatorType.XOR || operator == InfixExpression.OperatorType.POW;
        }
    }
}

