/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api.debug;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.nativeimage.api.Location;
import org.netbeans.modules.nativeimage.api.SourceInfo;
import org.netbeans.modules.nativeimage.api.Symbol;
import org.netbeans.modules.nativeimage.api.debug.Bundle;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NILineBreakpointDescriptor;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.spi.debug.NIDebuggerProvider;
import org.netbeans.modules.nativeimage.spi.debug.NIDebuggerServiceProvider;
import org.netbeans.modules.nativeimage.spi.debug.filters.FrameDisplayer;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class NIDebugger {
    private final NIDebuggerProvider provider;

    NIDebugger(NIDebuggerProvider provider) {
        this.provider = provider;
    }

    public static Builder newBuilder() throws IllegalStateException {
        NIDebuggerServiceProvider provider = (NIDebuggerServiceProvider)Lookup.getDefault().lookup(NIDebuggerServiceProvider.class);
        if (provider == null) {
            throw (IllegalStateException)Exceptions.attachLocalizedMessage((Throwable)new IllegalStateException(), (String)Bundle.MSG_NoNativeDebug());
        }
        return new Builder(provider.create());
    }

    public Breakpoint addLineBreakpoint(Object id, NILineBreakpointDescriptor breakpointDescriptor) {
        Breakpoint breakpoint = this.provider.addLineBreakpoint(id, breakpointDescriptor);
        assert (breakpoint != null);
        return breakpoint;
    }

    public void removeBreakpoint(Object id) {
        this.provider.removeBreakpoint(id);
    }

    public CompletableFuture<Void> start(List<String> command, File workingDirectory, String debugger, String displayName, ExecutionDescriptor executionDescriptor, Consumer<DebuggerEngine> startedEngine) {
        return this.provider.start(command, workingDirectory, debugger, displayName, executionDescriptor, startedEngine);
    }

    public CompletableFuture<NIVariable> evaluateAsync(String expression, String resultName, NIFrame frame) {
        return this.provider.evaluateAsync(expression, resultName, frame);
    }

    public NIVariable evaluate(String expression, String resultName, NIFrame frame) throws EvaluateException {
        try {
            return this.provider.evaluateAsync(expression, resultName, frame).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new EvaluateException(ex.getCause());
        }
    }

    public String readMemory(String address, long offset, int length) {
        return this.provider.readMemory(address, offset, length);
    }

    public String getVersion() {
        return this.provider.getVersion();
    }

    @CheckForNull
    public List<Location> listLocations(String filePath) {
        return this.provider.listLocations(filePath);
    }

    @CheckForNull
    public Map<SourceInfo, List<Symbol>> listFunctions(String name, boolean includeNondebug, int maxResults) {
        return this.provider.listFunctions(name, includeNondebug, maxResults);
    }

    @CheckForNull
    public Map<SourceInfo, List<Symbol>> listVariables(String name, boolean includeNondebug, int maxResults) {
        return this.provider.listVariables(name, includeNondebug, maxResults);
    }

    public static final class Builder {
        private final NIDebuggerProvider debuggerProvider;

        Builder(NIDebuggerProvider debuggerProvider) {
            this.debuggerProvider = debuggerProvider;
        }

        public Builder frameDisplayer(FrameDisplayer frameDisplayer) {
            this.debuggerProvider.setFrameDisplayer(frameDisplayer);
            return this;
        }

        public Builder variablesDisplayer(VariableDisplayer variablesDisplayer) {
            this.debuggerProvider.setVariablesDisplayer(variablesDisplayer);
            return this;
        }

        public NIDebugger build() {
            return new NIDebugger(this.debuggerProvider);
        }
    }
}

