/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public abstract class Breakpoint {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DISPOSED = "disposed";
    public static final String PROP_GROUP_NAME = "groupName";
    public static final String PROP_GROUP_PROPERTIES = "groupProperties";
    public static final String PROP_VALIDITY = "validity";
    public static final String PROP_HIT_COUNT_FILTER = "hitCountFilter";
    private PropertyChangeSupport pcs;
    private String groupName = "";
    private VALIDITY validity = VALIDITY.UNKNOWN;
    private String validityMessage;
    private int hitCountFilter;
    private HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle;
    private volatile Set<Breakpoint> breakpointsToEnable = Collections.emptySet();
    private volatile Set<Breakpoint> breakpointsToDisable = Collections.emptySet();

    public Breakpoint() {
        this.pcs = new PropertyChangeSupport(this);
    }

    protected void dispose() {
    }

    public abstract boolean isEnabled();

    public abstract void disable();

    public abstract void enable();

    public final synchronized VALIDITY getValidity() {
        return this.validity;
    }

    public final synchronized String getValidityMessage() {
        return this.validityMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setValidity(VALIDITY validity, String reason) {
        VALIDITY old;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            this.validityMessage = reason;
            if (this.validity == validity) {
                return;
            }
            old = this.validity;
            this.validity = validity;
        }
        this.firePropertyChange(PROP_VALIDITY, (Object)old, (Object)validity);
    }

    public final synchronized int getHitCountFilter() {
        return this.hitCountFilter;
    }

    public final synchronized HIT_COUNT_FILTERING_STYLE getHitCountFilteringStyle() {
        return this.hitCountFilteringStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHitCountFilter(int hitCountFilter, HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle) {
        Object[] newProp;
        Object[] old;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            if (hitCountFilter == this.hitCountFilter && hitCountFilteringStyle == this.hitCountFilteringStyle) {
                return;
            }
            if (hitCountFilteringStyle == null && hitCountFilter > 0) {
                throw new NullPointerException("hitCountFilteringStyle must not be null.");
            }
            if (hitCountFilter == 0) {
                hitCountFilteringStyle = null;
            }
            old = this.hitCountFilter == 0 ? null : new Object[]{this.hitCountFilter, this.hitCountFilteringStyle};
            newProp = hitCountFilter == 0 ? null : new Object[]{hitCountFilter, hitCountFilteringStyle};
            this.hitCountFilter = hitCountFilter;
            this.hitCountFilteringStyle = hitCountFilteringStyle;
        }
        this.firePropertyChange(PROP_HIT_COUNT_FILTER, old, newProp);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String newGroupName) {
        if (this.groupName.equals(newGroupName)) {
            return;
        }
        String old = this.groupName;
        this.groupName = newGroupName.intern();
        this.firePropertyChange(PROP_GROUP_NAME, old, newGroupName);
    }

    public GroupProperties getGroupProperties() {
        return null;
    }

    public boolean canHaveDependentBreakpoints() {
        return false;
    }

    @NonNull
    public Set<Breakpoint> getBreakpointsToEnable() {
        if (!this.canHaveDependentBreakpoints()) {
            throw new UnsupportedOperationException("Cannot have dependent breakpoints.");
        }
        return this.breakpointsToEnable;
    }

    @NonNull
    public Set<Breakpoint> getBreakpointsToDisable() {
        if (!this.canHaveDependentBreakpoints()) {
            throw new UnsupportedOperationException("Cannot have dependent breakpoints.");
        }
        return this.breakpointsToDisable;
    }

    public void setBreakpointsToEnable(@NonNull Set<Breakpoint> breakpointsToEnable) {
        if (!this.canHaveDependentBreakpoints()) {
            throw new UnsupportedOperationException("Cannot have dependent breakpoints.");
        }
        this.breakpointsToEnable = breakpointsToEnable;
    }

    public void setBreakpointsToDisable(@NonNull Set<Breakpoint> breakpointsToDisable) {
        if (!this.canHaveDependentBreakpoints()) {
            throw new UnsupportedOperationException("Cannot have dependent breakpoints.");
        }
        this.breakpointsToDisable = breakpointsToDisable;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    protected void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    void disposeOut() {
        this.dispose();
        this.firePropertyChange(PROP_DISPOSED, Boolean.FALSE, Boolean.TRUE);
    }

    public static abstract class GroupProperties {
        public abstract String getLanguage();

        public abstract String getType();

        public abstract FileObject[] getFiles();

        public abstract Project[] getProjects();

        public abstract DebuggerEngine[] getEngines();

        public abstract boolean isHidden();
    }

    public static enum HIT_COUNT_FILTERING_STYLE {
        EQUAL,
        GREATER,
        MULTIPLE;

    }

    public static enum VALIDITY {
        UNKNOWN,
        VALID,
        INVALID;

    }
}

