/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;

public final class ModelFetcher {
    private static final AtomicInteger REQUEST_SEQUENCER = new AtomicInteger();
    final ExecutorService executor;
    final transient CountDownLatch lock = new CountDownLatch(1);
    final MultiModelAction action = new MultiModelAction();
    final Map<Integer, ModelResult> modelResults = new HashMap<Integer, ModelResult>();

    public ModelFetcher() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    public ModelFetcher(ExecutorService executor) {
        this.executor = executor;
    }

    public boolean isAcceptingRequests() {
        return !this.executor.isShutdown();
    }

    public <T> Future<T> requestModel(Class<T> modelType) throws RejectedExecutionException {
        return this.requestModel(null, modelType, null, null);
    }

    public <T> Future<T> requestModel(String target, Class<T> modelType) throws RejectedExecutionException {
        return this.requestModel(target, modelType, null, null);
    }

    public <T, P> Future<T> requestModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws RejectedExecutionException {
        return this.requestModel(null, modelType, parameterType, parameterInitializer);
    }

    public <T, P> Future<T> requestModel(String target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws RejectedExecutionException {
        ModelRequest<T, ? super P> req = new ModelRequest<T, P>(target, modelType, parameterType, parameterInitializer);
        Future<Object> ret = this.executor.submit(() -> {
            this.lock.await();
            ModelResult result = this.modelResults.get(req.sequenceId);
            if (result != null) {
                if (result.problem == null) {
                    return result.model;
                }
                throw new Exception(result.problem);
            }
            throw new Exception("Model not found");
        });
        this.action.modelRequests.add(req);
        return ret;
    }

    public <T, P> void modelAction(String target, Class<T> modelType, Action<T> action) throws RejectedExecutionException {
        this.modelAction(target, modelType, null, null, action, null);
    }

    public <T, P> void modelAction(String target, Class<T> modelType, Action<T> action, Action<Exception> error) throws RejectedExecutionException {
        this.modelAction(target, modelType, null, null, action, error);
    }

    public <T, P> void modelAction(String target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer, Action<T> action, Action<Exception> error) throws RejectedExecutionException {
        ModelRequest<T, ? super P> req = new ModelRequest<T, P>(target, modelType, parameterType, parameterInitializer);
        this.executor.submit(() -> {
            this.lock.await();
            ModelResult result = this.modelResults.get(req.sequenceId);
            if (result != null) {
                if (result.problem == null) {
                    if (action != null) {
                        action.execute(result.model);
                    }
                } else if (error != null) {
                    error.execute((Object)new Exception(result.problem));
                }
            } else {
                throw new Exception("Model not found");
            }
            return null;
        });
        this.action.modelRequests.add(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchModels(ProjectConnection pconn, Action<? super BuildActionExecuter> config) {
        this.executor.shutdown();
        try {
            if (!this.action.modelRequests.isEmpty()) {
                BuildActionExecuter exec = pconn.action((BuildAction)this.action);
                if (config != null) {
                    config.execute((Object)exec);
                }
                this.modelResults.putAll((Map)exec.run());
            }
        }
        finally {
            this.lock.countDown();
        }
    }

    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(time, unit);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return REQUEST_SEQUENCER;
    }

    static class ModelResult<T>
    implements Serializable {
        T model;
        Throwable problem;

        public ModelResult(T model) {
            this.model = model;
        }

        public ModelResult(Throwable problem) {
            this.problem = problem;
        }
    }

    static class ModelRequest<T, P>
    implements Serializable {
        final int sequenceId = ModelFetcher.access$000().getAndIncrement();
        String targetProjectId;
        Class<T> modelType;
        Class<P> parameterType;
        Action<? super P> parameterInitializer;

        public ModelRequest(String targetProjectId, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
            this.targetProjectId = targetProjectId;
            this.modelType = modelType;
            this.parameterType = parameterType;
            this.parameterInitializer = parameterInitializer;
        }
    }

    static class MultiModelAction
    implements BuildAction<Map<Integer, ModelResult>> {
        final List<ModelRequest> modelRequests = new LinkedList<ModelRequest>();

        MultiModelAction() {
        }

        public Map<Integer, ModelResult> execute(BuildController bc) {
            HashMap<Integer, ModelResult> ret = new HashMap<Integer, ModelResult>();
            LinkedList<ModelRequest> reqs = new LinkedList<ModelRequest>(this.modelRequests);
            Iterator it = reqs.iterator();
            while (it.hasNext()) {
                ModelRequest req = (ModelRequest)it.next();
                if (req.targetProjectId != null) continue;
                it.remove();
                if (req.parameterType != null) {
                    try {
                        ret.put(req.sequenceId, new ModelResult<Object>(bc.getModel(req.modelType, req.parameterType, req.parameterInitializer)));
                    }
                    catch (Throwable ex) {
                        ret.put(req.sequenceId, new ModelResult(ex));
                    }
                    continue;
                }
                try {
                    ret.put(req.sequenceId, new ModelResult<Object>(bc.getModel(req.modelType)));
                }
                catch (Throwable ex) {
                    ret.put(req.sequenceId, new ModelResult(ex));
                }
            }
            if (!reqs.isEmpty()) {
                GradleBuild build = bc.getBuildModel();
                HashMap<String, BasicGradleProject> projects = new HashMap<String, BasicGradleProject>();
                for (BasicGradleProject prj : build.getProjects()) {
                    projects.put(prj.getPath(), prj);
                }
                for (ModelRequest req : reqs) {
                    BasicGradleProject target = (BasicGradleProject)projects.get(req.targetProjectId);
                    if (target != null) {
                        if (req.parameterType != null) {
                            try {
                                ret.put(req.sequenceId, new ModelResult<Object>(bc.getModel((Model)target, req.modelType, req.parameterType, req.parameterInitializer)));
                            }
                            catch (Throwable ex) {
                                ret.put(req.sequenceId, new ModelResult(ex));
                            }
                            continue;
                        }
                        try {
                            ret.put(req.sequenceId, new ModelResult<Object>(bc.getModel((Model)target, req.modelType)));
                        }
                        catch (Throwable ex) {
                            ret.put(req.sequenceId, new ModelResult(ex));
                        }
                        continue;
                    }
                    ret.put(req.sequenceId, new ModelResult(new NullPointerException(req.targetProjectId)));
                }
            }
            return ret;
        }
    }
}

