/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.plugins.JavaPlatformPlugin;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.VersionNumber;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.tooling.NbProjectInfoModel;
import org.netbeans.modules.gradle.tooling.NeedOnlineModeException;

class NbProjectInfoBuilder {
    private static final String NB_PREFIX = "netbeans.";
    private static final Set<String> CONFIG_EXCLUDES = new HashSet<String>(Arrays.asList("archives", "checkstyle", "classycle", "codenarc", "findbugs", "findbugsPlugins", "jacocoAgent", "jacocoAnt", "jdepend", "pmd", ".*DependenciesMetadata"));
    private static final Pattern CONFIG_EXCLUDES_PATTERN = Pattern.compile(CONFIG_EXCLUDES.stream().reduce("", (s1, s2) -> s1 + "|" + s2));
    private static final Set<String> RECOGNISED_PLUGINS = new HashSet<String>(Arrays.asList("antlr", "application", "base", "checkstyle", "com.android.application", "com.android.library", "com.github.lkishalmi.gatling", "distribution", "ear", "findbugs", "groovy", "groovy-base", "io.micronaut.application", "ivy-publish", "jacoco", "java", "java-base", "java-library-distribution", "java-platform", "maven", "maven-publish", "org.jetbrains.kotlin.js", "org.jetbrains.kotlin.jvm", "org.jetbrains.kotlin.android", "org.springframework.boot", "osgi", "play", "pmd", "scala", "scala-base", "war"));
    final Project project;
    final VersionNumber gradleVersion;

    NbProjectInfoBuilder(Project project) {
        this.project = project;
        this.gradleVersion = VersionNumber.parse((String)project.getGradle().getGradleVersion());
    }

    public NbProjectInfo buildAll() {
        NbProjectInfoModel model = new NbProjectInfoModel();
        this.detectProjectMetadata(model);
        this.detectProps(model);
        this.detectLicense(model);
        this.detectPlugins(model);
        this.detectSources(model);
        this.detectTests(model);
        this.detectDependencies(model);
        this.detectArtifacts(model);
        this.detectDistributions(model);
        return model;
    }

    private void detectDistributions(NbProjectInfoModel model) {
        if (this.project.getPlugins().hasPlugin("distribution")) {
            DistributionContainer distributions = (DistributionContainer)this.project.getExtensions().findByType(DistributionContainer.class);
            model.getInfo().put("distributions", NbProjectInfoBuilder.storeSet(distributions.getNames()));
        }
    }

    private void detectLicense(NbProjectInfoModel model) {
        String license;
        String string = license = this.project.hasProperty("netbeans.license") ? this.project.property("netbeans.license").toString() : null;
        if (license == null) {
            license = this.project.hasProperty("license") ? this.project.property("license").toString() : null;
        }
        model.getInfo().put("license", license);
    }

    private void detectProjectMetadata(NbProjectInfoModel model) {
        long time = System.currentTimeMillis();
        model.getInfo().put("project_name", this.project.getName());
        model.getInfo().put("project_path", this.project.getPath());
        model.getInfo().put("project_status", this.project.getStatus());
        if (this.project.getParent() != null) {
            model.getInfo().put("project_parent_name", this.project.getParent().getName());
        }
        model.getInfo().put("project_description", this.project.getDescription());
        model.getInfo().put("project_group", this.project.getGroup().toString());
        model.getInfo().put("project_version", this.project.getVersion().toString());
        model.getInfo().put("project_buildDir", this.project.getBuildDir());
        model.getInfo().put("project_projectDir", this.project.getProjectDir());
        model.getInfo().put("project_rootDir", this.project.getRootDir());
        model.getInfo().put("gradle_user_home", this.project.getGradle().getGradleUserHomeDir());
        model.getInfo().put("gradle_home", this.project.getGradle().getGradleHomeDir());
        Set<Configuration> visibleConfigurations = this.configurationsToSave();
        model.getInfo().put("configurations", visibleConfigurations.stream().map(conf -> conf.getName()).collect(Collectors.toCollection(HashSet::new)));
        HashMap<String, File> sp = new HashMap<String, File>();
        for (Project p : this.project.getSubprojects()) {
            sp.put(p.getPath(), p.getProjectDir());
        }
        model.getInfo().put("project_subProjects", sp);
        HashMap ib = new HashMap();
        System.out.printf("Gradle Version: %s%n", this.gradleVersion);
        this.sinceGradle("3.1", () -> {
            for (IncludedBuild p : this.project.getGradle().getIncludedBuilds()) {
                System.out.printf("Include Build: %s%n", p.getName());
                ib.put(p.getName(), p.getProjectDir());
            }
        });
        model.getInfo().put("project_includedBuilds", ib);
        this.sinceGradle("3.3", () -> model.getInfo().put("project_display_name", this.project.getDisplayName()));
        try {
            model.getInfo().put("buildClassPath", NbProjectInfoBuilder.storeSet(this.project.getBuildscript().getConfigurations().getByName("classpath").getFiles()));
        }
        catch (RuntimeException e) {
            model.noteProblem(e);
        }
        HashSet<String[]> tasks = new HashSet<String[]>();
        for (Task t : this.project.getTasks()) {
            String[] arr = new String[]{t.getPath(), t.getGroup(), t.getName(), t.getDescription()};
            tasks.add(arr);
        }
        model.getInfo().put("tasks", tasks);
        model.registerPerf("meta", System.currentTimeMillis() - time);
    }

    private void detectPlugins(NbProjectInfoModel model) {
        long time = System.currentTimeMillis();
        HashSet<String> plugins = new HashSet<String>();
        for (String plugin : RECOGNISED_PLUGINS) {
            if (!this.project.getPlugins().hasPlugin(plugin)) continue;
            plugins.add(plugin);
        }
        model.getInfo().put("plugins", plugins);
        model.registerPerf("plugins", System.currentTimeMillis() - time);
    }

    private void detectTests(NbProjectInfoModel model) {
        HashSet testClassesRoots = new HashSet();
        this.sinceGradle("4.0", () -> this.project.getTasks().withType(Test.class).stream().forEach(task -> task.getTestClassesDirs().forEach(dir -> testClassesRoots.add(dir))));
        this.beforeGradle("4.0", () -> this.project.getTasks().withType(Test.class).stream().forEach(task -> testClassesRoots.add((File)NbProjectInfoBuilder.getProperty(task, "testClassesDir"))));
        model.getInfo().put("test_classes_dirs", testClassesRoots);
        if (this.project.getPlugins().hasPlugin("jacoco")) {
            HashSet coverageData = new HashSet();
            this.project.getTasks().withType(Test.class).stream().forEach(task -> coverageData.add((File)NbProjectInfoBuilder.getProperty(task, "jacoco", "destinationFile")));
            model.getInfo().put("jacoco_coverage_files", coverageData);
        }
    }

    private void detectProps(NbProjectInfoModel model) {
        HashMap nbprops = new HashMap();
        this.project.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(NB_PREFIX)).forEach(e -> nbprops.put(((String)e.getKey()).substring(NB_PREFIX.length()), String.valueOf(e.getValue())));
        model.getInfo().put("nbprops", nbprops);
    }

    private void detectSources(NbProjectInfoModel model) {
        boolean hasKotlin;
        long time = System.currentTimeMillis();
        boolean hasJava = this.project.getPlugins().hasPlugin("java-base");
        boolean hasGroovy = this.project.getPlugins().hasPlugin("groovy-base");
        boolean hasScala = this.project.getPlugins().hasPlugin("scala-base");
        boolean bl = hasKotlin = this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.android") || this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.js") || this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm");
        if (hasJava) {
            SourceSetContainer sourceSets = (SourceSetContainer)NbProjectInfoBuilder.getProperty(this.project, "sourceSets");
            if (sourceSets != null) {
                model.getInfo().put("sourcesets", NbProjectInfoBuilder.storeSet(sourceSets.getNames()));
                for (SourceSet sourceSet : sourceSets) {
                    String propBase = "sourceset_" + sourceSet.getName() + "_";
                    for (String lang : new String[]{"JAVA", "GROOVY", "SCALA", "KOTLIN"}) {
                        List compilerArgs;
                        Task compileTask = (Task)this.project.getTasks().findByName(sourceSet.getCompileTaskName(lang.toLowerCase()));
                        if (compileTask == null) continue;
                        model.getInfo().put(propBase + lang + "_source_compatibility", compileTask.property("sourceCompatibility"));
                        model.getInfo().put(propBase + lang + "_target_compatibility", compileTask.property("targetCompatibility"));
                        try {
                            compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "options", "allCompilerArgs");
                        }
                        catch (Throwable ex) {
                            try {
                                compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "options", "compilerArgs");
                            }
                            catch (Throwable ex2) {
                                compilerArgs = (List)NbProjectInfoBuilder.getProperty(compileTask, "kotlinOptions", "freeCompilerArgs");
                            }
                        }
                        model.getInfo().put(propBase + lang + "_compiler_args", new ArrayList(compilerArgs));
                    }
                    model.getInfo().put(propBase + "JAVA", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "java", "srcDirs")));
                    model.getInfo().put(propBase + "RESOURCES", NbProjectInfoBuilder.storeSet(sourceSet.getResources().getSrcDirs()));
                    if (hasGroovy) {
                        model.getInfo().put(propBase + "GROOVY", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "groovy", "srcDirs")));
                    }
                    if (hasScala) {
                        model.getInfo().put(propBase + "SCALA", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "scala", "srcDirs")));
                    }
                    if (hasKotlin) {
                        model.getInfo().put(propBase + "KOTLIN", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(NbProjectInfoBuilder.getProperty(sourceSet, "kotlin"), "srcDirs")));
                    }
                    this.sinceGradle("4.0", () -> {
                        LinkedHashSet<File> dirs = new LinkedHashSet<File>();
                        for (File dir : (ConfigurableFileCollection)NbProjectInfoBuilder.getProperty(sourceSet, "output", "classesDirs")) {
                            dirs.add(dir);
                        }
                        model.getInfo().put(propBase + "output_classes", dirs);
                    });
                    this.beforeGradle("4.0", () -> model.getInfo().put(propBase + "output_classes", Collections.singleton(NbProjectInfoBuilder.getProperty(sourceSet, "output", "classesDir"))));
                    model.getInfo().put(propBase + "output_resources", sourceSet.getOutput().getResourcesDir());
                    this.sinceGradle("5.2", () -> model.getInfo().put(propBase + "GENERATED", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "output", "generatedSourcesDirs", "files"))));
                    try {
                        model.getInfo().put(propBase + "classpath_compile", NbProjectInfoBuilder.storeSet(sourceSet.getCompileClasspath().getFiles()));
                        model.getInfo().put(propBase + "classpath_runtime", NbProjectInfoBuilder.storeSet(sourceSet.getRuntimeClasspath().getFiles()));
                    }
                    catch (Exception e) {
                        model.noteProblem(e);
                    }
                    this.sinceGradle("4.6", () -> {
                        try {
                            model.getInfo().put(propBase + "classpath_annotation", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "annotationProcessorPath", "files")));
                        }
                        catch (Exception e) {
                            model.noteProblem(e);
                        }
                        model.getInfo().put(propBase + "configuration_annotation", NbProjectInfoBuilder.getProperty(sourceSet, "annotationProcessorConfigurationName"));
                    });
                    this.beforeGradle("5.0", () -> {
                        if (model.getInfo().get(propBase + "classpath_annotation") == null || ((Collection)model.getInfo().get(propBase + "classpath_annotation")).isEmpty()) {
                            model.getInfo().put(propBase + "classpath_annotation", NbProjectInfoBuilder.storeSet(NbProjectInfoBuilder.getProperty(sourceSet, "compileClasspath", "files")));
                        }
                    });
                    this.beforeGradle("7.0", () -> {
                        model.getInfo().put(propBase + "configuration_compile", NbProjectInfoBuilder.getProperty(sourceSet, "compileClasspathConfigurationName"));
                        model.getInfo().put(propBase + "configuration_runtime", NbProjectInfoBuilder.getProperty(sourceSet, "runtimeClasspathConfigurationName"));
                    });
                }
            } else {
                model.getInfo().put("sourcesets", Collections.emptySet());
                model.noteProblem("No sourceSets found on this project. This project mightbe a Model/Rule based one which is not supported at the moment.");
            }
        }
        model.registerPerf("plugins", System.currentTimeMillis() - time);
    }

    private void detectArtifacts(NbProjectInfoModel model) {
        long time = System.currentTimeMillis();
        if (this.project.getPlugins().hasPlugin("java")) {
            model.getInfo().put("main_jar", NbProjectInfoBuilder.getProperty(this.project, "jar", "archivePath"));
        }
        if (this.project.getPlugins().hasPlugin("war")) {
            model.getInfo().put("main_war", NbProjectInfoBuilder.getProperty(this.project, "war", "archivePath"));
            model.getInfo().put("webapp_dir", NbProjectInfoBuilder.getProperty(this.project, "webAppDir"));
            model.getInfo().put("webxml", NbProjectInfoBuilder.getProperty(this.project, "war", "webXml"));
            try {
                model.getInfo().put("exploded_war_dir", NbProjectInfoBuilder.getProperty(this.project, "explodedWar", "destinationDir"));
            }
            catch (Exception e) {
                model.noteProblem(e);
            }
            try {
                model.getInfo().put("web_classpath", NbProjectInfoBuilder.getProperty(this.project, "war", "classpath", "files"));
            }
            catch (Exception e) {
                model.noteProblem(e);
            }
        }
        HashMap archives = new HashMap();
        this.project.getTasks().withType(Jar.class).forEach(jar -> archives.put(jar.getClassifier(), jar.getArchivePath()));
        model.getInfo().put("archives", archives);
        model.registerPerf("artifacts", System.currentTimeMillis() - time);
    }

    private static boolean resolvable(Configuration conf) {
        try {
            return (Boolean)NbProjectInfoBuilder.getProperty(conf, "canBeResolved");
        }
        catch (MissingPropertyException ex) {
            return true;
        }
    }

    private void detectDependencies(NbProjectInfoModel model) {
        long time = System.currentTimeMillis();
        HashSet ids = new HashSet();
        HashMap projects = new HashMap();
        HashMap unresolvedProblems = new HashMap();
        HashMap resolvedJvmArtifacts = new HashMap();
        Set<Configuration> visibleConfigurations = this.configurationsToSave();
        boolean ignoreUnresolvable = this.project.getPlugins().hasPlugin(JavaPlatformPlugin.class) && Boolean.TRUE.equals(NbProjectInfoBuilder.getProperty(this.project, "javaPlatform", "allowDependencies"));
        visibleConfigurations.forEach(it -> {
            String propBase = "configuration_" + it.getName() + "_";
            model.getInfo().put(propBase + "non_resolving", !NbProjectInfoBuilder.resolvable(it));
            model.getInfo().put(propBase + "transitive", it.isTransitive());
            model.getInfo().put(propBase + "extendsFrom", it.getExtendsFrom().stream().map(c -> c.getName()).collect(Collectors.toCollection(HashSet::new)));
            model.getInfo().put(propBase + "description", it.getDescription());
        });
        visibleConfigurations.forEach(it -> {
            HashSet componentIds = new HashSet();
            HashSet unresolvedIds = new HashSet();
            HashSet projectNames = new HashSet();
            long time_inspect_conf = System.currentTimeMillis();
            it.getDependencies().withType(ModuleDependency.class).forEach(it2 -> {
                String group = it2.getGroup() != null ? it2.getGroup() : "";
                String name = it2.getName();
                String version = it2.getVersion() != null ? it2.getVersion() : "";
                String id = group + ":" + name + ":" + version;
                componentIds.add(id);
            });
            if (NbProjectInfoBuilder.resolvable(it)) {
                try {
                    it.getIncoming().getResolutionResult().getAllDependencies().forEach(it2 -> {
                        ResolvedDependencyResult rdr;
                        if (it2 instanceof ResolvedDependencyResult && (rdr = (ResolvedDependencyResult)it2).getRequested() instanceof ModuleComponentSelector) {
                            ids.add(rdr.getSelected().getId());
                            if (rdr.getResolvedVariant() == null) {
                                componentIds.add(rdr.getSelected().getId().toString());
                            } else {
                                this.sinceGradle("6.8", () -> {
                                    if (!rdr.getResolvedVariant().getExternalVariant().isPresent()) {
                                        componentIds.add(rdr.getSelected().getId().toString());
                                    }
                                });
                            }
                        }
                        if (it2 instanceof UnresolvedDependencyResult) {
                            UnresolvedDependencyResult udr = (UnresolvedDependencyResult)it2;
                            String id = udr.getRequested().getDisplayName();
                            if (componentIds.contains(id)) {
                                unresolvedIds.add(id);
                            }
                            if (!ignoreUnresolvable && (it.isVisible() || it.isCanBeConsumed())) {
                                Throwable failure = ((UnresolvedDependencyResult)it2).getFailure();
                                if (this.project.getGradle().getStartParameter().isOffline()) {
                                    Throwable prev = null;
                                    for (Throwable t = failure; t != prev && t != null; t = t.getCause()) {
                                        if (t.getMessage().contains("available for offline")) {
                                            throw new NeedOnlineModeException("Need online mode", failure);
                                        }
                                        prev = t;
                                    }
                                }
                                unresolvedProblems.put(id, ((UnresolvedDependencyResult)it2).getFailure().getMessage());
                            }
                        }
                    });
                }
                catch (ResolveException ex) {
                    model.noteProblem(ex);
                }
            } else {
                unresolvedIds.addAll(componentIds);
                componentIds.clear();
            }
            String depBase = "dependency_inspect_" + it.getName();
            String depPrefix = depBase + "_";
            String configPrefix = "configuration_" + it.getName() + "_";
            long time_project_deps = System.currentTimeMillis();
            model.registerPerf(depPrefix + "module", time_project_deps - time_inspect_conf);
            it.getDependencies().withType(ProjectDependency.class).forEach(it2 -> {
                Project prj = it2.getDependencyProject();
                projects.put(prj.getPath(), prj.getProjectDir());
                projectNames.add(prj.getPath());
            });
            long time_file_deps = System.currentTimeMillis();
            model.registerPerf(depPrefix + "project", time_file_deps - time_project_deps);
            HashSet fileDeps = new HashSet();
            it.getDependencies().withType(FileCollectionDependency.class).forEach(it2 -> fileDeps.addAll(it2.resolve()));
            long time_collect = System.currentTimeMillis();
            model.registerPerf(depPrefix + "file", time_collect - time_file_deps);
            if (NbProjectInfoBuilder.resolvable(it)) {
                try {
                    Set arts = it.getResolvedConfiguration().getLenientConfiguration().getArtifacts();
                    arts.stream().forEach(a -> {
                        if (!(a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                            resolvedJvmArtifacts.putIfAbsent(a.getId().getComponentIdentifier().toString(), Collections.singleton(a.getFile()));
                        }
                    });
                    it.getResolvedConfiguration().getLenientConfiguration().getFirstLevelModuleDependencies(Specs.SATISFIES_ALL).forEach(rd -> NbProjectInfoBuilder.collectArtifacts(rd, resolvedJvmArtifacts));
                }
                catch (NullPointerException arts) {
                    // empty catch block
                }
            }
            long time_report = System.currentTimeMillis();
            model.registerPerf(depPrefix + "collect", time_report - time_collect);
            model.getInfo().put(configPrefix + "components", componentIds);
            model.getInfo().put(configPrefix + "projects", projectNames);
            model.getInfo().put(configPrefix + "files", fileDeps);
            model.getInfo().put(configPrefix + "unresolved", unresolvedIds);
            model.registerPerf(depPrefix + "file", System.currentTimeMillis() - time_report);
            model.registerPerf(depBase, System.currentTimeMillis() - time_inspect_conf);
        });
        long time_exclude = System.currentTimeMillis();
        visibleConfigurations.stream().forEach(it -> {
            String propBase = "configuration_" + it.getName() + "_";
            HashSet exclude = new HashSet();
            this.collectModuleDependencies(model, it.getName(), false, exclude);
            ((Set)model.getInfo().get(propBase + "components")).removeAll(exclude);
            ((Set)model.getInfo().get(propBase + "unresolved")).removeAll(exclude);
            ((Set)model.getInfo().get(propBase + "files")).removeAll(exclude);
        });
        model.registerPerf("excludes", System.currentTimeMillis() - time_exclude);
        model.registerPerf("offline", this.project.getGradle().getStartParameter().isOffline());
        HashMap<String, Set<File>> resolvedSourcesArtifacts = new HashMap<String, Set<File>>();
        HashMap<String, Set<File>> resolvedJavadocArtifacts = new HashMap<String, Set<File>>();
        if (this.project.getGradle().getStartParameter().isOffline() || this.project.hasProperty("downloadSources") || this.project.hasProperty("downloadJavadoc")) {
            String filter;
            ArrayList<Class> artifactTypes;
            long filter_time = System.currentTimeMillis();
            Set<Object> filteredIds = ids;
            ArrayList<Class> arrayList = artifactTypes = this.project.getGradle().getStartParameter().isOffline() ? new ArrayList<Class>(Arrays.asList(SourcesArtifact.class, JavadocArtifact.class)) : new ArrayList();
            if (this.project.hasProperty("downloadSources")) {
                filter = (String)NbProjectInfoBuilder.getProperty(this.project, "downloadSources");
                if (!"ALL".equals(filter)) {
                    filteredIds = ids.stream().filter(id -> id.toString().equals(filter)).collect(Collectors.toSet());
                    model.setMiscOnly(true);
                }
                artifactTypes.add(SourcesArtifact.class);
            }
            if (this.project.hasProperty("downloadJavadoc")) {
                filter = (String)NbProjectInfoBuilder.getProperty(this.project, "downloadJavadoc");
                if (!"ALL".equals(filter)) {
                    filteredIds = ids.stream().filter(id -> id.toString().equals(filter)).collect(Collectors.toSet());
                    model.setMiscOnly(true);
                }
                artifactTypes.add(JavadocArtifact.class);
            }
            long query_time = System.currentTimeMillis();
            model.registerPerf("dependencies_filter", query_time - filter_time);
            ArtifactResolutionResult result = this.project.getDependencies().createArtifactResolutionQuery().forComponents(filteredIds).withArtifacts(JvmLibrary.class, artifactTypes).execute();
            long collect_time = System.currentTimeMillis();
            model.registerPerf("dependencies_query", collect_time - query_time);
            for (ComponentArtifactsResult component : result.getResolvedComponents()) {
                Set javadocs;
                Set sources = component.getArtifacts(SourcesArtifact.class);
                if (!sources.isEmpty()) {
                    resolvedSourcesArtifacts.put(component.getId().toString(), NbProjectInfoBuilder.collectResolvedArtifacts(sources));
                }
                if ((javadocs = component.getArtifacts(JavadocArtifact.class)).isEmpty()) continue;
                resolvedJavadocArtifacts.put(component.getId().toString(), NbProjectInfoBuilder.collectResolvedArtifacts(javadocs));
            }
            model.registerPerf("dependencies_collect", System.currentTimeMillis() - collect_time);
        }
        model.getExt().put("resolved_jvm_artifacts", resolvedJvmArtifacts);
        model.getExt().put("resolved_sources_artifacts", resolvedSourcesArtifacts);
        model.getExt().put("resolved_javadoc_artifacts", resolvedJavadocArtifacts);
        model.getInfo().put("project_dependencies", projects);
        model.getInfo().put("unresolved_problems", unresolvedProblems);
        model.registerPerf("dependencies", System.currentTimeMillis() - time);
    }

    private static Set<File> collectResolvedArtifacts(Set<ArtifactResult> res) {
        return res.stream().filter(it -> it instanceof ResolvedArtifactResult).map(rar -> ((ResolvedArtifactResult)rar).getFile()).collect(Collectors.toCollection(HashSet::new));
    }

    private static void collectArtifacts(ResolvedDependency dep, Map<String, Set<File>> resolvedArtifacts) {
        String key = dep.getModuleGroup() + ":" + dep.getModuleName() + ":" + dep.getModuleVersion();
        if (!resolvedArtifacts.containsKey(key)) {
            resolvedArtifacts.put(key, dep.getModuleArtifacts().stream().map(r -> r.getFile()).collect(Collectors.toCollection(HashSet::new)));
            dep.getChildren().forEach(rd -> NbProjectInfoBuilder.collectArtifacts(rd, resolvedArtifacts));
        }
    }

    private void collectModuleDependencies(NbProjectInfoModel model, String configurationName, boolean includeRoot, Set deps) {
        String propBase = "configuration_" + configurationName + "_";
        if (includeRoot) {
            deps.addAll((Collection)model.getInfo().get(propBase + "components"));
            deps.addAll((Collection)model.getInfo().get(propBase + "files"));
            if (!model.getInfo().containsKey(propBase + "non_resolving")) {
                deps.addAll((Collection)model.getInfo().get(propBase + "unresolved"));
            }
        }
        ((Collection)model.getInfo().get(propBase + "extendsFrom")).forEach(it -> this.collectModuleDependencies(model, (String)it, true, deps));
    }

    private static <T extends Serializable> Set storeSet(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            throw new IllegalStateException("storeSet can only be used with Collections, but was: " + o.getClass().getName());
        }
        Collection c = (Collection)o;
        switch (c.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(c.iterator().next());
            }
        }
        return new LinkedHashSet(c);
    }

    private Set<Configuration> configurationsToSave() {
        return this.project.getConfigurations().matching(c -> !CONFIG_EXCLUDES_PATTERN.matcher(c.getName()).matches()).stream().flatMap(c -> c.getHierarchy().stream()).collect(Collectors.toSet());
    }

    private void sinceGradle(String version, Runnable r) {
        if (this.gradleVersion.compareTo(VersionNumber.parse((String)version)) >= 0) {
            r.run();
        }
    }

    private void beforeGradle(String version, Runnable r) {
        if (this.gradleVersion.compareTo(VersionNumber.parse((String)version)) < 0) {
            r.run();
        }
    }

    private static Object getProperty(Object obj, String ... propPath) {
        Object currentObject = obj;
        for (String prop : propPath) {
            currentObject = InvokerHelper.getPropertySafe((Object)currentObject, (String)prop);
        }
        return currentObject;
    }
}

