/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.io.File;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.mx.project.Jdks;
import org.netbeans.modules.java.mx.project.SuiteActionProvider;
import org.netbeans.modules.java.mx.project.SuiteClassPathProvider;
import org.netbeans.modules.java.mx.project.SuiteLogicalView;
import org.netbeans.modules.java.mx.project.SuiteProperties;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.modules.java.mx.project.suitepy.MxSuite;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class SuiteProject
implements Project {
    private final FileObject dir;
    private final Lookup lkp;
    private final MxSuite suite;
    private final FileObject suitePy;

    SuiteProject(FileObject dir, FileObject suitePy, MxSuite suite) {
        this.dir = dir;
        this.suite = suite;
        this.suitePy = suitePy;
        try {
            Jdks jdks = new Jdks(this);
            this.lkp = Lookups.fixed((Object[])new Object[]{this, new SuiteSources(this, jdks, dir, suite), new SuiteLogicalView(this), new SuiteClassPathProvider(this, jdks), new SuiteProperties(), new SuiteActionProvider(this)});
        }
        catch (RuntimeException ex) {
            throw (RuntimeException)Exceptions.attachMessage((Throwable)ex, (String)("Error parsing " + suitePy));
        }
    }

    public FileObject getProjectDirectory() {
        return this.dir;
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    final MxSuite getSuite() {
        return this.suite;
    }

    final SuiteSources getSources() {
        return (SuiteSources)this.lkp.lookup(SuiteSources.class);
    }

    void registerTask(Future<Integer> task) {
    }

    String getName() {
        return this.dir.getName();
    }

    public String toString() {
        return "MxProject[" + this.dir.getPath() + "]";
    }

    final FileObject getSuitePy() {
        return this.suitePy;
    }

    final FileObject getSuiteEnv() {
        FileObject dir = this.getProjectDirectory();
        FileObject suiteEnv = dir.getFileObject("mx." + dir.getNameExt() + "/env", false);
        return suiteEnv;
    }

    final FileObject getGlobalEnv() {
        FileObject userHome;
        String home = System.getProperty("user.home");
        if (home != null && (userHome = FileUtil.toFileObject((File)new File(home))) != null) {
            return userHome.getFileObject(".mx/env", false);
        }
        return null;
    }
}

