/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.editor.CompletionContext;
import org.netbeans.modules.j2ee.persistence.editor.JPAEditorUtil;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public abstract class PUCompletor {
    private int anchorOffset = -1;

    public abstract List<JPACompletionItem> doCompletion(CompletionContext var1);

    protected void setAnchorOffset(int anchorOffset) {
        this.anchorOffset = anchorOffset;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    private static String getProviderClass(Node tag) {
        String name = null;
        while (tag != null && !"persistence-unit".equals(tag.getNodeName())) {
            tag = tag.getParentNode();
        }
        if (tag != null) {
            for (Node ch = tag.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
                if (!"provider".equals(ch.getNodeName())) continue;
                name = ch.getFirstChild().getNodeValue();
            }
        }
        return name;
    }

    private static String getPropertyName(Node tag) {
        Node nmN;
        String name = null;
        while (tag != null && !"property".equals(tag.getNodeName())) {
            tag = tag.getParentNode();
        }
        if (tag != null && (nmN = tag.getAttributes().getNamedItem("name")) != null) {
            name = nmN.getNodeValue();
        }
        return name;
    }

    public static class PersistenceMappingFileCompletor
    extends PUCompletor {
        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String[] mappingFiles = this.getMappingFilesFromProject(context);
            for (int i = 0; i < mappingFiles.length; ++i) {
                if (!mappingFiles[i].startsWith(typedChars.trim())) continue;
                JPACompletionItem item = JPACompletionItem.createMappingFileItem(caretOffset - typedChars.length(), mappingFiles[i]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }

        private String[] getMappingFilesFromProject(CompletionContext context) {
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            return new String[0];
        }
    }

    public static class PersistencePropertyValueCompletor
    extends PUCompletor {
        private Map<Provider, Map<String, String[]>> allKeyAndValues;

        PersistencePropertyValueCompletor(Map<Provider, Map<String, String[]>> allKeyAndValues) {
            this.allKeyAndValues = allKeyAndValues;
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            String ver;
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String propertyName = PUCompletor.getPropertyName(context.getTag());
            if (propertyName == null || propertyName.equals("")) {
                return results;
            }
            String providerClass = PUCompletor.getProviderClass(context.getTag());
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            Provider provider = ProviderUtil.getProvider(providerClass, enclosingProject);
            String[] values = null;
            String string = ver = provider == null ? context.getDocumentContext().getVersion() : ProviderUtil.getVersion(provider);
            if (provider == null || ver != null && !"1.0".equals(ver)) {
                values = this.allKeyAndValues.get(null).get(propertyName);
            }
            if (provider != null && this.allKeyAndValues.get(provider) != null) {
                String[] tmp2 = this.allKeyAndValues.get(provider).get(propertyName);
                if (tmp2 != null) {
                    values = tmp2;
                }
                if (values == null && propertyName.equals(provider.getJdbcUrl())) {
                    DatabaseConnection[] cns;
                    for (DatabaseConnection cn : cns = ConnectionManager.getDefault().getConnections()) {
                        JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), cn.getDatabaseURL());
                        results.add(item);
                    }
                    results.add(new JPACompletionItem.AddConnectionElementItem());
                }
            }
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), values[i]);
                    results.add(item);
                }
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    public static class PersistencePropertyNameCompletor
    extends PUCompletor {
        private Map<Provider, Map<String, String[]>> allKeyAndValues;

        PersistencePropertyNameCompletor(Map<Provider, Map<String, String[]>> allKeyAndValues) {
            this.allKeyAndValues = allKeyAndValues;
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            String ver;
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String providerClass = PUCompletor.getProviderClass(context.getTag());
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            Provider provider = ProviderUtil.getProvider(providerClass, enclosingProject);
            ArrayList<String> keys = new ArrayList<String>();
            String string = ver = provider == null ? context.getDocumentContext().getVersion() : ProviderUtil.getVersion(provider);
            if (provider == null || ver != null && !"1.0".equals(ver)) {
                keys.addAll(this.allKeyAndValues.get(null).keySet());
            }
            if (provider != null && this.allKeyAndValues.get(provider) != null) {
                keys.addAll(this.allKeyAndValues.get(provider).keySet());
            }
            String[] itemTexts = keys.toArray(new String[0]);
            for (int i = 0; i < itemTexts.length; ++i) {
                if (!itemTexts[i].startsWith(typedChars.trim()) && !itemTexts[i].startsWith("javax.persistence." + typedChars.trim())) continue;
                JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), itemTexts[i]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    public static class PropertyCompletor
    extends PUCompletor {
        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            final ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            final int caretOffset = context.getCaretOffset();
            final String typedChars = context.getTypedPrefix();
            final String className = JPAEditorUtil.getClassName(context.getTag());
            if (className == null) {
                return Collections.emptyList();
            }
            try {
                JavaSource classJavaSrc = JPAEditorUtil.getJavaSource(context.getDocument());
                classJavaSrc.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElem = cc.getElements().getTypeElement(className);
                        if (typeElem == null) {
                            return;
                        }
                        List<? extends Element> clsChildren = typeElem.getEnclosedElements();
                        for (Element element : clsChildren) {
                            if (element.getKind() != ElementKind.FIELD) continue;
                            VariableElement elem = (VariableElement)element;
                            JPACompletionItem item = JPACompletionItem.createClassPropertyItem(caretOffset - typedChars.length(), elem, (ElementHandle<VariableElement>)ElementHandle.create((Element)elem), cc.getElements().isDeprecated(element));
                            results.add(item);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    public static class EntityClassCompletor
    extends PUCompletor {
        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            try {
                Document doc = context.getDocument();
                String typedChars = context.getTypedPrefix();
                JavaSource js = JPAEditorUtil.getJavaSource(doc);
                if (js == null) {
                    return Collections.emptyList();
                }
                FileObject fo = NbEditorUtilities.getFileObject((Document)context.getDocument());
                this.doJavaCompletion(fo, js, results, typedChars, context.getCurrentTokenOffset());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return results;
        }

        private void doJavaCompletion(final FileObject fo, JavaSource js, final List<JPACompletionItem> results, final String typedPrefix, final int substitutionOffset) throws IOException {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Project project = FileOwnerQuery.getOwner((FileObject)fo);
                    EntityClassScopeProvider provider = (EntityClassScopeProvider)project.getLookup().lookup(EntityClassScopeProvider.class);
                    EntityClassScope ecs = null;
                    Entity[] entities = null;
                    if (provider != null) {
                        ecs = provider.findEntityClassScope(fo);
                    }
                    if (ecs != null) {
                        entities = (Entity[])ecs.getEntityMappingsModel(false).runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Entity[]>(){

                            public Entity[] run(EntityMappingsMetadata metadata) throws Exception {
                                return metadata.getRoot().getEntity();
                            }
                        });
                    }
                    if (entities != null) {
                        for (Entity entity : entities) {
                            if (typedPrefix.length() != 0 && !entity.getClass2().toLowerCase().startsWith(typedPrefix.toLowerCase()) && !entity.getName().toLowerCase().startsWith(typedPrefix.toLowerCase())) continue;
                            JPACompletionItem item = JPACompletionItem.createAttribValueItem(substitutionOffset, entity.getClass2());
                            results.add(item);
                        }
                    }
                }
            }, true);
            this.setAnchorOffset(substitutionOffset);
        }
    }

    public static class AttributeValueCompletor
    extends PUCompletor {
        private String[] itemTexts;

        public AttributeValueCompletor(String[] itemTextAndDocs) {
            this.itemTexts = itemTextAndDocs;
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            for (int i = 0; i < this.itemTexts.length; ++i) {
                if (!this.itemTexts[i].startsWith(typedChars.trim())) continue;
                JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), this.itemTexts[i]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    static class ExUnlistedClassesCompletor
    extends PUCompletor {
        ExUnlistedClassesCompletor() {
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            for (String val : new String[]{"true", "false"}) {
                if (!val.toLowerCase().startsWith(typedChars.trim().toLowerCase())) continue;
                JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), val);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    static class ProviderCompletor
    extends PUCompletor {
        ProviderCompletor() {
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            HashSet<String> providers = new HashSet<String>();
            Project project = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            for (Provider provider : Util.getProviders(project)) {
                String cl = provider.getProviderClass();
                if (!cl.toLowerCase().startsWith(typedChars.trim().toLowerCase())) continue;
                providers.add(cl);
            }
            for (String cl : providers) {
                JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), cl);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }

    static class JtaDatasourceCompletor
    extends PUCompletor {
        JtaDatasourceCompletor() {
        }

        @Override
        public List<JPACompletionItem> doCompletion(CompletionContext context) {
            ArrayList<JPACompletionItem> results = new ArrayList<JPACompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            Project project = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            JPADataSourceProvider dsProvider = (JPADataSourceProvider)project.getLookup().lookup(JPADataSourceProvider.class);
            if (dsProvider != null) {
                for (JPADataSource val : dsProvider.getDataSources()) {
                    if (!val.getDisplayName().toLowerCase().startsWith(typedChars.trim().toLowerCase())) continue;
                    JPACompletionItem item = JPACompletionItem.createAttribValueItem(caretOffset - typedChars.length(), val.getDisplayName());
                    results.add(item);
                }
            }
            this.setAnchorOffset(context.getCurrentTokenOffset() + 1);
            return results;
        }
    }
}

