/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui.snippet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.source.ui.snippet.MarkupTag;
import org.netbeans.api.java.source.ui.snippet.SnippetMarkupTagExtractor;
import org.netbeans.api.java.source.ui.snippet.SourceLineMeta;

public class SnippetTagCommentParser {
    private static final String JAVA_LANG_SOURCE_LINE_START_PATTERN = "^(.*)(";
    private static final String MARKUPTAG_START_PATTERN = "(\\s*@\\s*\\w+.+?))$";
    private final SnippetMarkupTagExtractor extractor = new SnippetMarkupTagExtractor();
    private final Pattern markUpPattern = Pattern.compile("^(.*)(\\Q//\\E(\\s*@\\s*\\w+.+?))$");

    public List<SourceLineMeta> parse(String snippetDocComment) {
        ArrayList<SourceLineMeta> fullSourceLineInfo = new ArrayList<SourceLineMeta>();
        Matcher matcher = this.markUpPattern.matcher("");
        for (String snippetLine : this.computeLines(snippetDocComment)) {
            SourceLineMeta sourceLine = new SourceLineMeta();
            matcher.reset(snippetLine);
            sourceLine.setActualSourceLine(snippetLine);
            if (matcher.matches()) {
                sourceLine.setSourceLineWithoutComment(matcher.group(1));
                List<MarkupTag> markUpTags = this.extractor.extract(matcher.group(3));
                sourceLine.setThisLineMarkUpTags(markUpTags);
            }
            fullSourceLineInfo.add(sourceLine);
        }
        return fullSourceLineInfo;
    }

    private List<String> computeLines(String snippetComment) {
        BufferedReader buffReader = new BufferedReader(new StringReader(snippetComment));
        ArrayList<String> commentLine = new ArrayList<String>();
        String line = "";
        try {
            while ((line = buffReader.readLine()) != null) {
                commentLine.add(line);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SnippetTagCommentParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return commentLine;
    }
}

