/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TypeAnnotation {
    public final ConstantPool constant_pool;
    public final Position position;
    public final Annotation annotation;

    TypeAnnotation(ClassReader cr) throws IOException, Annotation.InvalidAnnotation {
        this.constant_pool = cr.getConstantPool();
        this.position = TypeAnnotation.read_position(cr);
        this.annotation = new Annotation(cr);
    }

    public TypeAnnotation(ConstantPool constant_pool, Annotation annotation, Position position) {
        this.constant_pool = constant_pool;
        this.position = position;
        this.annotation = annotation;
    }

    public int length() {
        int n = this.annotation.length();
        return n += TypeAnnotation.position_length(this.position);
    }

    public String toString() {
        try {
            return "@" + this.constant_pool.getUTF8Value(this.annotation.type_index).toString().substring(1) + " pos: " + this.position.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private static Position read_position(ClassReader cr) throws IOException, Annotation.InvalidAnnotation {
        int tag = cr.readUnsignedByte();
        if (!TargetType.isValidTargetTypeValue(tag)) {
            throw new Annotation.InvalidAnnotation("TypeAnnotation: Invalid type annotation target type value: " + String.format("0x%02X", tag));
        }
        TargetType type = TargetType.fromTargetTypeValue(tag);
        Position position = new Position();
        position.type = type;
        switch (type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                position.offset = cr.readUnsignedShort();
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                int table_length = cr.readUnsignedShort();
                position.lvarOffset = new int[table_length];
                position.lvarLength = new int[table_length];
                position.lvarIndex = new int[table_length];
                for (int i = 0; i < table_length; ++i) {
                    position.lvarOffset[i] = cr.readUnsignedShort();
                    position.lvarLength[i] = cr.readUnsignedShort();
                    position.lvarIndex[i] = cr.readUnsignedShort();
                }
                break;
            }
            case EXCEPTION_PARAMETER: {
                position.exception_index = cr.readUnsignedShort();
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                position.parameter_index = cr.readUnsignedByte();
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                position.parameter_index = cr.readUnsignedByte();
                position.bound_index = cr.readUnsignedByte();
                break;
            }
            case CLASS_EXTENDS: {
                position.type_index = cr.readUnsignedShort();
                break;
            }
            case THROWS: {
                position.type_index = cr.readUnsignedShort();
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                position.parameter_index = cr.readUnsignedByte();
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                position.offset = cr.readUnsignedShort();
                position.type_index = cr.readUnsignedByte();
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"TypeAnnotation: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("TypeAnnotation: Unknown target type: " + (Object)((Object)type)));
            }
        }
        int len = cr.readUnsignedByte();
        ArrayList<Integer> loc = new ArrayList<Integer>(len);
        for (int i = 0; i < len * 2; ++i) {
            loc.add(cr.readUnsignedByte());
        }
        position.location = Position.getTypePathFromBinary(loc);
        return position;
    }

    private static int position_length(Position pos) {
        int n = 0;
        ++n;
        switch (pos.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                n += 2;
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                n += 2;
                int table_length = pos.lvarOffset.length;
                n += 2 * table_length;
                n += 2 * table_length;
                n += 2 * table_length;
                break;
            }
            case EXCEPTION_PARAMETER: {
                n += 2;
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                ++n;
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                ++n;
                ++n;
                break;
            }
            case CLASS_EXTENDS: {
                n += 2;
                break;
            }
            case THROWS: {
                n += 2;
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                ++n;
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                n += 2;
                ++n;
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"TypeAnnotation: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("TypeAnnotation: Unknown target type: " + (Object)((Object)pos.type)));
            }
        }
        ++n;
        return n += 2 * pos.location.size();
    }

    public static class Position {
        public TargetType type = TargetType.UNKNOWN;
        public List<TypePathEntry> location = new ArrayList<TypePathEntry>(0);
        public int pos = -1;
        public boolean isValidOffset = false;
        public int offset = -1;
        public int[] lvarOffset = null;
        public int[] lvarLength = null;
        public int[] lvarIndex = null;
        public int bound_index = Integer.MIN_VALUE;
        public int parameter_index = Integer.MIN_VALUE;
        public int type_index = Integer.MIN_VALUE;
        public int exception_index = Integer.MIN_VALUE;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append((Object)this.type);
            switch (this.type) {
                case INSTANCEOF: 
                case NEW: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE: {
                    sb.append(", offset = ");
                    sb.append(this.offset);
                    break;
                }
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: {
                    if (this.lvarOffset == null) {
                        sb.append(", lvarOffset is null!");
                        break;
                    }
                    sb.append(", {");
                    for (int i = 0; i < this.lvarOffset.length; ++i) {
                        if (i != 0) {
                            sb.append("; ");
                        }
                        sb.append("start_pc = ");
                        sb.append(this.lvarOffset[i]);
                        sb.append(", length = ");
                        sb.append(this.lvarLength[i]);
                        sb.append(", index = ");
                        sb.append(this.lvarIndex[i]);
                    }
                    sb.append("}");
                    break;
                }
                case METHOD_RECEIVER: {
                    break;
                }
                case CLASS_TYPE_PARAMETER: 
                case METHOD_TYPE_PARAMETER: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: 
                case METHOD_TYPE_PARAMETER_BOUND: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    sb.append(", bound_index = ");
                    sb.append(this.bound_index);
                    break;
                }
                case CLASS_EXTENDS: {
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case THROWS: {
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case EXCEPTION_PARAMETER: {
                    sb.append(", exception_index = ");
                    sb.append(this.exception_index);
                    break;
                }
                case METHOD_FORMAL_PARAMETER: {
                    sb.append(", param_index = ");
                    sb.append(this.parameter_index);
                    break;
                }
                case CAST: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: {
                    sb.append(", offset = ");
                    sb.append(this.offset);
                    sb.append(", type_index = ");
                    sb.append(this.type_index);
                    break;
                }
                case METHOD_RETURN: 
                case FIELD: {
                    break;
                }
                case UNKNOWN: {
                    sb.append(", position UNKNOWN!");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown target type: " + (Object)((Object)this.type)));
                }
            }
            if (!this.location.isEmpty()) {
                sb.append(", location = (");
                sb.append(this.location);
                sb.append(")");
            }
            sb.append(", pos = ");
            sb.append(this.pos);
            sb.append(']');
            return sb.toString();
        }

        public boolean emitToClassfile() {
            return !this.type.isLocal() || this.isValidOffset;
        }

        public static List<TypePathEntry> getTypePathFromBinary(List<Integer> list) {
            ArrayList<TypePathEntry> loc = new ArrayList<TypePathEntry>(list.size() / 2);
            for (int idx = 0; idx < list.size(); idx += 2) {
                if (idx + 1 == list.size()) {
                    throw new AssertionError((Object)("Could not decode type path: " + list));
                }
                loc.add(TypePathEntry.fromBinary(list.get(idx), list.get(idx + 1)));
            }
            return loc;
        }

        public static List<Integer> getBinaryFromTypePath(List<TypePathEntry> locs) {
            ArrayList<Integer> loc = new ArrayList<Integer>(locs.size() * 2);
            for (TypePathEntry tpe : locs) {
                loc.add(tpe.tag.tag);
                loc.add(tpe.arg);
            }
            return loc;
        }

        public static class TypePathEntry {
            public static final int bytesPerEntry = 2;
            public final TypePathEntryKind tag;
            public final int arg;
            public static final TypePathEntry ARRAY = new TypePathEntry(TypePathEntryKind.ARRAY);
            public static final TypePathEntry INNER_TYPE = new TypePathEntry(TypePathEntryKind.INNER_TYPE);
            public static final TypePathEntry WILDCARD = new TypePathEntry(TypePathEntryKind.WILDCARD);

            private TypePathEntry(TypePathEntryKind tag) {
                if (tag != TypePathEntryKind.ARRAY && tag != TypePathEntryKind.INNER_TYPE && tag != TypePathEntryKind.WILDCARD) {
                    throw new AssertionError((Object)("Invalid TypePathEntryKind: " + (Object)((Object)tag)));
                }
                this.tag = tag;
                this.arg = 0;
            }

            public TypePathEntry(TypePathEntryKind tag, int arg) {
                if (tag != TypePathEntryKind.TYPE_ARGUMENT) {
                    throw new AssertionError((Object)("Invalid TypePathEntryKind: " + (Object)((Object)tag)));
                }
                this.tag = tag;
                this.arg = arg;
            }

            public static TypePathEntry fromBinary(int tag, int arg) {
                if (arg != 0 && tag != TypePathEntryKind.TYPE_ARGUMENT.tag) {
                    throw new AssertionError((Object)("Invalid TypePathEntry tag/arg: " + tag + "/" + arg));
                }
                switch (tag) {
                    case 0: {
                        return ARRAY;
                    }
                    case 1: {
                        return INNER_TYPE;
                    }
                    case 2: {
                        return WILDCARD;
                    }
                    case 3: {
                        return new TypePathEntry(TypePathEntryKind.TYPE_ARGUMENT, arg);
                    }
                }
                throw new AssertionError((Object)("Invalid TypePathEntryKind tag: " + tag));
            }

            public String toString() {
                return this.tag.toString() + (this.tag == TypePathEntryKind.TYPE_ARGUMENT ? "(" + this.arg + ")" : "");
            }

            public boolean equals(Object other) {
                if (!(other instanceof TypePathEntry)) {
                    return false;
                }
                TypePathEntry tpe = (TypePathEntry)other;
                return this.tag == tpe.tag && this.arg == tpe.arg;
            }

            public int hashCode() {
                return this.tag.hashCode() * 17 + this.arg;
            }
        }

        public static enum TypePathEntryKind {
            ARRAY(0),
            INNER_TYPE(1),
            WILDCARD(2),
            TYPE_ARGUMENT(3);

            public final int tag;

            private TypePathEntryKind(int tag) {
                this.tag = tag;
            }
        }
    }

    public static final class TargetType
    extends Enum<TargetType> {
        public static final /* enum */ TargetType CLASS_TYPE_PARAMETER;
        public static final /* enum */ TargetType METHOD_TYPE_PARAMETER;
        public static final /* enum */ TargetType CLASS_EXTENDS;
        public static final /* enum */ TargetType CLASS_TYPE_PARAMETER_BOUND;
        public static final /* enum */ TargetType METHOD_TYPE_PARAMETER_BOUND;
        public static final /* enum */ TargetType FIELD;
        public static final /* enum */ TargetType METHOD_RETURN;
        public static final /* enum */ TargetType METHOD_RECEIVER;
        public static final /* enum */ TargetType METHOD_FORMAL_PARAMETER;
        public static final /* enum */ TargetType THROWS;
        public static final /* enum */ TargetType LOCAL_VARIABLE;
        public static final /* enum */ TargetType RESOURCE_VARIABLE;
        public static final /* enum */ TargetType EXCEPTION_PARAMETER;
        public static final /* enum */ TargetType INSTANCEOF;
        public static final /* enum */ TargetType NEW;
        public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE;
        public static final /* enum */ TargetType METHOD_REFERENCE;
        public static final /* enum */ TargetType CAST;
        public static final /* enum */ TargetType CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT;
        public static final /* enum */ TargetType METHOD_INVOCATION_TYPE_ARGUMENT;
        public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT;
        public static final /* enum */ TargetType METHOD_REFERENCE_TYPE_ARGUMENT;
        public static final /* enum */ TargetType UNKNOWN;
        private static final int MAXIMUM_TARGET_TYPE_VALUE = 75;
        private final int targetTypeValue;
        private final boolean isLocal;
        private static final TargetType[] targets;
        private static final /* synthetic */ TargetType[] $VALUES;

        public static TargetType[] values() {
            return (TargetType[])$VALUES.clone();
        }

        public static TargetType valueOf(String name) {
            return Enum.valueOf(TargetType.class, name);
        }

        private TargetType(int targetTypeValue) {
            this(targetTypeValue, false);
        }

        private TargetType(int targetTypeValue, boolean isLocal) {
            if (targetTypeValue < 0 || targetTypeValue > 255) {
                throw new AssertionError((Object)("Attribute type value needs to be an unsigned byte: " + String.format("0x%02X", targetTypeValue)));
            }
            this.targetTypeValue = targetTypeValue;
            this.isLocal = isLocal;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public int targetTypeValue() {
            return this.targetTypeValue;
        }

        public static boolean isValidTargetTypeValue(int tag) {
            if (tag == TargetType.UNKNOWN.targetTypeValue) {
                return true;
            }
            return tag >= 0 && tag < targets.length;
        }

        public static TargetType fromTargetTypeValue(int tag) {
            if (tag == TargetType.UNKNOWN.targetTypeValue) {
                return UNKNOWN;
            }
            if (tag < 0 || tag >= targets.length) {
                throw new AssertionError((Object)("Unknown TargetType: " + tag));
            }
            return targets[tag];
        }

        private static /* synthetic */ TargetType[] $values() {
            return new TargetType[]{CLASS_TYPE_PARAMETER, METHOD_TYPE_PARAMETER, CLASS_EXTENDS, CLASS_TYPE_PARAMETER_BOUND, METHOD_TYPE_PARAMETER_BOUND, FIELD, METHOD_RETURN, METHOD_RECEIVER, METHOD_FORMAL_PARAMETER, THROWS, LOCAL_VARIABLE, RESOURCE_VARIABLE, EXCEPTION_PARAMETER, INSTANCEOF, NEW, CONSTRUCTOR_REFERENCE, METHOD_REFERENCE, CAST, CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, METHOD_INVOCATION_TYPE_ARGUMENT, CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, METHOD_REFERENCE_TYPE_ARGUMENT, UNKNOWN};
        }

        static {
            TargetType[] alltargets;
            CLASS_TYPE_PARAMETER = new TargetType(0);
            METHOD_TYPE_PARAMETER = new TargetType(1);
            CLASS_EXTENDS = new TargetType(16);
            CLASS_TYPE_PARAMETER_BOUND = new TargetType(17);
            METHOD_TYPE_PARAMETER_BOUND = new TargetType(18);
            FIELD = new TargetType(19);
            METHOD_RETURN = new TargetType(20);
            METHOD_RECEIVER = new TargetType(21);
            METHOD_FORMAL_PARAMETER = new TargetType(22);
            THROWS = new TargetType(23);
            LOCAL_VARIABLE = new TargetType(64, true);
            RESOURCE_VARIABLE = new TargetType(65, true);
            EXCEPTION_PARAMETER = new TargetType(66, true);
            INSTANCEOF = new TargetType(67, true);
            NEW = new TargetType(68, true);
            CONSTRUCTOR_REFERENCE = new TargetType(69, true);
            METHOD_REFERENCE = new TargetType(70, true);
            CAST = new TargetType(71, true);
            CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = new TargetType(72, true);
            METHOD_INVOCATION_TYPE_ARGUMENT = new TargetType(73, true);
            CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = new TargetType(74, true);
            METHOD_REFERENCE_TYPE_ARGUMENT = new TargetType(75, true);
            UNKNOWN = new TargetType(255);
            $VALUES = TargetType.$values();
            targets = new TargetType[76];
            for (TargetType target : alltargets = TargetType.values()) {
                if (target.targetTypeValue == TargetType.UNKNOWN.targetTypeValue) continue;
                TargetType.targets[target.targetTypeValue] = target;
            }
            for (int i = 0; i <= 75; ++i) {
                if (targets[i] != null) continue;
                TargetType.targets[i] = UNKNOWN;
            }
        }
    }
}

